<?php 
/**
 * The Comment section for SKT Man
 *
 * Displays the Comment section in posts and pages.
 *
 * @package SKT Man
 * 
 * @since SKT Man 1.0
 */
global $complete;?>

<?php
	//If Password Protected, DO NOT LOAD
	if ( post_password_required() ) { ?>
	<p class="nocomments"><?php _e('This post is password protected. Enter the password to view comments.', 'complete'); ?></p>
	<?php
	return;
	}
?>
 
<!-- THE COMMENTS/PING TEMPLATE START -->
<?php if ( have_comments() ) : ?>
<?php if ( ! empty($comments_by_type['comment']) ) : ?>

    <!--COMMENT RESPONSE COUNT START-->
        
    <!--COMMENT RESPONSE COUNT END-->
    
     
    <!--COMMENTS LIST START--> 
        <ul class="commentlist">	
            <!--Comments callback from functions.php-->
            <?php wp_list_comments('type=comment&callback=complete_comment');?>
        </ul>
    
        <!--Comments page navigation-->
        <div class="navigation">
        <?php paginate_comments_links( array('prev_text' => '&laquo;', 'next_text' => '&raquo;')) ?> 
        </div>
    <!--COMMENTS LIST END-->


<?php endif; ?>

<!--PINGS START-->
<?php if ( ! empty($comments_by_type['pings']) ) : ?>

	<!--PINGS Title-->
    <h3 id="comments_ping"><?php _e('Trackbacks &amp; Pings', 'complete'); ?></h3>
     
    <!--PINGS LIST START--> 
        <ul class="commentlist" id="ping">
        <?php wp_list_comments('type=pings&callback=complete_ping'); ?>
        </ul>
        
        <div class="navigation"><?php paginate_comments_links( array('prev_text' => '&laquo;', 'next_text' => '&raquo;')) ?></div>
    <!--PINGS LIST END-->

<?php endif; ?>
<!--PINGS END-> 



<?php else : // this is displayed if there are no comments so far ?>
 
<?php if ('open' == $post->comment_status) : ?>
<!-- If comments are open, but there are no comments. -->
 
<?php else : // comments are closed ?>
<!-- If comments are closed. -->
<?php if ( !is_page() ) { ?><p class="nocomments"><?php _e('Comments are closed.', 'complete'); ?></p><?php } ?>
 
<?php endif; ?>
<?php endif; ?>
 

<!--COMMENT FORM START--> 
	  <?php if ('open' == $post->comment_status) : ?>
     <div id="respond">
     <div class="commentSeprator"><span>Write A Comment</span></div>
     <div class="cancel-comment-reply">
				<small><?php cancel_comment_reply_link(); ?></small>
			</div>
     <?php if ( get_option('comment_registration') && !$user_ID ) : ?>
			<p>You must be <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>">logged in</a> to post a comment.</p>
    <?php else : ?>
     <form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
     <?php if ( $user_ID ) : ?>
		<p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Log out &raquo;</a></p>
     <?php else : ?>
      <div class="form-group">
		<div class="blogFrm_col">
			<input type="text" name="author" id="author" class="form-control" placeholder="Enter Your FullName" value="<?php echo $comment_author; ?>" size="22" tabindex="1" required/>
		</div>
		<div class="blogFrm_col2">
			<input type="text" name="email" id="email" class="form-control" placeholder="Enter yor EmailAddress" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" required/>
		</div>
	 </div>
     <?php endif; ?>
		<div class="form-group">
			<textarea name="comment" id="comment" class="form-control textarea_fld" cols="100%" placeholder="Enter Comments" rows="5" tabindex="4" required ></textarea>
		</div>
		
		<?php comment_id_fields(); ?>
		<?php do_action('comment_form', $post->ID); ?>
     </form>
     <p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"> <label for="wp-comment-cookies-consent">Save my name, email, and website in this browser for the next time I comment.</label></p>
     
     <input name="submit" type="submit" id="submit" class="submitBtn" tabindex="5" value="Submit Comment" />
    <?php endif; // If registration required and not logged in ?>
    </div>
     <?php endif; // if you delete this the sky will fall on your head ?>
<!--COMMENT FORM END--> 
