<?php
/**
 * The MAIN FUNCTIONS FILE for SKT Man
 *
 * Stores all the Function of the template.
 *
 * @package SKT Man
 * 
 * @since SKT Man 1.0
 */

//**************Complete Golbal******************//
/*CHECK IF Complete row exist in the wp_options table. Needed for Redux Conversion process*/ 
$completedb = get_option( 'complete' );

//**************Complete SETUP******************//
function Complete_setup() {
	//add_theme_support( 'custom-header' );
	add_theme_support( 'title-tag' );			//WP 4.1 Site Title
	add_theme_support( 'woocommerce' );			//Woocommerce Support
	add_theme_support('automatic-feed-links');	//RSS FEED LINK
	add_theme_support( 'post-thumbnails' );		//Post Thumbnail
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
	//Custom Background	
	add_theme_support( 'custom-background', array( 'default-color' => 'ffffff') );	
	//Make theme available for translation
	load_theme_textdomain('complete', get_template_directory() . '/languages/');  
	//Custom Thumbnail Size	
	add_image_size( 'complete_thumb', 400, 270, true ); /*(cropped)*/
	add_image_size( 'footerthumb', 50, 42, true ); 
   
	//Register Menus
	register_nav_menus( array(
			'primary' => __( 'Header Navigation', 'complete' ),
		) );
	}
add_action( 'after_setup_theme', 'Complete_setup' );

/* Init sktbuilder libs */
add_filter( 'sktbuilder_libs', 'skt_add_theme_lib', 10, 2 );
if ( ! function_exists( 'skt_add_theme_lib' ) ) {
  /**
   * Adding skt lib in sktbuilder libs
   *
   * @param array $sktbuilder_libs Array with url to sktbuilder lib.
   */
   function skt_add_theme_lib( $sktbuilder_libs ) {
  array_push( $sktbuilder_libs, get_template_directory() . '/blocks/lib.json' );
  return $sktbuilder_libs;
  }
}

//**************Complete FUNCTIONS******************//
require(get_template_directory() . '/sktframe/core-functions.php');			//Include Complete sktframe Core Functions 
require(get_template_directory() . '/lib/functions/core.php');					//Include Core Functions
require(get_template_directory() . '/lib/functions/enqueue.php');					//Include Enqueue CSS/JS Scripts
require(get_template_directory() . '/lib/functions/admin.php');				//Include Admin Functions (admin)
require(get_template_directory() . '/lib/functions/woocommerce.php');			//Include Woocommerce Functions
require(get_template_directory() . '/lib/functions/defaults.php');
require(get_template_directory() . '/customizer/customizer.php');
require(get_template_directory() . '/lib/functions/converter.php');
require(get_template_directory() . '/lib/includes/google_fonts.php');

//WIDGETS
require(get_template_directory() . '/sktframe/core-posts.php');		
require(get_template_directory() . '/sktframe/core-pagination.php');

/* Dashboard info
 */
require_once( trailingslashit( get_template_directory() ) . 'lib/dashboard.php' );

if ( !function_exists( 'skt_complete_is_extra_activated' ) ) {

/* Query SKT Complete extra activation
   */
  function skt_complete_is_extra_activated() {
    return defined( 'SKT_COMPLETE_EXTRA_CURRENT_VERSION' ) ? true : false;
  }

}
 
/* Register TGM Plugin Activation
 */
if ( is_admin() ) {

  require_once( trailingslashit( get_template_directory() ) . 'lib/skt-complete-plugin-install.php' );
}

/* Import Demo Data
 */
 //add_post_type_support( 'practice_area', 'thumbnail' ); 
//add_post_type_support( 'knowledge_center', 'thumbnail' ); 
  add_post_type_support( 'team', 'thumbnail' ); 
    add_post_type_support( 'jobs', 'thumbnail' ); 
     add_post_type_support( 'projects', 'thumbnail' ); 
    function create_posttype() { 
	//	register_post_type( 'knowledge_center',
    // array(
//
         //   'labels' => array(
               // 'name' => __( 'Knowledge Centre' ),
              //  'singular_name' => __( 'knowledge_center' ),
           // ),
           // 'public' => true,
         //   'has_archive' => true,
          //  'rewrite' => array('slug' => 'knowledge_center')            
       // )
    //);
   
    register_post_type( 'team',
     array(

            'labels' => array(
                'name' => __( 'Team Member' ),
                'singular_name' => __( 'team' ),
                
            ),
            'public' => true,
            'has_archive' => true,
           'rewrite' => array('slug' => 'team')            
        )
    );
     //register_post_type( 'law_services',
    // array(

           // 'labels' => array(
               // 'name' => __( 'Law Services' ),
               //'singular_name' => __( 'law_services' ),
                
           // ),
            //'public' => true,
           // 'has_archive' => true,
         //  'rewrite' => array('slug' => 'law_services')            
       // )
   // );
    register_post_type( 'jobs',
     array(

            'labels' => array(
                'name' => __( 'Jobs' ),
                'singular_name' => __( 'jobs' ),
                
            ),
            'public' => true,
            'has_archive' => true,
           'rewrite' => array('slug' => 'jobs')            
        )
    );
     register_post_type( 'projects',
     array(

            'labels' => array(
                'name' => __( 'Projects' ),
                'singular_name' => __( 'projects' ),
                
            ),
            'public' => true,
            'has_archive' => true,
           'rewrite' => array('slug' => 'projects')            
        )
    );
	}
add_action( 'init', 'create_posttype' );
function practice_area() { 
$args = array(
	'post_type' => 'page',
	'posts_per_page' => '20',
	'order' => 'DESC'
	);
	  $my_posts = new WP_Query( $args );
ob_start(); ?>


<div class="practice_area">
  <ul>
    <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
    <?php $practice_area_page= get_field('practice_area_page');?>
    <?//php $practice_area= get_field('main_practice_area');?>
    <?php if($practice_area_page =='Yes'){?>
    <li>
      <div class="elementor-image">
        <?php $image = get_field('practice_icons');?>
        <?php echo wp_get_attachment_image($image['id'], array('700', '600'),false, array( "class" => "" ) );?> </div>
      <div class="practice_title">
        <h3>
          <?php the_title();?>
        </h3>
      </div>
      <div class="content">
       <?php $short_description= get_field('short_description');?>
       <?php $article_data = substr($short_description, 0, 100);
		echo $article_data; ?>
      </div>
      <a class="more" style="background-color: #ffffff;" href="<?php the_permalink();?>">More</a> </li>
      <?php }?>
    <?php endwhile;
 	   wp_reset_query();?>
  </ul>
</div>
<?php $content =  ob_get_clean();
    return $content;
     
}
add_shortcode("practice_area", "practice_area"); 
function other_practice($pageid) {
	
$args = array(
	'post_type' => 'page',
	'posts_per_page' => '50',
	'post__not_in' => array($pageid['id']),
	'order' => 'DESC'
	);
	
	  $my_posts = new WP_Query( $args );
	 /* echo "<pre>";
	print_r($my_posts);
	echo "</pre>";*/
ob_start(); ?>
  <!--h4><?//php $title = the_title();?></h4-->
<div class="other_practice">

  <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
   <?php $practice_area_page= get_field('practice_area_page');?>
    <?//php $practice_area= get_field('main_practice_area');?>
    <?php if($practice_area_page =='Yes'){?>
  <div>
	 
    <?//php $practice_area= get_field('main_practice_area');?>
    <div class="elementor-image">
      <?php $image = get_field('practice_icons');?>
      <?php echo wp_get_attachment_image($image['id'], array('700', '600'),false, array( "class" => "" ) );?> </div>
    <div class="practice_title">
      <h3>
        <a href="<?php the_permalink();?>"><?php the_title();?></a>
      </h3>
    </div>
    <div class="content">
		<?php $short_description= get_field('short_description');?>
      <?php $article_data = substr($short_description, 0, 100);
      
		echo $article_data; ?>
    </div>
    <a class="read_more" style="background-color: #ffffff;" href="<?php the_permalink();?>">More</a> </div>
    <?php }?>
  <?php endwhile;
 	   wp_reset_query();?>
</div>
<?php $content =  ob_get_clean();
    return $content;
     
}
add_shortcode("other_practice", "other_practice");
function knowledge_center() { 
$args = array(
	'post_type' => 'post',
	'posts_per_page' => '8',
	'order' => 'ASC'
	);
	  $my_posts = new WP_Query( $args );
	  ob_start(); 
	  ?>
<div class="knowledge_center">
  <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
  <div>
    <div class="featured-image">
      <?php the_post_thumbnail(); ?>
    </div>
    <div class="date">
      <?php $post_date = get_the_date( 'j  M' ); echo $post_date;?>
    </div>
    <h3>
      <?php the_title();?>
    </h3>
    <p>
      <?php $article_data = substr(strip_tags(get_the_content()), 0, 100);
		echo $article_data; ?>
    </p>
    <a class="read_more" style="background-color: #ffffff;" href="<?php the_permalink();?>">Read More</a> </div>
  <?php endwhile;
 	   wp_reset_query();?>
</div>
<?php $knowledge_content =  ob_get_clean();
    return $knowledge_content;
     
}
add_shortcode("knowledge_center", "knowledge_center");
function knowledge_corporate() { 
$args = array(
	'post_type' => 'post',
	'posts_per_page' => '12',
	'order' => 'ASC'
	);
	  $my_posts = new WP_Query( $args );
	  ob_start(); 
	  ?>
<div class="knowledge_corporate">
  <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
  <div>
    <div class="date">
      <?php $post_date = get_the_date( 'jS M Y' ); echo $post_date;?>
    </div>
    <h3>
      <a href="<?php the_permalink();?>"><?php the_title();?></a>
    </h3>
    <p>
      <?php $article_data = substr(strip_tags(get_the_content()), 0, 100);
		echo $article_data; ?>
    </p>
    <a class="read_more" style="background-color: #ffffff;" href="<?php the_permalink();?>">More</a> </div>
  <?php endwhile;
 	   wp_reset_query();?>
</div>
<?php $knowledge_content =  ob_get_clean();
    return $knowledge_content;
     
}
add_shortcode("knowledge_corporate", "knowledge_corporate");


function knowledge_Constitutional() { 
$args = array(
	'post_type' => 'post',
	'posts_per_page' => '12',
	'order' => 'ASC'
	);
	  $my_posts = new WP_Query( $args );
	  ob_start(); 
	  ?>
<div class="knowledge_Constitutional">
  <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
  <div>
    <div class="featured-image">
      <?php the_post_thumbnail(); ?>
    </div>
    <h3>
      <?php the_title();?>
    </h3>
    <p>
      <?php $article_data = substr(strip_tags(get_the_content()), 0, 100);
		echo $article_data; ?>
    </p>
    <a class="read_more" style="background-color: #ffffff;" href="<?php the_permalink();?>">Read More</a> </div>
  <?php endwhile;
 	   wp_reset_query();?>
</div>
<?php $knowledge_Constitutional =  ob_get_clean();
    return $knowledge_Constitutional;
     
}
add_shortcode("knowledge_Constitutional", "knowledge_Constitutional");
function team() { 
$args = array(
	'post_type' => 'team',
	'posts_per_page' => '4',
	'meta_key'	=> 'position_number',
	'orderby'	=> 'meta_value',
    'order' => 'Asc'
	
	);
	  $my_posts = new WP_Query( $args );
	  ob_start(); 
	  ?>
<div class="team">
  <ul>
    <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
    <?php $main_team = get_field('main_team_home');?>
    <?php if($main_team =='Yes'){?>
    <li>
      <div class="img_sec">
        <div class="featured-image"> <a href="<?php the_permalink();?>">
          <?php the_post_thumbnail(); ?>
          </a></div>
        <div class="team-name">
          <?php the_title();?>
        </div>
        <div class="position"><?php echo get_field('position');?></div>
        <div class="social-icon">
          <?php $link= get_field('social_icons');?>
          <a href="<?php echo $link; ?>" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a> </div>
      </div>
      <h4>Practice Area:</h4>
      <?php
 $featured_post = get_field('practice_areas');
foreach($featured_post as $post){
	//print_r($post)?>
      <div class="details">
        <div class="team-practice"><?php echo "-". '<a href="'. esc_url( get_page_link( $post->ID ) ) .'">'.$post->post_title.'</a>'."</br>";?> </div>
      </div>
      <?php } ?>
    </li>
    <?php }
//echo $post_id	= $featured_post->ID;?>
    <?php endwhile;
 	   wp_reset_query();?>
  </ul>
</div>
<?php $team =  ob_get_clean();
    return $team;
     
}
add_shortcode("team", "team");
function aboutus_team() { 
$args = array(
	'post_type' => 'team',
	'posts_per_page' => '4',
	'meta_key'	=> 'position_number',
	'orderby'	=> 'meta_value',
    'order' => 'Asc'
	
	);
	  $my_posts = new WP_Query( $args );
	  ob_start(); 
	  ?>
<div class="team">
  <ul>
    <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
    <?php $main_team = get_field('main_team_home');?>
    <?php if($main_team =='Yes'){?>
    <li>
      <div class="img_sec">
        <div class="featured-image"> <a href="<?php the_permalink();?>">
          <?php the_post_thumbnail(); ?>
          </a></div>
        <div class="team-name">
          <?php the_title();?>
        </div>
        <div class="position"><?php echo get_field('position');?></div>
        <div class="content">
        <?php $article_data = substr(strip_tags(get_the_content()), 0, 100);
		echo $article_data; ?>
         </div>
         <a class="read_more" style="background-color: #ffffff;" href="<?php the_permalink();?>">More</a>
         <div class="social-icon">
          <?php $link= get_field('social_icons');?>
          <a href="<?php echo $link; ?>" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a> </div>
      </div>
   
    </li>
    <?php }
//echo $post_id	= $featured_post->ID;?>
    <?php endwhile;
 	   wp_reset_query();?>
  </ul>
</div>
<?php $aboutus_team =  ob_get_clean();
    return $aboutus_team;
     
}
add_shortcode("aboutus_team", "aboutus_team");
function senior_teams() { 
$args = array(
	'post_type' => 'team',
	//'posts_per_page' => '3',
	'meta_key'			=> 'position_number',
	'orderby'			=> 'meta_value',
    'order' => 'Asc'
	 );
	  $my_posts = new WP_Query( $args );
	  ob_start(); 
	  ?>
<div class="senior_team">
  <ul>
    <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
    <?php $position = get_field('position');?>
    <?php if (strpos($position, 'Partner') !== false)
    { ?>
    <li>
      <div class="img_sec">
        <div class="featured-image"> 
          <a href="<?php the_permalink();?>">
          <?php the_post_thumbnail(); ?>
          </a>
            <div class="social-icon">
              <?php $link= get_field('social_icons');?>
              <a href="<?php echo $link; ?>" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a> </div>
          </div>
        </div>
        <div class="team-title">
          <?php the_title();?>
        </div>
        <div class="team-position"><?php echo $position;?>
          
      </div>
      <h4>Practice Area:</h4>
      <?php
 $featured_post = get_field('practice_areas');
foreach($featured_post as $post){?>
      <div class="details">
        <div class="team-practice"> <?php echo "-". '<a href="'. esc_url( get_page_link( $post->ID ) ) .'">'.$post->post_title.'</a>'."</br>";?> </div>
      </div>
      <?php } ?>
    </li>
    <?php }
	 endwhile;
 	   wp_reset_query();?>
  </ul>
</div>
<?php $senior_team =  ob_get_clean();
    return $senior_team;
     
}
add_shortcode("senior_teams", "senior_teams");
function managing_associates() { 
	$args = array(
	'post_type' => 'team',
	//'posts_per_page' => '4',
	'meta_key'			=> 'position_number',
	'orderby'			=> 'meta_value',
    'order' => 'Asc'
	 );
	  $my_posts = new WP_Query( $args );
	  ob_start(); 
	  ?>
<div class="managing_associates">
  <ul>
    <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
    <?php $position = get_field('position');?>
    <?php if($position=='Managing Associate'){?>
    <li>
      <div class="img_sec">
        <div class="featured-image"> <a href="<?php the_permalink();?>">
          <?php the_post_thumbnail(); ?>
          </a>
          <div class="social-icon">
            <?php $link= get_field('social_icons');?>
            <a href="<?php echo $link; ?>" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a> 
          </div>
        </div>
        <div class="team-title">
          <?php the_title();?>
        </div>
        <div class="team-position"><?php echo $position;?>          
        </div>
      </div>
      <h4>Practice Area:</h4>
      <?php
 $featured_post = get_field('practice_areas');
foreach($featured_post as $post){?>
      <div class="details">
        <div class="team-practice"> <?php echo "-". '<a href="'. esc_url( get_page_link( $post->ID ) ) .'">'.$post->post_title.'</a>'."</br>";?> </div>
      </div>
      <?php } ?>
    </li>
    <?php }
	 endwhile;
 	   wp_reset_query();?>
  </ul>
</div>
<?php $managing_associates =  ob_get_clean();
    return $managing_associates;
     
}
add_shortcode("managing_associates", "managing_associates");
function law_services() { 
	 
	global $wp_query;
	 $parant_id= $wp_query->post->ID;
$args = array(
 'post_parent' => $parant_id,
	'post_type' => 'page',
	'posts_per_page' => '6',
	'order' => 'DESC'
	);
	  $my_posts = new WP_Query( $args );
ob_start(); ?>
<div class="law_services">
	
	
  <ul>
    <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
    <li>
      <div class="elementor-image">
        <?php $image = get_field('icon');?>
        <?php echo wp_get_attachment_image($image['id'], array('700', '600'),false, array( "class" => "" ) );?> </div>
      <div class="service_title">
        <h3>
         <a href="<?php the_permalink();?>"><?php the_title();?></a>
        </h3>
      </div>
      <div class="service_content">
		  <?php echo get_field('law_short_description');?>
      </div>
      <a class="read_more" style="background-color: #ffffff;" href="<?php the_permalink();?>">Read More</a> </li>
    <?php endwhile;
 	   wp_reset_query();?>
  </ul>
</div>
<?php $law_service =  ob_get_clean();
    return $law_service;
     
}
add_shortcode("law_services", "law_services"); 
function jobs() {
//$count = wp_count_posts( "jobs");
$args = array(
  'post_type' => 'jobs',
  'posts_per_page' => '4',
  'order' => 'ASC'
  );
    $my_posts = new WP_Query( $args );
ob_start();
$total = wp_count_posts("jobs")->publish;
if($total >= 4){
  $total = 4;
}

?>
<div class="jobs_available"><?php echo $total;?> Jobs Available</div>
<div class="jobs">
  <ul>
    <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
    <?php
 $featured_post = get_field('jobs_area');?>

    <li>
      <div class="practice_cat"> <?php echo $featured_post->post_title;?> </div>
    
      <div class="jobs_title">
        <?php the_title();?>
      </div>
      <div class="jobs_content">
        <?php $article_data = substr(strip_tags(get_the_content()), 0, 250);
		echo $article_data; ?>
      </div>
      <div class="date_jobs">Posted on:
        <?php $post_date = get_the_date( 'jS M Y' ); echo $post_date;?>
      </div>
      <a class="read_more" style="background-color: #ffffff;" href="<?php the_permalink();?>">Know More</a> </li>
    <?php 
  
  endwhile;
wp_reset_query();?>
  </ul>
</div>

<?php $jobs =  ob_get_clean();
    return $jobs;
     
}
add_shortcode("jobs", "jobs"); 
function other_jobs() { ?>
<?php $args = array(
	'post_type' => 'jobs',
	'posts_per_page' => '12',
	'order' => 'ASC'
	);
	  $my_posts = new WP_Query( $args );
ob_start(); ?>
<div class="other_jobs">
  <ul>
    <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
    <?php
 //$featured_post = get_field('jobs_area');
//foreach($featured_post as $post){?>
    <li>
    <div class="date_jobs">
        <?php $post_date = get_the_date( 'jS M Y' ); echo $post_date;?>
      </div>
      <div class="practice_cat"> <?php //echo $post->post_name;?> </div>
     
      <div class="other_title">
        <?php the_title();?>
      </div>
      <div class="other_content">
        <?php $article_data = substr(strip_tags(get_the_content()), 0, 100);
		echo $article_data; ?>
      </div>
       <a class="read_more" style="background-color: #ffffff;" href="<?php the_permalink();?>">Know More</a> </li>
        </li>
    <?php endwhile;
 	   wp_reset_query();?>
  </ul>
</div>
<?php $jobs =  ob_get_clean();
    return $jobs;
     
}
add_shortcode("other_jobs", "other_jobs"); 
function projects() { ?>
<?php $args = array(
	'post_type' => 'projects',
	'posts_per_page' => '12',
	'order' => 'ASC'
	);
	  $my_posts = new WP_Query( $args );
ob_start(); ?>
<div class="projects">
  <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
  <div>
    <div class="post_job_date">Posted on:
      <?php $post_date = get_the_date( 'jS M Y' ); echo $post_date;?>
    </div>
    <h4>
      <?php the_title();?>
    </h4>
    <div class="projects_content">
      <?php $article_data = substr(strip_tags(get_the_content()), 0, 250);
		echo $article_data; ?>
    </div>
    <?php $pdf = get_field('download_pdf');?>
    <div class="pdf"><a href="<?php echo $pdf?>">Download</a> </div>
  </div>
  <?php endwhile;
 	   wp_reset_query();?>
</div>
<?php $projects =  ob_get_clean();
    return $projects;
     
}
add_shortcode("projects", "projects");

function more_post_ajax(){
		//$categories = get_the_category();
  // $cat_id = $categories[0]->term_id;
   $offset = $_POST["offset"];
    $ppp = $_POST["ppp"];
    $cat_id = $_POST["cat_id"];
    header("Content-Type: text/html");
 
     $args = array(
	       'suppress_filters' => true,
        'post_type' => 'post',
        'posts_per_page' => $ppp,
      'cat' => $cat_id,
        'offset' => $offset,
	        );
	  $loop = new WP_Query($args);?>

	
    <?php while ($loop->have_posts()) { $loop->the_post();?> 
      <div <?php post_class(); ?> id="post-<?php the_ID(); ?>"> 
                   

                <!--POST THUMBNAIL START-->
                        <div class="post_image">
                             <!--CALL TO POST IMAGE-->
                             <?php $featured= get_field_object('featured_imagevideo');?>
                             <?php  $value = $featured['value'];?>
                            <?php if ( $value=='Image' ) { ?>
                            <div class="imgwrap">
								<?php $image = get_field('post_image');?>
                 <?php echo wp_get_attachment_image($image['id'], array('700', '600'),false, array( "class" => "" ) );?>
                           </div>
                       <?php } else {?>
						    <div class="imgwrap">
								<?php $video = get_field('youtube_video');?> 
								<iframe width="420" height="345" src="<?php echo $video;?>"></iframe>
                           </div>
						   <?php }?>
                        </div>
                 <!--POST THUMBNAIL END-->

                    <!--POST CONTENT START-->
                    <div class="post_content">
                    <?php $post_object = get_field('knowledge_centre');?>
                    <h4><?php echo esc_html( $post_object->post_title ); ?></h4>
                    
                        
                            <h3 class="postitle"><a href="<?php the_permalink();?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
                            
                         <!--META INFO START-->   
                            
                         
                            <?php $article_data = substr(strip_tags(get_the_content()), 0, 150);
		                         echo $article_data; ?>
                            
                        </div>
                
                    <!--POST CONTENT END-->
					<!--Read More Button-->
                    <!--div class="blog_mo"><a href="<?//php the_permalink();?>">+ <?//php _e('Read More', 'complete'); ?></a></div-->
                  
                </div>
   <?php  }?>

   <?php exit; 
}

add_action('wp_ajax_nopriv_more_post_ajax', 'more_post_ajax'); 
add_action('wp_ajax_more_post_ajax', 'more_post_ajax');
function skt_complete_import_files() {
  return array(
    array(
      'import_file_name'             => 'Import SKT Man Demo',
      'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo-content/demo-content.xml',
    ),
  );
}
add_filter( 'theme-demo-import/import_files', 'skt_complete_import_files' );

/**
 * Assign menu and front page
 */

function skt_complete_after_import_setup() {
  // Assign menus to their locations.
  $main_menu = get_term_by( 'name', 'Header', 'nav_menu' );

  set_theme_mod( 'nav_menu_locations', array(
      'primary' => $main_menu->term_id,
    )
  );
  
  // Assign front page and posts page (blog page).
  $front_page_id = get_page_by_title( 'Home' );
  $blog_page_id  = get_page_by_title( 'Blog' );

  update_option( 'show_on_front', 'page' );
  update_option( 'page_on_front', $front_page_id->ID );
  update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'theme-demo-import/after_import', 'skt_complete_after_import_setup' );

function skt_complete_import_content_intro_text( $default_text ) {
  $default_text .= '<div class="import-intro-text">Kindly click on below button to setup pages and navigation.</div>';

  return $default_text;
}
add_filter( 'theme-demo-import/plugin_intro_text', 'skt_complete_import_content_intro_text' );

define('SKT_THEME_DOC', 'http://sktthemesdemo.net/documentation/skt-handyman-doc/');
?>


