<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Connectors\Resource;

use Google\Service\Connectors\ExecuteSqlQueryRequest;
use Google\Service\Connectors\ExecuteSqlQueryResponse;

/**
 * The "connections" collection of methods.
 * Typical usage is:
 *  <code>
 *   $connectorsService = new Google\Service\Connectors(...);
 *   $connections = $connectorsService->connections;
 *  </code>
 */
class ProjectsLocationsConnections extends \Google\Service\Resource
{
  /**
   * Executes a SQL statement specified in the body of the request. An example of
   * this SQL statement in the case of Salesforce connector would be 'select *
   * from Account a, Order o where a.Id = o.AccountId'.
   * (connections.executeSqlQuery)
   *
   * @param string $connection Required. Resource name of the Connection. Format:
   * projects/{project}/locations/{location}/connections/{connection}
   * @param ExecuteSqlQueryRequest $postBody
   * @param array $optParams Optional parameters.
   * @return ExecuteSqlQueryResponse
   */
  public function executeSqlQuery($connection, ExecuteSqlQueryRequest $postBody, $optParams = [])
  {
    $params = ['connection' => $connection, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('executeSqlQuery', [$params], ExecuteSqlQueryResponse::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProjectsLocationsConnections::class, 'Google_Service_Connectors_Resource_ProjectsLocationsConnections');
