<?php
header('Access-Control-Allow-Origin: *');

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
require_once "vendor/autoload.php";

use Google\Client;
use Google\Service\Drive;
use Google\Service\Sheets\BatchUpdateSpreadsheetRequest;

/**
 * get values of a particular spreadsheet(by Id and range).
 */
function callAPI($method, $url, $data)
{
   $curl = curl_init();
   switch ($method) {
      case "POST":
         curl_setopt($curl, CURLOPT_POST, 1);
         if ($data)
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
         break;
      case "GET":
         curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");
         if ($data)
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
         break;
      default:
         if ($data)
            $url = sprintf("%s?%s", $url, http_build_query($data));
   }
   // OPTIONS:
   curl_setopt($curl, CURLOPT_URL, $url);
   curl_setopt($curl, CURLOPT_HTTPHEADER, array(
      'Content-Type: application/json'
   ));
   curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
   curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
   // EXECUTE:
   $result = curl_exec($curl);
   if (!$result) {
      die("Connection Failure");
   }
   curl_close($curl);
   return $result;
}

function getValues($spreadsheetId, $range)
{
   $client = new Google\Client();
   // $client->setAuthConfig('apikey-362706-2f79583b562b.json');
 //  $client->setAuthConfig('centered-moon-363205-400bb85f0abb.json');
   $client->setAuthConfig('pinkpowerco-adb068865ecc.json');
   $client->addScope(Google\Service\Drive::DRIVE);
   $service = new Google_Service_Sheets($client);

   $userData = array(
      "UserId"     => "vansonshoes@yahoo.com",
      "Password"   => "admin"
   );
   $response_user = json_encode($userData, true);

   $get_data = callAPI('POST', 'http://zOrder.CloudApp.net/AppfabricBeta/access_token',  $response_user);
   $response = json_decode($get_data, true);


   $token = $response['Data']['Token'];

   $intace_id =  $response['Data']['Instances']['0']['Id'];


   $curl = curl_init();
   curl_setopt_array($curl, array(
      CURLOPT_URL => 'http://zorder.cloudapp.net/AppfabricBeta/Shopify/GetCompleteStock',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
         'Z-Auth-Token:' . $token,
         'Instance_Id:' . $intace_id
      )
   ));
   $response = curl_exec($curl);
   curl_close($curl);
   $datanew = json_decode($response, true);
   // sleep(1);
   
   // echo '<pre>';
   // print_r( $datanew);
   // die;
   $responseNew = $datanew['Data'];
   //$rows[] = array('SKU' => "SKU", 'Quantity' => "Gurugram");
   $rows = array();
   //$rows[] = array('SKU' => $sku, 'Quantity' => $Quanity);
   foreach ($responseNew as $dataresponse) {
      // echo '<pre>';
      // print_r( $dataresponse);
      // die;
      $sku = $dataresponse['SKU'];
      $Quanity = $dataresponse['Quantity'];
    
      //$rows[] = array('SKU' => $sku, 'Quantity' => $Quanity);
      $rows[] = array('SKU' => $sku, 'Editable'=> 'Yes','Quantity' => $Quanity);
   //   sleep(1);
   
   }
//  echo '<pre>';
//    print_r( $rows);
//    die;
   $rows = array_map(function ($arr) {
      return array_values($arr);
   }, $rows);
   // sleep(2);
   $values = $rows;
   // echo '<pre>';
   // print_r( $values);
   // die;
   $body = new Google_Service_Sheets_ValueRange([

      
      'values' => $values
   ]);
   $params = [
      'valueInputOption' => 'RAW'
   ];
   $requestBody = new Google_Service_Sheets_ClearValuesRequest();
   // $range = "Manage Quantities!D2:F2";
 $range = $range . count($rows);
   $service->spreadsheets_values->clear($spreadsheetId, $range, $requestBody);
   $result = $service->spreadsheets_values->append($spreadsheetId, $range, $body, $params);
   //  echo count($rows);die;
   //$update_sheet = $service->spreadsheets_values->update($spreadsheetId, $range, $body, $params);
   printf("%d cells appended.", $result->getUpdates()->getUpdatedRows());
//  echo '<pre>';
//    print_r( $result);
//    die;
   return $result;
}

getValues("1GLHnVw0MXnmirXVAEmEQNczj9vKq4N4FU5IyKl6UZlk", "Manage Quantities!D2:F2"); 

//getValues("1d_ksu12Vt8-HBDRmCpPj3xT7v036UBGkYvUERQCmn3o", "A1:B2");
