<?php
/**
 * Paeon by NiceThemes.
 *
 * Template Name: Sitemap
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header();

get_template_part( 'page-title' ); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content" class="full-width <?php echo esc_attr( $post->post_name ); ?>">

<?php if ( have_posts() ) : ?>

		<?php while ( have_posts() ) : the_post(); ?>

				<header>
					<h1 class="entry-title"><?php the_title(); ?></h1>
				</header>

				<article class="entry">
					<?php the_content( __( 'Continue reading', 'nicethemes' ) . ' &raquo;' ); ?>
				</article>


		<?php endwhile; ?>

		<div class="two-col entry">
			<div class="col-1">
				<header>
					<h3><?php _e( 'Pages', 'nicethemes' ) ?></h3>
				</header>
				<ul>
					<?php wp_list_pages( 'depth=0&sort_column=menu_order&title_li=' ); ?>
				</ul>

				<header>
						<h3><?php _e( 'Services', 'nicethemes' ); ?></h3>
				</header>

				<?php $query = new WP_Query( array( 'posts_per_page' => -1, 'post_type' => 'service' ) );

					if ( $query->have_posts() ) : ?>

						<ul>
							<?php while ( $query->have_posts() ) :
								$query->the_post() ?>

									<li><a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a></li>

							<?php endwhile; ?>

						</ul>

				<?php endif; ?>

				<header>
						<h3><?php _e( 'Staff', 'nicethemes' ); ?></h3>
				</header>

				<?php $query = new WP_Query( array( 'posts_per_page' => -1, 'post_type' => 'staff' ) );

					if ( $query->have_posts() ) : ?>

						<ul>
							<?php while ( $query->have_posts() ) :
								$query->the_post() ?>

									<li><a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a></li>

							<?php endwhile; ?>

						</ul>

				<?php endif; ?>

				<header>
					<h3><?php _e( 'Categories', 'nicethemes' ) ?></h3>
				</header>
				<ul>
					<?php wp_list_categories( 'title_li=&hierarchical=0&show_count=1') ?>
				</ul>

			</div>

			<div class="col-2">
				<header>
					<h3><?php _e( 'Posts per category', 'nicethemes' ); ?></h3>
				</header>

				<?php
				$cats = get_categories();

				foreach ( $cats as $cat ) :

					  $query = new WP_Query( array( 'posts_per_page' => -1, 'cat' => $cat->cat_ID ) );

					if ( $query->have_posts() ) : ?>

						<header>
							<h4><?php echo $cat->cat_name; ?></h4>
						</header>

						<ul>
							<?php while ( $query->have_posts() ) :
								$query->the_post() ?>

									<li><a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a> - <?php _e( 'Comments', 'nicethemes' ) ?> (<?php echo $post->comment_count ?>)</li>

							<?php endwhile; ?>

						</ul>
				<?php endif; ?>

			<?php endforeach; ?>

			</div>

<?php else : ?>

		<header>
			<h2><?php _e( 'Not Found', 'nicethemes' ); ?></h2>
		</header>
		<p><?php _e( 'Sorry, but you are looking for something that isn\'t here.', 'nicethemes' ); ?></p>

		<?php get_search_form(); ?>

<?php endif; ?>

<!-- END #content -->
</section>

<!-- END #container -->
</div>

<?php get_footer();