<?php
/**
 * Paeon by NiceThemes.
 *
 * Template Name: Services - One Column
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header();

get_template_part( 'page-title' ); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<?php if ( have_posts() ) : ?>

	<?php while ( have_posts() ) : the_post(); ?>

		<!-- BEGIN #content -->
		<section class="col-full clearfix service <?php echo esc_attr( $post->post_name ); ?>">

			<div class="entry">
				<?php the_content( __( 'Continue reading', 'nicethemes' ) . ' &raquo;' ); ?>
			</div>

			<?php

			$args = ( array( 'taxonomy' => 'service-category', 'hide_empty' => 1 ) );

			$categories = get_categories( $args );

			if ( ! empty( $categories ) ):
			?>
			<h4 class="service-filter-title"><?php _e( 'Services:', 'nicethemes'); ?></h4>
			<!-- BEGIN #filter -->
			<ul id="filter">

					<li class="active"><a data-value="all" href="#"><?php _e( 'All', 'nicethemes' ); ?></a></li>
					<?php  wp_list_categories(array(
									'title_li'         => '',
									'show_option_none' => '',
									'taxonomy'         => 'service-category',
									'hide_empty'       => 1,
									'walker'           => new Nice_Walker())
							); ?>

			<!-- END #filter -->
			</ul>
			<?php endif ?>
			<?php $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
			$temp_query = $wp_query;

			$args = array(
							'post_type'      => 'service',
							'posts_per_page' => -1,
							'no_found_rows'  => true,
							'paged'          => $paged,
							'orderby'        => 'menu_order',
							'order'          => 'ASC'
						);

			query_posts( $args );

			if ( have_posts() ) :

				$count = 0;
				$columns = 1; ?>
				<ul id="services" class="one-col-grid grid service-grid clearfix">

				<?php while ( have_posts() ) :
						the_post();
						$count++;

						$terms = get_the_terms( get_the_ID(), 'service-category' ); ?>
					<li data-id="id-<?php echo esc_attr( $count ); ?>" class="<?php if ( $terms ) : foreach ( $terms as $term ) : echo esc_attr( 'term-' . $term->term_id ) . ' '; endforeach; endif; ?> <?php if ( has_post_thumbnail() ) : echo 'has-image'; endif; ?> clearfix">
							<div class="boxgrid caption">

								<?php if ( has_post_thumbnail() ) : ?>
										<div class="thumb view view-more">
											<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>">
												<?php nice_image( array( 'key'	=> 'service-image', 'width'  => 480, 'height' => 480 ) ) ; ?>
												<div class="mask"></div>
											</a>
										</div>
								<?php endif; ?>

								<span class="entry-title">
									<a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>"><?php the_title(); ?></a>
								</span>

							</div>
							<div class="excerpt-wrapper">
								 <?php the_excerpt(); ?>
							</div>
				  	</li>

			  	<?php endwhile;?>

				</ul>

			<?php endif; ?>
			<?php wp_reset_query(); ?>

			<?php $wp_query = clone $temp_query; ?>

		<?php endwhile; ?>

		<!-- END #content -->
		</section>

<?php endif; ?>

<!-- END #container -->
</div>

<?php get_footer();