<?php
/**
 * Paeon by NiceThemes.
 *
 * Template Name: Home
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2016 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header();

global $nice_options;

$social_items = array();
$nice_social_enable = get_option( 'nice_social_enable' );

if ( nice_bool( $nice_social_enable ) ) :
	$social_items = nice_social_icons();
endif;

$nice_phone_number = $nice_options['nice_phone_number'];

$home_social_class = ( empty( $social_items ) || $nice_phone_number == '' ) ? 'home-social-full-width' : '';

if ( ! empty( $social_items ) || $nice_phone_number !== '' ) : ?>

	<!-- BEGIN .home-social -->
	<section class="home-social home-block <?php echo esc_attr( $home_social_class ); ?> clearfix">

		<div class="col-full">

			<?php if ( ! empty( $social_items ) ) : ?>
					<div class="social-links clearfix">

						<ul class="social">
							<?php echo $social_items; ?>
						</ul>

					</div>

			<?php endif; ?>
			<?php if ( $nice_phone_number !== '' ) : ?>

					<div class="main-title">
						<div class="right">
							<span class="call-now"><?php echo $nice_options['nice_call_now_text']; ?></span>
							<span class="call-number"><?php echo $nice_options['nice_phone_number']; ?></span>
						</div>
					</div>

			<?php endif; ?>

		</div>

	<!-- END .home-social -->
	</section>

<?php endif; ?>
<?php

$nice_welcome_message          = get_option( 'nice_welcome_message' );
$nice_welcome_message_extended = get_option( 'nice_welcome_message_extended' );

if ( ( $nice_welcome_message != '' ) || ( $nice_welcome_message_extended != '' ) ) : ?>

	<!-- BEGIN .welcome-message -->
	<section class="welcome-message home-block clearfix">

		<div class="col-full">

				<?php if ( $nice_welcome_message !== '' ) : ?>
						<header>
							<h2><?php echo stripslashes( htmlspecialchars_decode( nl2br( $nice_welcome_message ) ) ); ?></h2>
						</header>
				<?php endif ;?>

				<?php if ( $nice_welcome_message_extended !== '' ) : ?>
						<p><?php echo stripslashes( htmlspecialchars_decode( nl2br( $nice_welcome_message_extended ) ) ); ?></p>
				<?php endif ;?>

		</div>

	<!-- END .welcome-message -->
	</section>

<?php endif; ?>

<?php

	$nice_staff_enable = get_option( 'nice_staff_enable' );
	$nice_staff_title  = get_option( 'nice_staff_title' );
	$nice_staff_order  = get_option( 'nice_staff_order' );

	if ( $nice_staff_enable === 'true' ) :

	?>
	<!-- BEGIN #home-staff .home-block -->
	<section id="home-staff" class="home-block home-staff clearfix">

		<div class="col-full">

			<!-- BEGIN .home-block-header -->
			<div class="home-block-header col-full">

				<?php if ( $nice_staff_title !== '' ) : ?>
						<header>
							<h3><?php echo stripslashes( $nice_staff_title ); ?></h3>
						</header>
				<?php endif; ?>

			<!-- END .home-block-header -->
			</div>

			<?php

			$query = new WP_Query( array(
									'post_type'      => 'staff',
									'orderby'        => $nice_staff_order,
									'posts_per_page' => apply_filters( 'nice_home_staff_posts', 4 ),
									'order'          => 'ASC'
								)
						);

			?>

			<ul id="staff" class="four-col-grid staff-grid-four-col grid clearfix">

			<?php

			$loop = 0;

			$columns = 4;

			if ( $query->have_posts() ) :

				while ( $query->have_posts() ) :
					$query->the_post();

					$loop++; ?>

					<li data-id="id-<?php echo esc_attr( $loop ); ?>" id="post-<?php esc_attr( the_ID() ); ?>" class="<?php if ( $loop % $columns === 0 ) echo esc_attr( 'last' ); if ( ( $loop-1 ) % $columns === 0 ) echo esc_attr( 'first' ); ?>">

						<?php
							$image_class = $image = '';
							if ( has_post_thumbnail() ) :
								$image = nice_image( array( 'echo' => 'false', 'id' => get_the_ID(), 'key' => 'staff-image', 'width' => 480, 'height' => 480 ) );
								$image_class = 'has-image';
							endif;
						?>

						<div class="<?php echo esc_attr( $image_class ); ?>">

						<?php if ( has_post_thumbnail() ) : ?>
							<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>">
								<?php echo $image; ?>
							</a>
						<?php endif; ?>

							<div class="content">
									<span class="staff-title">
										<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>">
											<?php the_title(); ?>
										</a>
									</span>

									<div class="staff-deparment">
										<?php echo get_the_term_list( get_the_ID(), 'department', '', ', ', '' ); ?>
									</div>

									<div class="staff-excerpt">
										<?php nice_excerpt( 120 ); ?>
									</div>
							</div>

						</div>

					</li>

			<?php endwhile; endif; ?>

			</ul>

			<!-- END .col-full -->
			</div>

			<?php $nice_staff_button_text = get_option( 'nice_staff_button_text' );
				  $nice_staff_button_url  = get_option( 'nice_staff_button_url' );

				if ( $nice_staff_button_text !== '' && $nice_staff_button_url !== '' ) : ?>
					<div class="meet-doctor-button"><a href="<?php echo esc_url( $nice_staff_button_url ); ?>" class="button-bg" title="<?php echo esc_attr( $nice_staff_button_text ); ?>"><?php echo $nice_staff_button_text; ?></a></div>
			<?php endif; ?>

	<!-- END #home-staff .home-block -->
	</section>

	<?php endif; ?>

<?php

$nice_service_enable = get_option( 'nice_service_enable' );
$nice_service_title  = get_option( 'nice_service_title' );
$nice_service_order  = get_option( 'nice_service_order' );

if ( $nice_service_enable == 'true' ) :

?>
<!-- BEGIN #home-service .home-block -->
<section id="home-service" class="home-block home-service clearfix">

		<div class="col-full">

		<!-- BEGIN .home-block-header -->
		<div class="home-block-header">

				<?php if ( $nice_service_title !== '' ) : ?>
					<header>
						<h3><?php echo stripslashes( $nice_service_title ); ?></h3>
					</header>
				<?php endif; ?>

		<!-- END .home-block-header -->
		</div>

		<?php
		$catName = 'home-page-services'; 
		$query = new WP_Query( array(
							'post_type'      => 'service',
							'tax_query' => array (array ( 
								'taxonomy' => 'service-category',
								'field' => 'id',
								'terms' => array(sanitize_text_field($catName))	
							)),								
							'orderby'        => $nice_service_order,
							'posts_per_page' => apply_filters( 'nice_home_service_posts', 5 ),
							'order'          => 'ASC'
					)
				);
		?>

		<ul id="service" class="four-col-grid service-grid-four-col grid clearfix">

		<?php

		$loop = 0;

		$columns = 5;

		if ( $query->have_posts() ) :
			while ( $query->have_posts() ) :
				$query->the_post();
				$image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID),'nice-home-service' );
				$url = $image_url['0'];	

				$loop++; ?>

				<li data-id="id-<?php echo esc_attr( $loop ); ?>" id="post-<?php esc_attr( the_ID() ); ?>" class="<?php if ( $loop % $columns === 0 ) echo esc_attr( 'last' ); if ( ( $loop - 1 ) % $columns === 0 ) echo esc_attr( 'first' ); ?>">

					<?php if ( has_post_thumbnail() ) : ?>
						<div class="view view-more">
							<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>">
								<img src="<?php echo $url; ?>" class="nice-image" title="<?php the_title(); ?>" alt="">
								<div class="mask"></div>
							</a>
						</div>
					<?php endif; ?>

					<div class="content">
						<span class="service-title">
							<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>">
								<?php the_title(); ?>
							</a>
						</span>
						<?php nice_excerpt(60); ?>
						<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>" class="readmore"><?php _e( 'Read more', 'nicethemes' ); ?></a>
					</div>
				</li>

		<?php endwhile; endif; ?>

		</ul>

		<!-- END .col-full -->
		</div>

<!-- END #home-service .home-block -->
</section>

<?php endif; ?>

<?php

$nice_testimonial_enable = get_option( 'nice_testimonial_enable' );
$nice_testimonial_title  = get_option( 'nice_testimonial_title' );
$nice_testimonial_order  = get_option( 'nice_testimonial_order' );

if ( $nice_testimonial_enable === 'true' ) :

	$query = new WP_Query( array(
								'post_type'      => 'feedback',
								'orderby'        => $nice_testimonial_order,
								'posts_per_page' => 3,
								'order'          => 'ASC'
								)
				);

	if ( $query->have_posts() ) : ?>

	<!-- BEGIN #container -->
	<div id="container" class="clearfix">

	<!-- BEGIN #content -->
	<section id="content" class="home-testimonial home-block clearfix">


		<div class="col-full">

		<!-- BEGIN .home-block-header -->
		<div class="home-block-header">

			<?php if ( $nice_testimonial_title !== '' ) : ?>
				<header>
					<h3><?php echo stripslashes( $nice_testimonial_title ); ?></h3>
				</header>
			<?php endif; ?>

		<!-- END .home-block-header -->
		</div>

		<?php

		 while ( $query->have_posts() ) : $query->the_post(); ?>

		 <article>

			<div class="clearfix">

					<?php
					$image_class = $image = '';
					if ( has_post_thumbnail() ) :
						$image = nice_image( array( 'echo' => 'false', 'id' => get_the_ID(), 'key' => 'feedback-image', 'width' => 200, 'height' => 200 ) );
						$image_class = 'has-image';
					endif;
					?>
						<div class="<?php echo esc_attr( $image_class ); ?>">

							<?php echo $image; ?>

							<div class="content testimonial">
								<div class="feedback-text"><?php the_content(); ?></div>
								<?php
									$meta = get_post_custom( get_the_ID() );
									$feedback_author = '';

									if ( ( isset( $meta['feedback_author'] ) && ( $meta['feedback_author'][0] !== '' ) ) || ( isset( $meta['feedback_url'] ) && ( $meta['feedback_url'][0] != '' ) ) ):
										$feedback_author = '<span class="feedback-author clearfix">';

										if ( isset( $meta['feedback_author'] ) && ( $meta['feedback_author'][0] !== '' ) ):
											$feedback_author .= '<cite class="feedback-author">' . $meta['feedback_author'][0] . '</cite>';
										endif;

										if ( isset( $meta['feedback_url'] ) && ( $meta['feedback_url'][0] !== '' ) ) :
												$feedback_author .= ' &mdash; <a href="' . esc_url( $meta['feedback_url'][0] ) . '" title="' . esc_attr( $meta['feedback_author'][0] ) . '" class="feedback-url">' . $meta['feedback_url'][0] . '</a>';
										endif;

										$feedback_author .= '</span>';

									endif;

									echo $feedback_author;
							?>
							</div>
					</div>
			</div>

</article>

		<?php endwhile; ?>

		<?php
			$nice_testimonial_button_text = get_option( 'nice_testimonial_button_text' );
			$nice_testimonial_button_url  = get_option( 'nice_testimonial_button_url' );

			if ( $nice_testimonial_button_text !== '' && $nice_testimonial_button_url !== '' ) : ?>
				<div class="readmore-feedback"><a href="<?php echo esc_url( $nice_testimonial_button_url ); ?>"  title="<?php echo esc_attr( $nice_testimonial_button_text ); ?>"><?php echo $nice_testimonial_button_text; ?></a></div>
			<?php endif; ?>

		<!-- END .col-full -->
		</div>

		<!-- END #content -->
		</section>

		<!-- BEGIN #sidebar -->
		<aside class="home-sidebar" id="sidebar" role="complementary">
			<?php// dynamic_sidebar( 'home' ); ?>
			<div class="box widget widget_nice_appointments">
				<h3 class="widgettitle">Get An Appointment</h3>
                 <?php echo apply_shortcodes( '[contact-form-7 id="546" html_id="nice_appointment" title="Get An Appointment"]' ); ?>
			</div>
			
			
		<!-- END #sidebar -->
		</aside>

		<!-- END #container -->
		</div>
<?php endif; ?>

<?php endif;

get_footer();
