<?php
/**
 * Paeon by NiceThemes.
 *
 * Template Name: Gallery
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header(); ?>

<?php get_template_part( 'page-title' ); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content" class="full-width <?php echo esc_attr( $post->post_name ); ?>">

<?php if ( have_posts() ) : ?>

	<?php while ( have_posts() ) : the_post(); ?>

			<div class="entry clearfix">
				<?php the_content( __( 'Continue reading', 'nicethemes' ) . ' &raquo;' ); ?>
			</div>

			<?php

			$attachments = get_children( array(
									'post_parent'    => get_the_ID(),
									'post_type'      => 'attachment',
									'post_mime_type' => 'image',
									'order'          => 'ASC',
									'numberposts'    => -1,
									'orderby'        => 'menu_order date'
									)
			);

			if ( empty( $attachments ) ) {
				$attachments = nice_attachments_from_gallery();
			}

			if ( ! empty( $attachments ) && ( count( $attachments ) > 1 ) ) :

					$columns = 4;

					$loop = 0;

					?>
					<div class="gallery-container clearfix">

						<ul class="four-col-grid grid clearfix">

							<?php foreach ( $attachments as $att_id => $attachment ) : $loop++; ?>

									<li class="<?php if ( $loop % $columns === 0 ) echo esc_attr( 'last' ); if ( ( $loop - 1 ) % $columns === 0 ) echo esc_attr( 'first' ); ?>">

										<figure class="thumb">

											<div class="view view-more">
												<a class="fancybox" rel="group" data-fancybox="group" href="<?php echo esc_url( wp_get_attachment_url( $att_id ) ); ?>" title="<?php echo esc_attr( get_the_title( $att_id ) ); ?>">
													<?php nice_image( array ( 'width' => 480, 'height' => 480, 'id' =>  $att_id ) ); ?>
													<div class="mask"></div>
												</a>
											</div>

										</figure>

									</li>

							<?php endforeach; ?>

						</ul>

					</div>

			<?php

			else :

				_e( 'There are no images for this gallery', 'nicethemes' );

			endif;

			?>

	<?php endwhile; ?>

<?php else : ?>

	<header>
		<h2><?php _e( 'Not Found', 'nicethemes' ); ?></h2>
	</header>
	<p><?php _e( 'Sorry, but you are looking for something that isn\'t here.', 'nicethemes' ); ?></p>

	<?php get_search_form(); ?>

<?php endif; ?>

<!-- END #content -->
</section>

<!-- END #container -->
</div>

<?php get_footer();