<?php
/**
 * Paeon by NiceThemes.
 *
 * Template Name: Full Width
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header();

get_template_part( 'page-title' ); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content" class="full-width <?php echo esc_attr( $post->post_name ); ?>">

<?php if ( have_posts() ) : ?>

	<?php while ( have_posts() ) : the_post(); ?>

			<div class="entry clearfix">

				<?php the_content( __( 'Continue reading', 'nicethemes' ) . ' &raquo;' ); ?>
				<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'nicethemes' ), 'after' => '</div>' ) ); ?>
			</div>

			<?php comments_template( '', true ); ?>

	<?php endwhile; ?>

<?php else : ?>

	<header>
		<h2><?php _e( 'Not Found', 'nicethemes' ); ?></h2>
	</header>
	<p><?php _e( 'Sorry, but you are looking for something that isn\'t here.', 'nicethemes' ); ?></p>

	<?php get_search_form(); ?>

<?php endif; ?>

<!-- END #content -->
</section>

<!-- END #container -->
</div>

<?php get_footer();