<?php
/**
 * Paeon by NiceThemes.
 *
 * Template Name: Testimonials (Feedback)
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header();

get_template_part( 'page-title' ); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content" class="full-width feedback <?php echo esc_attr( $post->post_name ); ?>">

<?php if ( have_posts() ) : ?>

	<?php while ( have_posts() ) : the_post(); ?>

			<div class="entry">
				<?php the_content( __( 'Continue reading', 'nicethemes' ) . ' &raquo;' ); ?>
			</div>

			<?php

				$testimonials = get_posts( array( 'post_type' => 'feedback', 'numberposts' => -1, 'order' => 'ASC', 'orderby' => 'menu_order', 'suppress_filters' => 0 ) );

				if ( ! empty( $testimonials ) ) :

						$loop = 0;
						$columns = 2; ?>

						<ul id="feedback" class="two-col-grid grid feedback-grid clearfix">

						<?php foreach ( $testimonials as $post ) :

								setup_postdata( $post );
								$loop++;
								$meta = get_post_custom( get_the_ID() );
								$feedback_author = '';

								if ( ( isset( $meta['feedback_author'] ) && ( $meta['feedback_author'][0] != '' ) ) || ( isset( $meta['feedback_url'] ) && ( $meta['feedback_url'][0] != '' ) ) ) :
										$feedback_author = '<span class="feedback-author clearfix">';

										if ( isset( $meta['feedback_author'] ) && ( $meta['feedback_author'][0] != '' ) ) :
												$feedback_author .= '<cite class="feedback-author">' . $meta['feedback_author'][0] . '</cite>';
										endif;

										if ( isset( $meta['feedback_url'] ) && ( $meta['feedback_url'][0] != '' ) ) :
												$feedback_author .= ' &mdash; <a href="' . esc_url( $meta['feedback_url'][0] ) . '" title="' . esc_attr( $meta['feedback_author'][0] ) . '" class="feedback-url">' . $meta['feedback_url'][0] . '</a>';
										endif;

										$feedback_author .= '</span>';

								endif;

								$image_class = '';
									if ( has_post_thumbnail() ) :
										$image_class = 'has-image';
									endif;
									?>
								<li class="clearfix <?php if ( $loop % $columns === 0 ) echo esc_attr( 'last' ); if ( ( $loop - 1 ) % $columns === 0 ) echo esc_attr( 'first' ); ?>"><div id="testimonial-<?php the_id(); ?>" class="testimonial clearfix <?php echo esc_attr( $image_class ); ?>">
								<?php if ( has_post_thumbnail() ) : ?>
										<div class="thumb">
											<?php nice_image( array( 'key'	=> 'feedback-image', 'width'  => 200, 'height' => 200 ) ) ; ?>
										</div>
								<?php endif; ?>
								<?php echo '<blockquote class="feedback-text">' . get_the_content() . '</blockquote>' . "\n";

								echo $feedback_author;

								echo '</div></li>';

						endforeach; ?>

						</ul>

					<?php else: ?>
						<p>
							<?php _e( 'There are no feedback items', 'nicethemes' ); ?>
						</p>
					<?php
					endif;

					wp_reset_query();

					?>

	<?php endwhile; ?>

<?php else : ?>

	<header>
		<h2><?php _e( 'Not Found', 'nicethemes' ); ?></h2>
	</header>
	<p><?php _e( 'Sorry, but you are looking for something that isn\'t here.', 'nicethemes' ); ?></p>

	<?php get_search_form(); ?>

<?php endif; ?>

<!-- END #content -->
</section>

<!-- END #container -->
</div>

<?php get_footer();