<?php
/**
 * Paeon by NiceThemes.
 *
 * Template Name: Contact
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

$nice_contact_form = apply_filters( 'nice_contact_form', true );

if ( $nice_contact_form ) {
	add_filter( 'nice_load_contact_js', '__return_true', 10 );
}

get_header();

get_template_part( 'page-title' ); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content" class="<?php echo esc_attr( $post->post_name ); ?>">

<?php if ( have_posts() ) : ?>

	<?php while ( have_posts() ) : the_post(); ?>

		<article class="post">

				<?php

					$nice_google_map = get_option( 'nice_google_map' );

					if ( ! empty ( $nice_google_map ) ) :
						echo nice_embed( array ( 'embed' => $nice_google_map, 'width' => '100%', 'height' => 342, 'class' => 'nice-contact-map' ) );
					endif;

				?>

				<div class="entry">
					<?php the_content( __( 'Continue reading', 'nicethemes' ) . ' &raquo;' ); ?>
				</div>

				<?php if ( $nice_contact_form ) : ?>

				<div class="nice-contact-form clearfix">
					<?php echo apply_shortcodes( '[contact-form-7 id="542" title="Contact form 1"]' ); ?>

				
					<!-- <form name="nice_contact" id="nice_contact" method="post" >
						<p>
							<label for="name" form="nice_contact"><?php _e( 'Your Name', 'nicethemes' ); ?><span class="required">*</span></label>
							<input type="text" id="name" name="name" value="" class="required" />
						</p>
						<p>
							<label for="subject" form="nice_contact"><?php _e( 'Subject', 'nicethemes' ); ?></label>
							<input type="text" name="subject" id="subject" value="" />
						</p>
						<p>
							<label for="mail" form="nice_contact"><?php _e( 'Your E-Mail', 'nicethemes' ); ?><span class="required">*</span></label>
							<input type="text" name="mail" id="mail" value="" class="required email" />
						</p>
						<p>
							<label for="message" form="nice_contact"><?php _e( 'Your Message','nicethemes' ); ?><span class="required">*</span></label><br />
							<textarea name="message" id="message" class="required"></textarea>
						</p>
						<p>
							<input type="submit" value="<?php esc_attr_e( 'Send Message', 'nicethemes' ); ?>" />
						</p>
					</form> -->

					<div id="node"></div>
					<div id="success"><?php _e( 'Thank you for leaving a message.', 'nicethemes' ); ?></div>

				</div>

				<?php endif; ?>

		</article>

		<?php endwhile; ?>

<?php else : ?>

			<header>
				<h2><?php _e( 'Not Found', 'nicethemes' ); ?></h2>
			</header>
			<p><?php _e( 'Sorry, but you are looking for something that isn\'t here.', 'nicethemes' ); ?></p>
			<?php get_search_form(); ?>

<?php endif; ?>

		<!-- END #content -->
		</section>

		<!-- BEGIN #sidebar -->
		<aside id="sidebar" role="complementary">

			<?php if ( has_post_thumbnail() ) : ?>
							<figure>
					<div class="contactRite">
					<!-- <h3>Riverdale Ophthalmology</h3>
					<p>3220 Fairfield Avenue<br>
					Bronx, New York 10463</p>
					<p>(718) 432-2000</p><br> -->
							<?php dynamic_sidebar( 'heading' ); ?>			
						<?php dynamic_sidebar( 'footer-2' ); ?>
						<?php dynamic_sidebar( 'office1-timming' ); ?>
						<hr>
						<?php dynamic_sidebar( 'footer-3' ); ?>
						<?php dynamic_sidebar( 'office2-timming' ); ?>

						
					</div>
	
				</figure>
				<!-- <figure>
					<?php //nice_image( array( 'width' => 480, 'height' => 755, 'class' => 'wp-post-image' ) ); ?>
				</figure> -->
			<?php endif; ?>

			<?php
				$nice_address      = get_option( 'nice_address' );
				$nice_phone_number = get_option( 'nice_phone_number' );
				$nice_email        = get_option( 'nice_email' );
				if ( ! empty ( $nice_address ) ) : ?>
					<div class="box">
						<header>
							<h3><?php bloginfo( 'name' ); ?></h3>
						</header>
						<?php echo nl2br ( $nice_address ); ?>
						<p>
							<?php if ( $nice_phone_number != '' ) : ?>
								<?php printf( __( 'Phone: %s', 'nicethemes' ), $nice_phone_number ); ?>
							<?php endif; ?>
						</p>
					</div>
				<?php endif; ?>
		<!-- END #sidebar -->
		</aside>

<!-- END #container -->
</div>

<?php get_footer();