<?php
/**
 * Paeon by NiceThemes.
 *
 * Template Name: Blog - Masonry
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

add_filter( 'nice_load_flexslider_js', '__return_true', 10 );
add_filter( 'nice_load_more_posts_loader_js', '__return_true', 10 );

get_header(); ?>

<?php

if ( get_query_var( 'paged' ) ) :
	$paged = get_query_var( 'paged' );
elseif ( get_query_var( 'page' ) ) :
	$paged = get_query_var( 'page' );
else :
	$paged = 1;
endif;

query_posts( array( 'post_type' => 'post', 'paged' => $paged ) ); ?>

<hgroup class="page-head">

	<header class="main-title col-full">
		<div class="left">
			<h1 class="entry-title"><?php the_title(); ?></h1>
		</div>
	</header>

</hgroup>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content" class="full-width blog-masonry <?php echo esc_attr( $post->post_name ); ?>">

<?php if ( have_posts() ) : ?>

	<ul id="masonry-grid"  class="three-col-grid grid clearfix">

	<?php

			$columns = 3;
			$loop    = 0;

			while ( have_posts() ) : the_post();

			$loop++;
			?>
			<li id="post-<?php the_ID(); ?>" class="masonry-item <?php if ( $loop % $columns === 0 ) echo esc_attr( 'last' ); if ( ( $loop - 1 ) % $columns === 0 ) echo esc_attr( 'first' ); ?>">

				<!-- BEGIN .post -->
				<article class="post clearfix">

					<?php if ( has_post_thumbnail() ) :	?>
							<figure class="featured-image view view-more">
									<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>">
										<?php nice_image( array( 'width' => 580, 'height' => 405, 'class' => 'wp-post-image' ) ); ?>
										<div class="mask"></div>
									</a>
							</figure>
					<?php endif; ?>

					<header>
						<h2>
							<a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>"><?php the_title(); ?></a>
						</h2>
						<?php nice_post_meta_masonry(); ?>
					</header>

					<div class="entry">

						<div class="post-content">
							<?php nice_excerpt( 400 ); ?>
						</div>

					</div>

					<a class="readmore" href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>"> <?php _e( 'Read More', 'nicethemes' ); ?></a>

			<!-- END .post -->
			</article>

			</li>

	<?php endwhile; ?>

	</ul>

<?php else : ?>

	<?php _e( 'Sorry, no posts matched your criteria.', 'nicethemes' ); ?>

<?php endif; ?>

<div id="posts_ajax_loader"></div>

<!-- END #content -->
</section>

<!-- END #container -->
</div>

<?php get_footer();