<?php
/**
 * Paeon by NiceThemes.
 *
 * Template for `department` taxonomy
 *
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header();

get_template_part( 'page-title' ); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

	<!-- BEGIN #content -->
	<section class="col-full clearfix staff <?php the_title(); ?>">

		<?php

		if ( have_posts() ) :

			$count = 0;
			$columns = 3; ?>
			<ul id="staff" class="three-col-grid grid staff-grid clearfix">

			<?php while ( have_posts() ) :
					the_post();
					$count++;

					$terms = get_the_terms( get_the_ID(), 'department' ); ?>
				<li data-id="id-<?php echo esc_attr( $count ); ?>" class="<?php if ( $terms ) : foreach ( $terms as $term ) : echo 'term-'. esc_attr( $term->term_id ) . ' '; endforeach; endif;?>">
						<div class="boxgrid caption">

							<?php if ( has_post_thumbnail() ) : ?>
									<div class="thumb">
										<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>">
											<?php nice_image( array( 'key'	=> 'staff-image', 'width'  => 480, 'height' => 468 ) ) ; ?>
										</a>
									</div>
							<?php endif; ?>

							<span class="entry-title"><a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() )); ?>"><?php the_title(); ?></a></span>
							<div class="staff-deparment">
								<?php echo get_the_term_list( get_the_ID(), 'department', '', ', ', '' ); ?>
							</div>

							<?php $bio = get_post_meta( get_the_ID(), 'bio', true ); ?>
							<?php if ( $bio !== '' ) : ?>
								<div class="staff-intro-text">
									<?php echo $bio; ?>
								</div>
							<?php endif; ?>

						</div>
						<div class="staff-excerpt">
							<div class="excerpt-content">
								<?php nice_excerpt( 150 ); ?>
							</div>
								<a class="readmore" href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>"><?php _e( 'Read More', 'nicethemes' ); ?></a>
						</div>
						<div class="social clearfix">

							<?php $staff_facebook_url = get_post_meta( get_the_ID(), 'staff_facebook_url', true ); ?>
							<?php if ( $staff_facebook_url != '' ) : ?>
								<span class="facebook"><a href="<?php echo esc_url( $staff_facebook_url ); ?>" title="<?php esc_attr_e( 'Facebook', 'nicethemes' ); ?>"></a></span>
							<?php endif; ?>

							<?php $staff_twitter_url = get_post_meta( get_the_ID(), 'staff_twitter_url',true ); ?>
							<?php if( $staff_twitter_url != '' ) : ?>
								<span class="twitter"><a href="<?php echo esc_url( $staff_twitter_url ); ?>" title="<?php esc_attr_e( 'Twitter', 'nicethemes' ); ?>"></a></span>
							<?php endif; ?>

							<?php $staff_google_plus_url = get_post_meta( get_the_ID(), 'staff_google_plus_url',true ); ?>
							<?php if ( $staff_google_plus_url != '' ) : ?>
								<span class="google"><a href="<?php echo esc_url( $staff_google_plus_url ); ?>" title="<?php esc_attr_e( 'Google plus', 'nicethemes' ); ?>"></a></span>
							<?php endif; ?>

							<?php $staff_linkedin_url = get_post_meta( get_the_ID(), 'staff_linkedin_url',true ); ?>
							<?php if ( $staff_linkedin_url != '' ) : ?>
								<span class="linkedin"><a href="<?php echo esc_url( $staff_linkedin_url ); ?>" title="<?php esc_attr_e( 'Linkedin', 'nicethemes' ); ?>"></a></span>
							<?php endif; ?>

						</div>
				</li>

			<?php endwhile; ?>

			</ul>

		<?php endif; ?>

	<!-- END #content -->
	</section>

<!-- END #container -->
</div>

<?php get_footer();