<?php
/**
 * Paeon by NiceThemes.
 *
 * The Template for displaying all single posts.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header(); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content">

	<?php if ( have_posts() )
				while ( have_posts() ) :
					the_post(); ?>

			<article <?php post_class(); ?>>

				<header>
					<h1><?php the_title(); ?></h1>
					<?php nice_post_meta(); ?>
				</header>

				<div class="entry">

				<?php
				$embed = get_post_meta( $id, 'embed', true );
				$video_class = '';

				if ( $embed != '' ):
					echo nice_embed( array ( 'id' => get_the_ID() ) );
					$video_class = ' has-video';
				elseif ( has_post_thumbnail() ) : ?>

					<figure class="featured-image">
						<?php nice_image( array( 'width' => 730, 'height' => 338, 'class' => 'wp-post-image' ) ); ?>
					</figure>

					<?php endif; ?>

						<div class="post-content<?php echo esc_attr( $video_class ); ?>">
							<?php the_content( __( 'Continue reading', 'nicethemes' ) . ' &raquo;' ); ?>
						</div>

				</div>

		</article>

		<?php
			if ( nice_bool ( get_option( 'nice_post_author' ) ) ) :
					nice_post_author();
			endif;
		?>

		<?php comments_template( '', true ); ?>

		<?php wp_link_pages(); ?>

	<?php endwhile; ?>

<!-- END #content -->
</section>

<?php get_sidebar(); ?>

<!-- END #container -->
</div>

<?php get_footer();