<?php
/**
 * Paeon by NiceThemes.
 *
 * The Template for displaying all single staff items.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header(); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content" class="full-width <?php echo esc_attr( $post->post_name ); ?>">

<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<article <?php post_class(); ?>>

			<div class="entry">

				<?php
				$embed = get_post_meta( $id, 'embed', true );
				$video_image_class = '';

				if ( $embed != '' ) :
					echo nice_embed( array ( 'id' => get_the_ID() ) );
					$video_image_class = ' has-video';
				elseif ( has_post_thumbnail() ) :
					$video_image_class = ' has-image'; ?>

					<figure class="thumb">
						<?php nice_image( array( 'width' => 480, 'height' => 480, 'class' => 'wp-post-image' ) ); ?>
					</figure>

				<?php endif; ?>

				<div class="staff-info<?php echo esc_attr( $video_image_class ); ?>">
					<header>
						<h1><?php the_title(); ?></h1>
					</header>

					<div class="staff-deparment">
						<?php echo get_the_term_list( get_the_ID(), 'department', '', ', ', '' ); ?>
					</div>

					<?php $bio = get_post_meta( get_the_ID(), 'bio', true ); ?>
					<?php if ( $bio != '' ) : ?>
						<div class="staff-intro-text">
							<?php echo $bio; ?>
						</div>
					<?php endif; ?>

					<div class="excerpt-content">
						<?php the_excerpt(); ?>
					</div>

						<div class="social clearfix">

								<?php $staff_facebook_url = get_post_meta( get_the_ID(), 'staff_facebook_url', true ); ?>
								<?php if ( $staff_facebook_url != '' ): ?>
									<span class="facebook"><a href="<?php echo esc_url( $staff_facebook_url ); ?>" title="<?php esc_attr_e( 'Facebook', 'nicethemes' ); ?>"></a></span>
								<?php endif; ?>

								<?php $staff_twitter_url = get_post_meta( get_the_ID(), 'staff_twitter_url',true ); ?>
								<?php if ( $staff_twitter_url != '' ): ?>
									<span class="twitter"><a href="<?php echo esc_url( $staff_twitter_url ); ?>" title="<?php esc_attr_e( 'Twitter', 'nicethemes' ); ?>"></a></span>
								<?php endif; ?>

								<?php $staff_google_plus_url = get_post_meta( get_the_ID(), 'staff_google_plus_url',true ); ?>
								<?php if ( $staff_google_plus_url != '' ): ?>
									<span class="google"><a href="<?php echo esc_url( $staff_google_plus_url ); ?>" title="<?php esc_attr_e( 'Google plus', 'nicethemes' ); ?>"></a></span>
								<?php endif; ?>

								<?php $staff_linkedin_url = get_post_meta( get_the_ID(), 'staff_linkedin_url',true ); ?>
								<?php if ( $staff_linkedin_url != '' ): ?>
									<span class="linkedin"><a href="<?php echo esc_url( $staff_linkedin_url ); ?>" title="<?php esc_attr_e( 'Linkedin', 'nicethemes' ); ?>"></a></span>
								<?php endif; ?>

							</div>

					</div>

					<div class="post-content<?php echo esc_attr( $video_image_class ); ?>">
						<?php the_content( __( 'Continue reading', 'nicethemes' ) . ' &raquo;' ); ?>
					</div>

			</div>

		</article>

	<?php endwhile; ?>

	<?php endif; ?>

<!-- END #content -->
</section>

<!-- END #container -->
</div>

<?php get_footer();