<?php
/**
 * Paeon by NiceThemes.
 *
 * The Template for displaying all single services.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header(); ?>

<hgroup class="page-head">
	<header class="main-title col-full">
		<h1 class="entry-title"><?php the_title(); ?></h1>
	</header>
</hgroup>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content" class="full-width <?php echo esc_attr( $post->post_name ); ?>">

<?php if ( have_posts() ) : ?>

	<?php while ( have_posts() ) : the_post(); ?>

		<div class="entry clearfix">

			<?php
			$embed = get_post_meta( $id, 'embed', true );
			$video_class = '';

			if ( $embed != '' ):
				echo nice_embed( array ( 'id' => get_the_ID() ) );
				$video_class = ' has-video';
			elseif ( has_post_thumbnail() ) : ?>

				<figure class="featured-image">
					<?php nice_image( array( 'width' => 480, 'height' => 480, 'class' => 'wp-post-image' ) ); ?>
				</figure>

			<?php endif; ?>

			<div class="post-content<?php echo esc_attr( $video_class ); ?>">
				<?php the_content( __( 'Continue reading', 'nicethemes' ) . ' &raquo;' ); ?>
				<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'nicethemes' ), 'after' => '</div>' ) ); ?>
			</div>

		</div>

<?php endwhile; ?>

<?php else : ?>

	<header>
		<h2><?php _e( 'Not Found', 'nicethemes' ); ?></h2>
	</header>
	<p><?php _e( 'Sorry, but you are looking for something that isn\'t here.', 'nicethemes' ); ?></p>

	<?php get_search_form(); ?>

<?php endif; ?>

<!-- END #content -->
</section>

<!-- END #container -->
</div>

<?php get_footer();