<?php
/**
 * Paeon by NiceThemes.
 *
 * The template for displaying Search Results pages.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header(); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<div id="content" class="search-results">

<header>
	<h1 class="archive-header"><?php _e( 'Search Results', 'nicethemes' ); ?>: <?php the_search_query(); ?></h1>
</header>

<?php if ( have_posts() ) : ?>

	<?php while ( have_posts() ) : the_post(); ?>

			<article class="post clearfix">

				<header>
					<h2><a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>"><?php the_title(); ?></a></h2>
					<?php nice_post_meta(); ?>
				</header>

				<?php if ( has_post_thumbnail() ) : ?>

					<figure class="featured-image">
						<?php nice_image( array( 'width' => 620, 'height' => 285, 'class' => 'wp-post-image' ) ); ?>
					</figure>

				<?php endif; ?>

				<?php nice_excerpt(); ?>

			</article>

	<?php endwhile; ?>

		<?php nice_pagenavi(); ?>

<?php else : ?>

	<?php _e( 'Sorry, no posts matched your criteria.', 'nicethemes' ); ?>

<?php endif; ?>

<!-- END #content -->
</div>

<?php get_sidebar(); ?>

<!-- END #container -->
</div>

<?php get_footer();