<?php
/**
 * Paeon by NiceThemes.
 *
 * Displays page sub title block
 *
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

global $nice_options;

if ( is_category() || is_tax() ):
 	$title = single_cat_title( '', false );
else:
	$title = get_the_title();
endif;

$nice_phone_number = ( isset( $nice_options['nice_phone_number'] ) ) ? $nice_options['nice_phone_number'] : '';
$page_sub_title = get_post_meta( get_the_ID(), 'page_sub_title', true );

$main_title_class  = ( $nice_phone_number == '' ) ? 'full-width-title' : '';
$main_title_class .= ( $page_sub_title == '' ) ? ' large-width-title' : '';
?>

 <hgroup class="page-head">

	<header class="main-title col-full <?php echo esc_attr( $main_title_class ); ?>">
		<div class="left">
			<h1 class="entry-title"><?php echo $title; ?></h1>
			<?php if ( $page_sub_title != '' ) : ?>
			<span class="title-desc">
				<span class="display-table">
					<span>
						<?php echo esc_html( $page_sub_title ); ?>
					</span>
				</span>
			</span>
			<?php endif; ?>
		</div>
		<?php if ( $nice_phone_number !== '' ) : ?>
			<div class="right">
				<?php if ( isset( $nice_options['nice_call_now_text'] ) ) : ?>
					<span class="call-now"><?php echo esc_html( $nice_options['nice_call_now_text'] ); ?></span>
				<?php endif; ?>
				<?php if ( isset( $nice_options['nice_phone_number'] ) ) : ?>
					<span class="call-number"><?php echo esc_html( $nice_options['nice_phone_number'] ); ?></span>
				<?php endif; ?>
			</div>
		<?php endif; ?>
	</header>

 </hgroup>