<?php
/**
 * Paeon by NiceThemes.
 *
 * The main template file
 *
 * This is the most generic template file in a WordPress theme and one
 * of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query,
 * e.g., it puts together the home page when no home.php file exists.
 *
 * @link      http://codex.wordpress.org/Template_Hierarchy
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

get_header();

if ( get_query_var( 'paged' ) ) $paged = get_query_var( 'paged' ); elseif ( get_query_var( 'page' ) ) $paged = get_query_var( 'page' ); else $paged = 1;

query_posts( "post_type=post&paged=$paged" ); ?>

<!-- BEGIN #container -->
<div id="container" class="clearfix">

<!-- BEGIN #content -->
<section id="content" class="<?php echo esc_attr( $post->post_name ); ?>">

<?php if ( have_posts() ) : ?>

	<?php while ( have_posts() ) : the_post(); ?>

			<!-- BEGIN .post -->
			<article class="post clearfix">

				<?php if ( has_post_thumbnail() ) : ?>

					<figure class="featured-image view view-more">
						<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>">
							<?php nice_image( array( 'width' => 480, 'height' => 480, 'class' => 'wp-post-image' ) ); ?>
							<div class="mask"></div>
						</a>
					</figure>

				<?php endif; ?>

				<header>
					<h2><a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>"><?php the_title(); ?></a></h2>
			<?php nice_post_meta(); ?>
				</header>

				<div class="entry">

					<div class="post-content">
						<?php nice_excerpt( 400 ); ?>
					</div>

				</div>

				<a class="readmore" href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>" title="<?php printf( __( 'Permanent Link to %s', 'nicethemes' ), esc_attr( get_the_title() ) ); ?>"><?php _e( 'Read More', 'nicethemes' ); ?></a>

			<!-- END .post -->
			</article>

	<?php endwhile; ?>

<?php else : ?>

		<?php _e( 'Sorry, no posts matched your criteria.', 'nicethemes' ); ?>

<?php endif; ?>

<?php nice_pagenavi(); ?>

<!-- END #content -->
</section>

<?php get_sidebar(); ?>

<!-- END #container -->
</div>

<?php get_footer();