<?php
  /*---------------------------------------------------------------------------------*/
 /* Appointments																*/
/*---------------------------------------------------------------------------------*/
class Nice_Appointments extends WP_Widget {

	function __construct() {

		$this->alt_option_name = 'nice_appointments';

		parent::__construct( 'nice_appointments', __( '(NiceThemes) Appointments', 'nicethemes' ),
			array(
				'description' => __( 'This widget displays the Appoinments Form.', 'nicethemes' )
			)
		);

		add_action( 'save_post', array( &$this, 'flush_widget_cache' ) );
		add_action( 'deleted_post', array( &$this, 'flush_widget_cache' ) );
		add_action( 'switch_theme', array( &$this, 'flush_widget_cache' ) );

	} // end __construct()

	function widget( $args, $instance ) {

		$cache = wp_cache_get( 'widget_nice_appointments', 'widget' );

		if ( ! is_array( $cache ) )
			$cache = array();

		if ( ! isset( $args['widget_id'] ) )
			$args['widget_id'] = $this->id;

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();

		extract( $args );
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance );
		$custom_email = $instance['custom_email'];

		?>
			<?php echo $before_widget; ?>
			<?php if ( $title ) { echo $before_title . $title . $after_title; } ?>

			<form id="nice_appointment"  name="nice_appointment" method="post">

				<fieldset>
					<p>
						<label class="display-ie8" for="name" form="nice_appointment"><?php _e( 'Your Name', 'nicethemes' ); ?></label>
						<input type="text" name="name" class="required" id="name" placeholder="<?php _e( 'Your Name', 'nicethemes' ); ?>" title="<?php _e( '* Please enter your Full Name', 'nicethemes' ); ?>" />
					</p>
					<p>
						<label class="display-ie8" for="phone" form="nice_appointment"><?php _e( 'Your Phone Number', 'nicethemes' ); ?></label>
						<input type="text" name="phone" class="required" id="phone" placeholder="<?php _e( 'Your Phone Number', 'nicethemes' ); ?>" title="<?php _e( 'Please enter your Phone Number', 'nicethemes' ); ?>" />
					</p>
					<p>
						<label class="display-ie8" for="mail" form="nice_appointment"><?php _e( 'Your E-mail', 'nicethemes' ); ?></label>
						<input  type="text" name="mail"  class="email required" id="mail" placeholder="<?php _e( 'Your E-mail', 'nicethemes' ); ?>" title="<?php _e( 'Please enter valid E-mail Address', 'nicethemes' ); ?>" />
					</p>
					<p>
						<label class="display-ie8" for="appo_date" form="nice_appointment"><?php _e( 'Appointment Date', 'nicethemes' ); ?></label>
						<input type="text" name="date" class="required datepicker" id="appo_date" placeholder="<?php _e( 'Appointment Date', 'nicethemes' ); ?>" title="<?php _e( 'Please select desired appointment date', 'nicethemes' ); ?>" readonly="readonly" />
					</p>
					<p>
						<label class="display-ie8" for="message" form="nice_appointment"><?php _e( 'Your Message', 'nicethemes' ); ?></label>
						<textarea name="message" class="message required" cols="30" rows="5" id="message" placeholder="<?php _e( 'Your Message', 'nicethemes' ); ?>" title="<?php _e( 'Please enter your message', 'nicethemes' ); ?>"></textarea>
					</p>

					<p>
						<input type="submit" value="<?php _e( 'Submit Request', 'nicethemes' ); ?>" class="readmore" >
						<input type="hidden" name="target" value="<?php echo esc_attr( $custom_email ); ?>" />
					</p>
				</fieldset>

					<div id="node"></div>
					<div id="success"><?php _e( 'Thank you for leaving a message.', 'nicethemes' ); ?></div>

			</form>

		<?php

		echo $after_widget;

		$cache[$args['widget_id']] = ob_get_flush();
		wp_cache_set( 'widget_nice_appointments', $cache, 'widget' );

	}

	function update( $new_instance, $old_instance ) {

		$this->flush_widget_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset( $alloptions['nice_feedback'] ) )
			delete_option('nice_feedback');

		return $new_instance;
	}

	function flush_widget_cache() {
		wp_cache_delete( 'widget_nice_appointments', 'widget' );
	}

	function form( $instance ) {

		$title = esc_attr( $instance['title'] );

		$custom_email = esc_attr( $instance['custom_email'] );
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title', 'nicethemes' ); ?>:</label>
			<input type="text" name="<?php echo $this->get_field_name('title'); ?>"  value="<?php echo $title; ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('custom_email'); ?>"><?php _e( 'Email', 'nicethemes' ); ?>:</label>
			<input type="text" name="<?php echo $this->get_field_name( 'custom_email' ); ?>"  value="<?php echo $custom_email; ?>" class="widefat" id="<?php echo $this->get_field_id('custom_email'); ?>" />
		</p>

		<?php
	}
} // end nice_appointments classs

register_widget( 'Nice_Appointments' );