<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains functions to manage widget areas publicly.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2014-2015 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_footer_widgets' ) ) :
add_action( 'nice_footer_widgets', 'nice_footer_widgets' );
/**
 * Print the footer widgets.
 *
 * @since 1.0.0
 *
 * @param  array $args
 * @return string
 */
function nice_footer_widgets( $args = array() ) {

	global $nice_options;

	$defaults = apply_filters( 'nice_footer_widgets_default_args', array(
							'echo'    => true,
							'columns' => '4',
							'before'  => '<!-- BEGIN #footer-widget --><div id="footer-widgets" class="col-full">',
							'after'   => '</div><!-- /#footer-widgets -->')
			);

	$args = wp_parse_args( $args, $defaults );

	$args = apply_filters( 'nice_footer_widgets_args', $args );

	do_action( 'nice_footer_widgets_before', $args );

	$output = '';

	$nice_footer_columns = ( ! empty( $nice_options['nice_footer_columns'] ) ) ? $nice_options['nice_footer_columns'] : $args['columns'];


	$class = ' columns-' . esc_attr( intval( $nice_footer_columns ) );

	if ( 	is_active_sidebar( 'footer-1' ) ||
			is_active_sidebar( 'footer-2' ) ||
			is_active_sidebar( 'footer-3' ) ||
			is_active_sidebar( 'office1-timming' ) ||
			is_active_sidebar( 'office2-timming' ) ||
			is_active_sidebar( 'heading' ) ||
			is_active_sidebar( 'footer-4' ) ) : ?>

		<?php echo $args['before']; ?>

			<div class="grid footer-grid">

				<div class="widget-section first <?php echo $class; ?>">
					<?php dynamic_sidebar( 'footer-1' ); ?>
				</div>
				<div class="foot-right">
					<?php dynamic_sidebar( 'heading' ); ?>
				<div class="widget-section even <?php echo $class; ?>">
					<?php dynamic_sidebar( 'footer-2' ); ?>
					<?php dynamic_sidebar( 'office-timming-link' ); ?>
				</div>
				<?php if ( $nice_footer_columns === '3' || $nice_footer_columns === '4' ) : ?>
				<?php if ( $nice_footer_columns === '3' ) $class .= ' last'; ?>
				<div class="widget-section odd <?php echo $class; ?>">
					<?php dynamic_sidebar( 'footer-3' ); ?>
					<?php dynamic_sidebar( 'office-timming-link' ); ?>
				</div>
			</div>

				<?php endif; ?>
				<?php if ( $nice_footer_columns === '4' ) : ?>
				<div class="widget-section odd <?php echo $class; ?> last">
					<?php dynamic_sidebar( 'footer-4' ); ?>
				</div>
				<?php endif; ?>
			</div>

		<?php echo $args['after']; ?>

		<?php endif;

	$output = apply_filters( 'nice_footer_widgets_html', $output, $args );

	if ( $args['echo'] === true ) echo $output;
	else return $output;

	do_action( 'nice_footer_widgets_after', $args );

}

endif;
