<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains functions to manage the different typography options.
 *
 * @see nice_custom_fonts()
 * @see nice_load_web_fonts()
 * @see nice_default_fonts()
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2014-2015 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_custom_fonts' ) ) :
add_action( 'wp_enqueue_scripts', 'nice_custom_fonts', 20 );
/**
 * Add custom fonts.
 *
 * @since 1.0.0
 */
function nice_custom_fonts() {

	global $nice_options;

	$output = '';

	wp_enqueue_style( 'nice-options-styles', get_template_directory_uri() . '/includes/assets/css/nice-options.css' );

	if ( isset( $nice_options['nice_custom_typography'] ) && ( nice_bool( $nice_options['nice_custom_typography'] ) ) ) {

		if ( isset( $nice_options['nice_font_body'] ) && $nice_options['nice_font_body'] )
			$output .= 'body { ' . nice_custom_font_css( $nice_options['nice_font_body'] ) . ' }' . "\n";

		if ( isset( $nice_options['nice_font_nav'] ) && $nice_options['nice_font_nav'] )
			$output .= '#header #navigation .nav li a, #navigation .nav li ul li a, #top #navigation .nav li ul li a {' . nice_custom_font_css( $nice_options['nice_font_nav'] ) . ' }' . "\n";

		if ( isset( $nice_options['nice_font_post_title'] ) && $nice_options['nice_font_post_title'] )
			$output .= '.post h2 { ' . nice_custom_font_css( $nice_options['nice_font_post_title'] ) . ' }' . "\n";

		if ( isset( $nice_options['nice_font_post_meta'] ) && $nice_options['nice_font_post_meta'] )
			$output .= '.post-meta { ' . nice_custom_font_css( $nice_options['nice_font_post_meta'] ) . ' }' . "\n";

		if ( isset( $nice_options['nice_font_post_entry'] ) && $nice_options['nice_font_post_entry'] )
			$output .= '.entry, .post-content { ' . nice_custom_font_css( $nice_options['nice_font_post_entry'] ) . ' }' . "\n";

		if ( isset( $nice_options['nice_font_welcome_message'] ) && $nice_options['nice_font_welcome_message'] )
			$output .= '.welcome-message h2 { ' . nice_custom_font_css( $nice_options['nice_font_welcome_message'] ) . ' }' . "\n";

		if ( isset( $nice_options['nice_font_welcome_message_extended'] ) && $nice_options['nice_font_welcome_message_extended'] )
			$output .= '.welcome-message p { ' . nice_custom_font_css( $nice_options['nice_font_welcome_message_extended'] ) . ' }' . "\n";

		if ( isset( $nice_options['nice_font_slider_title'] ) && $nice_options['nice_font_slider_title'] )
			$output .= '.flexslider .slides li h2 {' . nice_custom_font_css( $nice_options['nice_font_slider_title'] ) . ' }' . "\n";

		if ( isset( $nice_options['nice_font_slider_content'] ) && $nice_options['nice_font_slider_content'] )
			$output .= '.flex-caption p { ' . nice_custom_font_css( $nice_options['nice_font_slider_content'] ) . ' }' . "\n";

	}

	// Add Text title and tagline if text title option is enabled
	if ( isset( $nice_options['nice_texttitle'] ) && ( nice_bool( $nice_options['nice_texttitle'] ) ) ) {

		if ( $nice_options['nice_font_site_title'] ){

			$output .= '#header #top #logo a .text-logo { ' . nice_custom_font_css( $nice_options['nice_font_site_title'] ) . ' }' . "\n";

		}
	}

	if ( isset( $output ) && $output != '' ) {
		$output = strip_tags( '/* Nice Custom Fonts */' . "\n\n" . $output );
		wp_add_inline_style( 'nice-options-styles', $output );
	}

}
endif;

$is_new_framework = defined( 'NICE_FRAMEWORK_VERSION' ) && version_compare( NICE_FRAMEWORK_VERSION, '2.0', '>=' );

if ( ! function_exists( 'nice_get_web_fonts_uri' ) && ! $is_new_framework ) :
/**
 * Obtain URL for web fonts.
 *
 * @since  1.0.0
 * @return string
 */
function nice_get_web_fonts_uri() {
	global $nice_options, $google_fonts;

	if ( ! $nice_options ) {
		$nice_options = get_option( 'nice_options' );
	}

	$fonts = '';

	foreach ( $nice_options as $option ) {
		if ( ! empty ( $option['family'] ) ) {
			foreach ( $google_fonts as $font ) {
				if ( ( $option['family'] == $font['name'] ) && ( ! strstr( $fonts, $font['name'] ) ) ) {
					$fonts .= $font['name'] . $font['variant'] . "|";
				}
			}
		}
	}

	if ( $fonts ) {
		$fonts = '//fonts.googleapis.com/css?family=' . str_replace( " ", "+", $fonts );
	}

	return $fonts;

}
endif;

if ( ! function_exists( 'nice_load_web_fonts' ) ) :
add_action( 'wp_head', 'nice_load_web_fonts', 15 );
/**
 * Load web fonts.
 *
 * @since 1.0.0
 */
function nice_load_web_fonts() {
	global $nice_options;

	$html  = '';

	// Go through the options.
	if (   ( isset( $nice_options['nice_text_title'] ) && ( nice_bool( $nice_options['nice_text_title'] ) ) )
		|| ( isset( $nice_options['nice_custom_typography'] ) && ( nice_bool( $nice_options['nice_custom_typography'] ) ) )
	) {
		// Output Google Font CSS in header.
		if ( $fonts = nice_get_web_fonts_uri() ) {
			$html .= "\n\n<!-- Nice Google fonts -->\n";
			$html .= '<link href="' . $fonts . '" rel="stylesheet" type="text/css" />' . "\n";
			$html = str_replace( '|"', '"', $html );

			echo $html . "\n\n";
		}

		if ( ( ! nice_bool( $nice_options['nice_custom_typography'] ) ) ) {
			nice_default_fonts();
		}
	} else {
		// Fix for updated themes where no typography options were saved.
		nice_default_fonts();
	}
}
endif;

if ( ! function_exists( 'nice_get_default_fonts_uri' ) ) :
/**
 * Obtain URL for default fonts.
 *
 * @since 1.0.0
 */
function nice_get_default_fonts_uri() {
	return apply_filters( 'nice_default_fonts_uri', '//fonts.googleapis.com/css?family=Open+Sans:700|Raleway:200,400,500,600,700,800' );
}
endif;


if ( ! function_exists( 'nice_default_fonts' ) ) :
/**
 * HTML to load a default font.
 *
 * @since  1.0.0
 * @return string
 */
function nice_default_fonts() {
	ob_start();

	// Start template. ?>
	<link href="<?php echo nice_get_default_fonts_uri(); ?>" rel="stylesheet" type="text/css">
	<?php // End template.

	$output = ob_get_contents();
	ob_end_clean();

	$output = apply_filters( 'nice_default_fonts', $output );

	echo $output;
}
endif;
