<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains functions to manage the front-end setup of the theme.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2014-2015 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_theme_setup' ) ) :
add_action( 'after_setup_theme', 'nice_theme_setup' );
/**
 * Basic setup for this theme.
 *
 * @since 1.0.0
 */
function nice_theme_setup() {

	// This tells the FW where to get updates from.
	define ( 'NICE_THEME_SLUG', 'paeon' );

	$hard_crop = get_option( 'nice_wp_resize_crop' );
	$hard_crop = nice_bool( $hard_crop );

	add_image_size( 'nice-template-blog',         480, 480, $hard_crop );
	add_image_size( 'nice-slide',               2560, 1000, $hard_crop );
	add_image_size( 'nice-feedback',              200, 200, $hard_crop );
	add_image_size( 'nice-single-post',           730, 338, $hard_crop );
	add_image_size( 'nice-template-archive',      320, 200, $hard_crop );
	add_image_size( 'nice-template-masonry-blog', 580, 405, $hard_crop );
	add_image_size( 'nice-template-search',       620, 285, $hard_crop );
	add_image_size( 'nice-template-staff',        480, 468, $hard_crop );
	add_image_size( 'nice-template-contact',      480, 755, $hard_crop );
	add_image_size( 'nice-home-service',          480, 390, $hard_crop );
	add_image_size( 'nice-template-service-two',  480, 180, $hard_crop );

	add_theme_support( 'title-tag' );

}
endif;

/**
 * Make sure to use logo functionality from FW 2.0+ if available.
 *
 * @since 1.1.9
 */
add_filter( 'nice_logo_compatibility', '__return_false' );

if ( ! function_exists( 'nice_logo_filter' ) ) :
add_filter( 'nice_logo_default_args', 'nice_logo_filter' );
/**
 * Set the logo arguments for the function `nice_logo()`.
 *
 * @see    nice_logo()
 *
 * @since  1.0.0
 *
 * @param  array $args Non-filtered arguments.
 * @return array       Filtered arguments.
 */
function nice_logo_filter( $args ) {
	$nice_text_title = get_option( 'nice_texttitle' );

	if ( ! empty( $nice_text_title ) && nice_bool( $nice_text_title ) ) {
		$args['text_title'] = true;
	}

	/**
	 * Make sure to use logo functionality from FW 2.0+ if available.
	 *
	 * @since 1.1.9
	 */
	if ( version_compare( NICE_FRAMEWORK_VERSION, '2.0', '<' ) ) {
		$nice_logo = get_option( 'nice_logo' );

		if ( ! empty( $nice_logo ) ) {
			$args['logo'] = $nice_logo;
		}

		$nice_logo_retina = get_option( 'nice_logo_retina' );
		if ( ! empty( $nice_logo_retina ) ) {
			$args['logo'] = $nice_logo_retina;
		}
	} else {
		$args['default_image'] = nice_logo_default_image();
		$args['images'] = apply_filters( 'nice_logo_images', array() );
	}

	return $args;
}
endif;

if ( ! function_exists( 'nice_logo_default_image' ) ) :
/**
 * Set default image values for logo.
 *
 * @since 1.1.9
 *
 * @param array $args
 *
 * @return array
 */
function nice_logo_default_image( array $args = array() ) {
	return array(
		'name'       => 'default-logo',
		'id'         => 'default-logo',
		'id_retina'  => 'retina-logo',
		'url'        => nice_get_file_uri( 'images/logo.png' ),
		'url_retina' => nice_get_file_uri( 'images/logo@2x.png' ),
		'img_class'  => array( 'img-default-logo' ),
	);
}
endif;

if ( ! function_exists( 'nice_logo_images' ) ) :
add_filter( 'nice_logo_images', 'nice_logo_images' );
/**
 * Obtain logo images.
 *
 * @since 1.1.9
 *
 * @param array $images
 *
 * @return array
 */
function nice_logo_images( array $images = array() ) {
	$logo_url = nice_get_option( '_logo' );

	if ( $logo_url ) {
		$images[] = array(
			'name'       => 'custom-logo',
			'id'         => 'default-logo',
			'id_retina'  => 'retina-logo',
			'url'        => esc_url( $logo_url ),
			'url_retina' => esc_url( nice_get_option( '_logo_retina' ) ),
			'img_class'  => array( 'img-custom-logo' ),
			'height'     => nice_get_option( '_logo_height' ),
		);
	}

	return $images;
}
endif;

if ( ! function_exists( 'nice_logo_delete_transients' ) ) :
add_action( 'update_option_nice_options', 'nice_logo_delete_transients' );
/**
 * Remove image size transients when options are updated.
 *
 * @since 1.1.9
 */
function nice_logo_delete_transients() {
	if ( ! class_exists( 'Nice_Logo_Image' ) ) {
		nice_loader( 'engine/admin/classes/class-nice-logo-image.php' );
	}

	Nice_Logo_Image::delete_transients();
}
endif;

if ( ! function_exists( 'nice_copyright_filter' ) ) :
add_filter( 'nice_copyright_default_args', 'nice_copyright_filter' );
/**
 * Set the copyright arguments for this the function nice_copyright()
 *
 * @since 1.0.0
 *
 * @param  array  $args
 * @return string
 */
function nice_copyright_filter( $args ){

	global $nice_options;

	$text = '';

	$custom_copyright_enable = get_option( 'nice_custom_copyright_enable' );

	if ( isset( $custom_copyright_enable ) && ( $custom_copyright_enable === 'true' ) ) {

		$custom_copyright_text = get_option( 'nice_custom_copyright_text' );

		if ( isset( $custom_copyright_text ) && ( $custom_copyright_text <> '' ) ) {
			$text .= $custom_copyright_text;
		}

	} else {

		$text = '<a href="https://nicethemes.com/product/paeon/" target="_blank" title="Paeon WordPress Theme">Paeon</a> ' . sprintf( __( 'by %s', 'nicethemes' ), '<a href="https://nicethemes.com" title="Wordpress Nice Themes">Nice Themes</a>' ) .' &copy; ' . date( 'Y' ) . ' &mdash; ' . sprintf( __( 'Powered by %s', 'nicethemes' ), '<a href="http://wordpress.org">WordPress</a>' ) . '.';

	}

	$args['text'] = $text;

	return $args;
}
endif;

if ( ! function_exists( 'nice_copyright_filter' ) ) :
add_filter( 'nicethemes_gallery_default_args', 'nicethemes_gallery_filter' );
/**
 * nicethemes_gallery_filter()
 *
 * Set the gallery arguments for the function nice_gallery
 *
 * @since 1.0.6
 *
 * @param  array  $args
 * @return string
 */

function nicethemes_gallery_filter( $args ) {

	$args['columns'] = 5;

	return $args;
}

endif;


if ( ! function_exists( 'nice_theme_body_classes' ) ) :
add_filter( 'body_class', 'nice_theme_body_classes' );
/**
 * nice_theme_body_classes()
 *
 * set bodyclass for the sidebar alignment.
 *
 * @since 1.0.1
 *
 */
function nice_theme_body_classes( $classes ) {

	global $nice_options;

	if ( is_page_template( 'template-home.php' ) && nice_bool( $nice_options['nice_slider'] )  ) {

		$has_slides = get_posts( array ( 'post_type' => 'slide', 'showposts' => 1 ) );

		if ( ! empty ( $has_slides ) ) :

			$classes[] = 'has-slider has-slider-menu';

		endif;

	}

	return $classes;

}

endif;


class Nice_Walker extends Walker_Category {

function start_el( &$output, $category, $depth = 0 , $args = array(), $current_category = 0 ) {

	extract( $args );
	$cat_name = esc_attr( $category->name );
	$cat_name = apply_filters( 'list_cats', $cat_name, $category );
		$link = '<a href="#" data-value="term-' . $category->term_id . '" ';
	if ( $use_desc_for_title == 0 || empty( $category->description ) )
		$link .= 'title="' . sprintf( __( 'View all items filed under %s', 'nicethemes' ), $cat_name ) . '"';
	else
		$link .= 'title="' . esc_attr( strip_tags( apply_filters( 'category_description', $category->description, $category ) ) ) . '"';
	$link .= '>';
	$link .= $cat_name . '</a>';

	$link .= '</a><span class="border"></span><span class="sep"></span>';
	if ( ( ! empty( $feed_image ) ) || ( ! empty( $feed )) ) {
		$link .= ' ';
		if ( empty( $feed_image ) )
			$link .= '(';
		$link .= '<a href="' . get_category_feed_link( $category->term_id, $feed_type ) . '"';
		if ( empty( $feed ) )
			$alt = ' alt="' . sprintf( __( 'Feed for all posts filed under %s', 'nicethemes' ), $cat_name ) . '"';
		else {
			$title = ' title="' . $feed . '"';
			$alt = ' alt="' . $feed . '"';
			$name = $feed;
			$link .= $title;
		}
		$link .= '>';
		if ( empty( $feed_image) )
			$link .= $name;
		else
			$link .= "<img src='$feed_image'$alt$title" . ' />';
		$link .= '</a>';
		if ( empty( $feed_image) )
			$link .= ')';
		}
		if ( isset( $show_count ) && $show_count )
			$link .= ' (' . intval( $category->count ) . ')';
		if ( isset( $show_date) && $show_date ) {
			$link .= ' ' . gmdate( 'Y-m-d', $category->last_update_timestamp );
		}
		if ( isset( $current_category) && $current_category )
			$_current_category = get_category( $current_category );
		if ( 'list' == $args['style'] ) {
			$output .= '<li class=" ';
			$class = 'segment-' . $category->term_id. ' cat-item cat-item-' . $category->term_id;
			if ( isset( $current_category) && $current_category && ( $category->term_id == $current_category ) )
				$class .=  ' current-cat';
			elseif ( isset( $_current_category) && $_current_category && ( $category->term_id == $_current_category->parent ) )
				$class .=  ' current-cat-parent';
			$output .=  $class . '"';
			$output .= ">$link\n";
		} else {
			$output .= "\t$link<br />\n";
		}
	}
}

if ( ! function_exists( 'nice_back_to_top' ) ) :
add_action( 'wp_footer', 'nice_back_to_top' );
/**
 * Add the code for the back to top button (if enabled through options).
 *
 * @since 1.0.0
 */
function nice_back_to_top() {
	global $nice_options;
	$nice_back_to_top = ! empty( $nice_options['nice_back_to_top'] ) && 'true' === $nice_options['nice_back_to_top'];

	ob_start();

	// Start template. ?>
	<?php if ( $nice_back_to_top ) : ?>
		<a href="#" class="backtotop">
			<i class="fa fa-chevron-up"></i>
		</a>
	<?php endif; ?>
	<?php // End template.

	$output = ob_get_contents();
	ob_end_clean();

	$output = apply_filters( 'nice_back_to_top', $output );

	echo $output;
}
endif;