<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains functions to manage the custom styles for the theme.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2014-2015 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_custom_styling' ) ) :
add_action( 'wp_enqueue_scripts', 'nice_custom_styling', 8 );
/**
 * Add Custom Styling.
 *
 * @since 1.0.0
 */
function nice_custom_styling() {

	global $nice_options;

	$output = '';

	wp_enqueue_style( 'nice-options-styles', get_template_directory_uri() . '/includes/assets/css/nice-options.css' );

	$nice_accent_color = get_option( 'nice_accent_color' );
	if ( isset( $nice_accent_color ) ) {
		$output .= '/* Nice Custom Styling */'. "\n\n";
		$output .= '#navigation .nav li:hover a, #navigation .nav li.current-menu-ancestor a, #navigation .nav li.current-menu-item a, #navigation .nav li.sfHover, .nav li ul, #top #navigation .nav li ul li a, ul.four-col-grid .thumb a, .nice-contact-form input[type=submit], input[type="submit"], #tabs .inside .tags a:hover, .flex-caption a.read-more, #header #top #toggle-nav, #navigation .nav li.current-menu-parent a { background-color: ' . $nice_accent_color . ';  }' . "\n";
		$output .= '#filter li a:hover, #filter li.active a{ background: ' . $nice_accent_color . ';  }' . "\n";
		$output .= '#footer .testimonials .feedback .feedback-url, a, body #sidebar .widget_nice_appointments h3, .home-block h3, .welcome-message h2 b, .welcome-message h2 strong, .welcome-message h2 span, .one-col-grid.service-grid .entry-title a,.page-head h1.entry-title, body.page-template-template-contact-php #content h3, span.required, .home-staff li .staff-deparment a:hover, body.single-staff .staff-info header h1, .nice-contact-form #node{ color: ' . $nice_accent_color . ';  }' . "\n";
		$output .= '.entry blockquote{ border-left-color: ' . $nice_accent_color . ';  }' . "\n";
		$output .= '.flex-caption p a{ border-bottom-color: ' . $nice_accent_color . ';  }' . "\n";

	}

	$nice_secondary_color = get_option( 'nice_secondary_color' );
	if ( isset( $nice_secondary_color ) ) {
		$output .= '.call-number{ color: ' . $nice_secondary_color . ';  }' . "\n";
		$output .= '#commentform input[type="submit"], #footer-widgets .textwidget .read-more-link, #nice_appointment input[type="submit"], .button-bg{ background: ' . $nice_secondary_color . ';  }' . "\n";
	}

	$nice_header_background_color = get_option( 'nice_header_background_color' );
	if ( isset( $nice_header_background_color ) && $nice_header_background_color ) {
		$output .= '#header { background-color: ' . $nice_header_background_color. '; }' . "\n";
		$output .= '@media screen and (max-width: 1024px) { .has-slider #header { background-color: ' . $nice_header_background_color . '; } }' . "\n";
		$output .= '@media screen and (max-width: 1366px) { body.iphone.has-slider #header { background-color: ' . $nice_header_background_color . '; } }' . "\n";
	}

	$nice_header_background_image = get_option( 'nice_header_background_image' );
	if ( isset( $nice_header_background_image ) && $nice_header_background_image ) {
		$output .= '#header { background-image: url(' . $nice_header_background_image . '); }' . "\n";
	}

	$nice_header_background_image_position = get_option( 'nice_header_background_image_position' );
	if ( isset( $nice_header_background_image_position ) && $nice_header_background_image_position ) {
		$output .= '#header { background-position: ' . $nice_header_background_image_position . '; }' . "\n";
	}

	$nice_header_background_image_repeat = get_option( 'nice_header_background_image_repeat' );
	if ( isset( $nice_header_background_image_repeat ) && $nice_header_background_image_repeat ) {
		$output .= '#header { background-repeat : ' . $nice_header_background_image_repeat . '; }' . "\n";
	}

	$nice_logo_height = get_option( 'nice_logo_height' );
	if ( isset( $nice_logo_height )  && $nice_logo_height != '' ) {
		$output .= '#default-logo, #retina-logo { height : ' . $nice_logo_height . 'px; }' . "\n";
		$output .= '@media only screen and (-moz-min-device-pixel-ratio: 1.5),
						only screen and (-o-min-device-pixel-ratio: 3/2),
						only screen and (-webkit-min-device-pixel-ratio: 1.5),
						only screen and (min-device-pixel-ratio: 1.5),
						only screen and (min-resolution: 144dpi) { #header #top #logo #retina-logo { height : ' . $nice_logo_height . 'px; } }';
	}

	if ( isset( $nice_options['nice_header_background_color'] ) && isset( $output ) && $output != '' ) {
		wp_add_inline_style( 'nice-options-styles', apply_filters( 'nice_inline_styles', $output ) );
	}

}
endif;
