<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains functions that print out HTML.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_pagenavi' ) ) :
/**
 * nice_pagenavi()
 *
 * If wp_pagenavi exists, it shows it.
 * else, it shows the < previous | next > links.
 *
 * @since 1.0.0
 *
 */
function nice_pagenavi() {
	ob_start();

	if ( function_exists( 'wp_pagenavi' ) ) {

		wp_pagenavi();

	} else { ?>

		<?php if ( get_next_posts_link() || get_previous_posts_link() ) { ?>

			<nav class="nav-entries">
				<?php next_posts_link( '<div class="nav-prev fl">'. __( 'Older posts', 'nicethemes' ) . '</div>' ); ?>
				<?php previous_posts_link( '<div class="nav-next fr">'. __( 'Newer posts', 'nicethemes' ) . '</div>' ); ?>
				<div class="fix"></div>
			</nav>

		<?php } ?>

	<?php }

	$output = ob_get_contents();
	ob_end_clean();

	$output = apply_filters( 'nice_pagenavi', $output );

	echo $output;
}

endif;


if ( ! function_exists( 'nice_post_meta' ) ) :
/**
 * nice_post_meta()
 *
 * Post metadata, nicely displayed.
 *
 * @since 1.0.0
 *
 */
function nice_post_meta() {
	ob_start(); ?>

	<p class="post-meta">
		<span class="post-author"><span class="small"><?php _e( 'Posted by', 'nicethemes' ) ?></span> <?php the_author_posts_link(); ?></span>
		<span class="post-date"><time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time></span>
		<span class="post-comments"><?php comments_popup_link( __( 'No Comments', 'nicethemes' ), __( '1 Comment', 'nicethemes' ), __( '% Comments', 'nicethemes' ) ); ?></span>
		<?php edit_post_link( __( '{ Edit }', 'nicethemes' ), '<span class="small">', '</span>' ); ?>
	</p>
<?php

	$output = ob_get_contents();
	ob_end_clean();

	$output = apply_filters( 'nice_post_meta', $output );

	echo $output;
}
endif;

if ( ! function_exists( 'nice_post_meta_masonry' ) ) :
/**
 * nice_post_meta_masonry()
 *
 * Post metadata, nicely displayed for the masonry template
 *
 * @since 1.0.0
 *
 */
function nice_post_meta_masonry() {
	ob_start(); ?>

	<p class="post-meta">
		<span class="post-author"><span class="small"><?php _e( 'By', 'nicethemes' ) ?></span> <?php the_author_posts_link(); ?></span>
		<span class="post-date"><time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time></span>
		<?php edit_post_link( __( '{ Edit }', 'nicethemes' ), '<span class="small">', '</span>' ); ?>
	</p>
<?php

	$output = ob_get_contents();
	ob_end_clean();

	$output = apply_filters( 'nice_post_meta_masonry', $output );

	echo $output;
}
endif;


if ( ! function_exists( 'nice_post_author' ) ) :
/**
 * nice_post_author()
 *
 * Post author info, nicely displayed.
 *
 * @since 1.0.0
 *
 */
function nice_post_author() {
	ob_start();

	global $post, $nice_options;

	if ( isset( $nice_options['nice_post_author'] ) && $nice_options['nice_post_author'] == "true" ) {
?>

		<div id="post-author">
			<div class="profile-image thumb"><?php echo get_avatar( get_the_author_meta( 'ID' ), '70' ); ?></div>
				<div class="profile-content">
					<h4 class="title"><?php printf( esc_attr__( 'About %s', 'nicethemes' ), get_the_author() ); ?></h4>
					<?php the_author_meta( 'description' ); ?>
					<div class="profile-link">
						<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
							<?php printf( __( 'View all posts by %s <span class="meta-nav">&rarr;</span>', 'nicethemes' ), get_the_author() ); ?>
						</a>
					</div><!-- #profile-link -->
			</div><!-- .post-entries -->
			<div class="fix"></div>
		</div><!-- #post-author -->
<?php
	}
	$output = ob_get_contents();
	ob_end_clean();

	$output = apply_filters( 'nice_post_author', $output );

	echo $output;
}
endif;


if ( ! function_exists( 'nice_wp_title' ) ) :
add_filter( 'wp_title', 'nice_wp_title' );
/**
 * Customize the page title.
 *
 * Hook origin:
 * @see wp_title()
 *
 * @since  1.2.2
 *
 * @param string $title Page title.
 *
 * @return string
 */
function nice_wp_title( $title ) {
	return $title . get_bloginfo( 'name' );
}
endif;
