<?php
/**
 * Paeon by NiceThemes.
 *
 * This file includes functions to manage styles for the theme.
 *
 * @see nice_styles()
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_styles' ) ) :
add_action( 'wp_enqueue_scripts', 'nice_styles', 1 );
/**
 * Load CSS files.
 *
 * @uses wp_register_style()
 * @uses wp_enqueue_style()
 *
 * @since 1.0.0
 */
function nice_styles() {
	/**
	 * Load main styles.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_default_styles', true ) ) {
		wp_register_style( 'nice-styles', get_stylesheet_uri() );
		wp_enqueue_style( 'nice-styles' );
	}

	/**
	 * Load Fancybox styles.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_fancybox_styles', true ) ) {
		wp_register_style( 'nice-fancybox-styles', get_template_directory_uri() . '/includes/assets/css/jquery.fancybox.css' );
		wp_enqueue_style( 'nice-fancybox-styles' );
	}

	/**
	 * Load FontAwesome.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_font_awesome_styles', true ) ) {
		// Load source.
		wp_register_style( 'nice-font-awesome-source', get_template_directory_uri() . '/includes/assets/css/font-awesome.min.css' );
		wp_enqueue_style( 'nice-font-awesome-source' );
	}

	/**
	 * Load Font Awesome for IE7.
	 *
	 * @uses WP_Styles::add_data()
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_font_awesome_ie7_styles', true ) ) {
		global $wp_styles;

		wp_enqueue_style( 'nice-font-awesome-ie7-styles', get_template_directory_uri() . '/includes/assets/css/font-awesome-ie7.min.css', array( 'nice-style' ) );
		$wp_styles->add_data( 'nice-font-awesome-ie7-styles', 'conditional', 'IE 7' );
	}

}
endif;

if ( ! function_exists( 'nice_admin_custom_css' ) ) :
add_action( 'admin_head', 'nice_admin_custom_css' );
/**
 * nice_admin_custom_css()
 *
 * print css in admin area
 *
 * @since 1.0.0
 *
 */
function nice_admin_custom_css() { ?>
	<style type="text/css" >
		.fixed .column-thumbnail{
			text-align: center;
			padding-top: 8px;
			padding-bottom: 8px;
			width: 80px;
		}
		td.column-thumbnail img{
			max-width: 80px;
			max-height: 80px;
		}
	</style>
<?php
}

endif;
