<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains functions to manage sidebars.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_sidebars_init' ) ) :
add_action( 'init', 'nice_sidebars_init' );

function nice_sidebars_init() {

	global $nice_options;

	if ( ! function_exists( 'register_sidebar' ) ) { return; }

	register_sidebar( array(
							'name'          => 'Primary',
							'id'            => 'primary',
							'description'   => __( 'Appears in the sidebar of the site\'s blog section.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>'
							)
					);

	register_sidebar(	array(
							'name'          => 'Page',
							'id'            => 'page',
							'description'   => __( 'Appears in the sidebar of the default page template.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>'
							)
					);

	register_sidebar( array(
							'name'          => 'Footer 1',
							'id'            => 'footer-1',
							'description'   => __( 'Appears in the footer section of the site, the first column.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>'
							)
					);

	register_sidebar( array(
							'name'          => 'Footer 2',
							'id'            => 'footer-2',
							'description'   => __( 'Appears in the footer section of the site, the second column.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>'
							)
					);
		register_sidebar( array(
							'name'          => 'office1-timming',
							'id'            => 'office1-timming',
							'description'   => __( 'Appears in the contact us page section of the site.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>'
							)
					);
			register_sidebar( array(
							'name'          => 'office2-timming',
							'id'            => 'office2-timming',
							'description'   => __( 'Appears in the contact us page section of the site.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>'
							)
					);
		register_sidebar( array(
							'name'          => 'office-timming-link',
							'id'            => 'office-timming-link',
							'description'   => __( 'Appears in the footer section of the site, the second column.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>'
							)
					);
		register_sidebar( array(
							'name'          => 'heading',
							'id'            => 'heading',
							'description'   => __( 'Appears in the footer section of the site, the second column.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle of-heading">',
							'after_title'   => '</h3>'
							)
					);

	$nice_footer_columns = ( ! empty( $nice_options['nice_footer_columns'] ) ) ? $nice_options['nice_footer_columns'] : '4';

	if ( $nice_footer_columns === '3' || $nice_footer_columns === '4' ) {

	register_sidebar( array(
							'name'          => 'Footer 3',
							'id'            => 'footer-3',
							'description'   => __( 'Appears in the footer section of the site, the third column.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>',
							)
					);

	}

	if ( $nice_footer_columns === '4' ) {

	register_sidebar( array(
							'name'          => 'Footer 4',
							'id'            => 'footer-4',
							'description'   => __( 'Appears in the footer section of the site, the fourth column.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>',
							)
					);

	}

	register_sidebar( array(
							'name'          => 'Home Sidebar',
							'id'            => 'home',
							'description'   => __( 'Appears in the home page template, beside the Feedback section.', 'nicethemes' ),
							'before_widget' => '<div class="box widget %2$s">',
							'after_widget'  => '</div>',
							'before_title'  => '<h3 class="widgettitle">',
							'after_title'   => '</h3>',
							)
					);

}

endif;