<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains functions to manage the theme's setup.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/product/paeon
 * @copyright 2021 NiceThemes
 * @since     1.2.2
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_setup_development_mode' ) ) :
add_filter( 'nice_development_mode', 'nice_setup_development_mode' );
/**
 * Setup development mode.
 *
 * @since 1.2.2
 */
function nice_setup_development_mode() {
	return nice_bool_option( '_development_mode' );
}
endif;

if ( ! function_exists( 'nice_theme_textdomain' ) ) :
add_filter( 'nice_theme_textdomain', 'nice_theme_textdomain' );
/**
 * Setup the theme textdomain.
 *
 * @since 1.2.2
 *
 * @return string
 */
function nice_theme_textdomain() {
	return 'nicethemes';
}
endif;

if ( ! function_exists( 'nice_theme_slug' ) ) :
add_filter( '_nice_theme_name', 'nice_theme_name' );
/**
 * Setup the theme name.
 *
 * @since 1.2.2
 *
 * @return string
 */
function nice_theme_name() {
	return 'Paeon';
}
endif;

if ( ! function_exists( 'nice_theme_slug' ) ) :
add_filter( '_nice_theme_slug', 'nice_theme_slug' );
/**
 * Setup the theme slug.
 *
 * @since 1.2.2
 *
 * @return string
 */
function nice_theme_slug() {
	return 'paeon';
}
endif;

if ( ! function_exists( 'nice_theme_admin_menu_label' ) ) :
add_filter( 'nice_admin_menu_label', 'nice_theme_admin_menu_label' );
add_filter( 'nice_admin_bar_menu_label', 'nice_theme_admin_menu_label' );
/**
 * Set the Admin Menu label
 *
 * @since 1.2.2
 *
 * @return string
 */
function nice_theme_admin_menu_label() {
	return esc_html__( 'Paeon', 'nicethemes' );
}
endif;

