<?php
/**
 * Paeon by NiceThemes.
 *
 * This file includes functions to manage scripts for the theme.
 *
 * @see nice_scripts()
 * @see nice_ie_head_scripts()
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2014-2015 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_scripts' ) ) :
add_action( 'nice_register_scripts', 'nice_scripts' );
/**
 * nice_scripts()
 *
 * register js scripts and enqueue them
 *
 * @since 1.0
 *
 * @uses wp_register_script, wp_enqueue_script
 *
 */
function nice_scripts() {
	global $nice_options;

	/**
	 * Register general scripts.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_general_scripts', true ) ) {
		wp_register_script( 'nice-general-scripts', get_template_directory_uri() . '/includes/assets/js/nice-general.js', array( 'jquery' ) );
		wp_enqueue_script( 'nice-general-scripts' );

		// Localize scripts.
		wp_localize_script( 'nice-general-scripts', 'generalData', array(
				'adminAjaxURL'  => admin_url() . 'admin-ajax.php',
				'playNiceNonce' => wp_create_nonce( 'play-nice' )
			)
		);
	}

	/**
	 * Register Fancybox scripts.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_fancybox_scripts', true ) ) {
		// Load Fancybox source.
		wp_register_script( 'nice-fancybox-source', get_template_directory_uri() . '/includes/assets/js/jquery.fancybox.js', array( 'jquery' ) );
		wp_enqueue_script( 'nice-fancybox-source' );

	}

	/**
	 * Register Superfish scripts.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_superfish_scripts', true ) ) {
		// Load Superfish library.
		wp_register_script( 'nice-superfish-source',  get_template_directory_uri() . '/includes/assets/js/superfish.min.js' , array( 'jquery' ) );
		wp_enqueue_script( 'nice-superfish-source' );
	}

	/**
	 * Register Masonry scripts.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_masonry_scripts', true ) ) {
		$version = version_compare( get_bloginfo( 'version' ), '3.5', '<' );

		if ( $version ) {
			wp_register_script( 'jquery-masonry', get_template_directory_uri() . '/includes/assets/js/jquery.masonry.min.js', array( 'jquery' ) );
		}
		wp_enqueue_script( 'jquery-masonry' );
	}

	/**
	 * Register QuickSand scripts.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_quicksand_scripts', true ) ) {
		wp_register_script( 'nice-quicksand', get_template_directory_uri() . '/includes/assets/js/jquery.quicksand.js', array( 'jquery' ) );
		wp_enqueue_script( 'nice-quicksand' );
	}

	/**
	 * Register Imagesloaded scripts.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_imagesloaded_scripts', true ) ) {
		wp_register_script( 'nice-imagesloaded', get_template_directory_uri() . '/includes/assets/js/imagesloaded.min.js', array( 'jquery' ) );
		wp_enqueue_script( 'nice-imagesloaded' );
	}

	/**
	 * Register Feedback scripts.
	 *
	 * @since 1.0.0
	 */
	if ( apply_filters( 'nice_load_feedback_js', false ) ) {
		wp_register_script( 'nice-slides', get_template_directory_uri() . '/includes/assets/js/slides.min.jquery.js', array( 'jquery' ) );
		wp_register_script( 'nice-feedback', get_template_directory_uri() . '/includes/assets/js/feedback.js', array( 'jquery', 'nice-slides' ) );
		wp_enqueue_script( 'nice-feedback' );
	}

	/**
	 * Load JavaScript for contact form conditionally (disabled by default).
	 *
	 * @since 1.0.0
	 */
	wp_register_script( 'nice-contact-validation', '//ajax.microsoft.com/ajax/jquery.validate/1.13.1/jquery.validate.min.js', array( 'jquery' ) );

	if ( apply_filters( 'nice_load_contact_js', false ) ) {
		wp_enqueue_script('nice-contact-validation');
		add_action( 'wp_head', 'nice_contact_js', 10 );
	}

	if ( is_active_widget( false, false, 'nice_appointments' ) ) {

			// the widget is active, load datepicker & contact validation
			wp_enqueue_script( 'nice-contact-validation' );
			wp_enqueue_script( 'jquery-ui-core' );
			wp_enqueue_script( 'jquery-ui-datepicker' );
			add_action( 'wp_head', 'nice_appointment_js', 10 );

	}

	/**
	 * Register Slides & Flexslider scripts.
	 *
	 * @since 1.0.0
	 */
	if ( is_page_template( 'template-home.php' ) || apply_filters( 'nice_load_flexslider_js', false ) ) {

		if ( $nice_options['nice_slider'] == 'true' || $load_flexslider_js || ( $nice_options['nice_staff_enable'] == 'true' )  ) {
			wp_register_script( 'flexslider', get_template_directory_uri() . '/includes/assets/js/jquery.flexslider-min.js', array( 'jquery' ) );
			wp_enqueue_script('flexslider');
			wp_register_script( 'froogaloop', '//player.vimeo.com/api/player.js', array( 'jquery' ) );
			wp_enqueue_script('froogaloop');

			if ( $nice_options['nice_slider'] == 'true' ) {
				add_action( 'wp_head', 'nice_flexslider_js', 10 );
			}
		}
	}

	/**
	 * Load JavaScript for "load more" functionality conditionally (disabled by default).
	 *
	 * @since 1.0.0
	 */

	if ( apply_filters( 'nice_load_more_posts_loader_js', false ) ) {

		add_action( 'wp_footer', 'nice_more_posts_loader_js', 10 );
	}

	do_action( 'nice_scripts_js' );

} // end nice_scripts_js
endif;

if ( ! function_exists( 'nice_contact_js' ) ) :
/**
 * nice_contact_js()
 *
 * print js for contact form
 *
 * @since 1.0.0
 *
 */
function nice_contact_js() {
	// being here we can set admin-ajax.php for WP multisite
	?>
	<script type="text/javascript">
	//<![CDATA[
	jQuery(document).ready(function($) {

		jQuery('#nice_contact').validate({

			messages: {
				"name": {"required":"<?php _e( 'Please enter your name.', 'nicethemes' ); ?>"},
				"mail": {"required":"<?php _e( 'Please enter your email address.', 'nicethemes' ); ?>"},
				"message": {"required":"<?php _e( 'Please enter a message.', 'nicethemes' ); ?>"}
			},

			submitHandler: function(form) {

				var str = jQuery('#nice_contact').serialize();

				jQuery.ajax({
					type: "POST",
					url: "<?php echo admin_url();?>admin-ajax.php",
					data: 'action=nice_contact_form&nonce=<?php echo wp_create_nonce("play-nice");?>&' + str,
					success: function(msg) {
						jQuery("#node").ajaxComplete( function(event, request, settings ) {
							if( msg == 'sent' ) {
								jQuery(".nice-contact-form #node").hide();
								jQuery(".nice-contact-form #success").fadeIn("slow");
								jQuery("#nice_contact input[type=text], #nice_contact textarea").val("");
							} else {
								result = msg;
								jQuery(".nice-contact-form #node").html(result);
								jQuery(".nice-contact-form #node").fadeIn("slow");
							}
							document.querySelector('#nice_contact').reset();
						});
					}
				});
				return false;
			}
		});
	});
	//]]>
	</script>
	<?php

}
endif;

if ( ! function_exists( 'nice_flexslider_js' ) ) :
/**
 * nice_flexslider_js()
 *
 * print js for contact form
 *
 * @since 1.0.1
 *
 */
function nice_flexslider_js() {

	global $nice_options;


	$fields = array(
		'nice_slider_animation'       => 'slide',
		'nice_slider_animation_loop'  => 'false',
		'nice_slider_direction'       => 'horizontal',
		'nice_slider_reverse'         => 'false',
		'nice_slider_pause_on_hover'  => 'false',
		'nice_slider_randomize'       => 'false',
		'nice_slider_animation_speed' => '600',
		'nice_slider_slideshow'       => 'true',
		'nice_slider_slideshow_speed' => '7000',
		'nice_slider_control_nav'     => 'true',
		'nice_slider_direction_nav'   => 'true'
		);

	foreach ( $fields as $k => $v ) {
		if ( is_array( $nice_options ) && isset( $nice_options[ $k ] ) && $nice_options[ $k ] != '' ) {
			${$k} = $nice_options[ $k ];
		}
	}

	extract( $fields, EXTR_SKIP );

	?>

	<script type='text/javascript'>
	//<![CDATA[

	jQuery( window ).load(function() {

		if ( jQuery( '.home-flexslider-wrapper .flexslide' ).length == 0 ) {
			jQuery( 'body' ).removeClass('has-slider-menu');
		}
		var vimeoPlayers = jQuery('.flexslider').find('iframe'),
		player;

		for ( var i = 0, length = vimeoPlayers.length; i < length; i++ ) {
			player = vimeoPlayers[i];
			$f(player).addEvent('ready', ready);
		}

		function addEvent(element, eventName, callback) {
			if (element.addEventListener) {
					element.addEventListener(eventName, callback, false)
				} else {
					element.attachEvent(eventName, callback, false);
			}
		}

		function ready(player_id) {
			var froogaloop = $f(player_id);
			froogaloop.addEvent('play', function(data) {
					jQuery('.flexslider').flexslider("pause");
				});
				froogaloop.addEvent('pause', function(data) {
						jQuery('.flexslider').flexslider("play");
				});
			}

			jQuery(".flexslider").flexslider({
					animation: "<?php echo $nice_slider_animation; ?>",
					direction: "<?php echo $nice_slider_direction; ?>",
					reverse: <?php echo $nice_slider_reverse; ?>,
					animationLoop: <?php echo $nice_slider_animation_loop; ?>,
					randomize:<?php echo $nice_slider_randomize; ?>,
					slideshow: <?php echo $nice_slider_slideshow; ?>,
					slideshowSpeed: <?php echo $nice_slider_slideshow_speed; ?>,
					animationSpeed: <?php echo $nice_slider_animation_speed; ?>,
					pauseOnHover: <?php echo $nice_slider_pause_on_hover; ?>,
					useCSS: false,
					smoothHeight: true,
					controlNav: <?php echo $nice_slider_control_nav; ?>,
					directionNav: <?php echo $nice_slider_direction_nav; ?>,
					start: function( slider ) {

						if ( jQuery('#featured.flexslider').length != 0 ) {

							var currentSlide = 0;
							if ( <?php echo $nice_slider_reverse; ?> == true && '<?php echo $nice_slider_animation; ?>' != 'fade' ) {
								jQuery( '.flexslider .slide' ).removeClass('flex-active-slide');
								jQuery( '.flexslider .slide:not(.clone)' ).last().addClass('flex-active-slide');
								jQuery( '.flexslider .flex-viewport' ).css( 'height' , jQuery( '.flex-active-slide' ).outerHeight() + 'px' );
								currentSlide = jQuery( '.flexslider .slide:not(.clone)' ).length - 1;
							}

							adjust_slide_height( currentSlide );
							adjust_wrapper_margin( currentSlide, 1800 );
						}
						jQuery( 'body.has-slider' ).removeClass('has-slider-menu');
					},
					before: function( slider ) {
							if ( slider.slides.eq(slider.currentSlide).find('iframe').length !== 0 )
									$f( slider.slides.eq(slider.currentSlide).find('iframe').attr('id') ).api('pause');
					},
					after: function( slider ) {
						if( jQuery('#featured.flexslider').length != 0 ){
							var currentSlide = slider.currentSlide;
							if ( <?php echo $nice_slider_reverse; ?> == true && '<?php echo $nice_slider_animation; ?>' != 'fade' ) {
								currentSlide = jQuery( '.flexslider .slide:not(.clone)' ).length - ( currentSlide + 1 );
								jQuery( '.flexslider .slide' ).removeClass('flex-active-slide');
								jQuery( '.flexslider .slide:not(.clone)' ).eq(currentSlide).addClass('flex-active-slide');
								setInterval(function(){
									jQuery( '.flexslider .flex-viewport' ).css( 'height' , jQuery( '.flex-active-slide' ).outerHeight() + 'px' );
								},100)
							} else {
								adjust_slide_height( currentSlide );
							}

							adjust_wrapper_margin( currentSlide );
						}
					}
				});

				if( jQuery('#featured.flexslider').length != 0 ){
					jQuery(window).resize(function() {
						var $slides = jQuery('#featured.flexslider .slide:not(.clone)');
						var $currentSlide = $slides.index( jQuery(".flex-active-slide") );
						adjust_slide_height( $currentSlide );
						adjust_wrapper_margin( $currentSlide );
					});
				}
	});

	//]]>
	</script>

	<?php
}

endif;

if ( ! function_exists( 'nice_appointment_js' ) ) :
/**
 * nice_appointment_js()
 *
 * print js for the appointment form
 *
 * @since 1.0.0
 *
 */

function nice_appointment_js() {
	// being here we can set admin-ajax.php for WP multisite
	?>
	<script type="text/javascript">
	//<![CDATA[
	jQuery(document).ready( function($) {

		if ( jQuery().datepicker ) {
			jQuery( '.datepicker' ).datepicker();
		}

		if ( jQuery('#nice_appointment #appo_date').length > 0) {
			// the date field is here
		}

		jQuery('#nice_appointment').validate({

			messages: {
				"name"   : { "required" : "<?php _e( 'Please enter your name.', 'nicethemes' ); ?>"},
				"phone"  : { "required" : "<?php _e( 'Please enter your phone number.', 'nicethemes' ); ?>"},
				"mail"   : { "required" : "<?php _e( 'Please enter your email address.', 'nicethemes' ); ?>"},
				"message": { "required" : "<?php _e( 'Please enter a message.', 'nicethemes' ); ?>"},
				"date"   : { "required" : "<?php _e( 'Please enter the appointment date.', 'nicethemes' ); ?>"}
			},

			submitHandler: function(form) {

				var str = jQuery('#nice_appointment').serialize();

				jQuery.ajax({
					type    : "POST",
					url     : "<?php echo admin_url();?>admin-ajax.php",
					data    : 'action=nice_appointment_form&nonce=<?php echo wp_create_nonce("play-nice"); ?>&' + str,
					success : function(msg) {

						jQuery("#node").ajaxComplete( function(event, request, settings) {
							if ( msg == 'sent' ) {
								jQuery("#nice_appointment #node").hide();
								jQuery("#nice_appointment #success").fadeIn("slow");
								jQuery('#nice_appointment').each(function(){
									this.reset();
								});
							} else {
								result = msg;
								jQuery("#nice_appointment #node").html(result);
								jQuery("#nice_appointment #node").fadeIn("slow");
							}
							document.querySelector('#nice_appointment').reset();
						});
					}

				});
				return false;
			}
		});
	});
	//]]>
	</script>
	<?php

}

endif;

if ( ! function_exists( 'nice_more_posts_loader_js' ) ) :
/**
 * nice_more_posts_loader_js()
 *
 * print js for masonry blog more posts loader
 *
 * @since 1.0.0
 *
 */
function nice_more_posts_loader_js() { ?>

<script type="text/javascript">
	/* <![CDATA[ */

	jQuery(document).ready( function($) {

		/* masonry script */
		var $masonry_container = jQuery('#masonry-grid');
		var $masonry_item_width = jQuery('.blog-masonry .three-col-grid li').outerWidth();
		var $masonry_item_margin = jQuery('.blog-masonry .three-col-grid li.first').css('marginRight');

		// initialize Masonry after all images have loaded
		$masonry_container.imagesLoaded( function() {
			$masonry_container.masonry( {
						columnWidth: $masonry_item_width,
						itemSelector: '.blog-masonry li.masonry-item',
						gutterWidth: parseInt( $masonry_item_margin ),
						isResizable: true
			});

		});

		jQuery(window).resize(function(){
			var $masonry_item_cur_width = jQuery('.blog-masonry .three-col-grid li').outerWidth();
			$masonry_item_margin = jQuery('.blog-masonry .three-col-grid li.first').css('marginRight');
				$masonry_container.masonry( 'option', {
					columnWidth: $masonry_item_cur_width,
					gutterWidth: parseInt( $masonry_item_margin )
				});
				jQuery($masonry_container).masonry( 'reload' );
		});

		var page = 1;
		var loading = false;
		var $window = jQuery(window);
		var $content = jQuery("#masonry-grid");
		var load_posts = function(){
		jQuery.ajax({
				type: "POST",
				url: "<?php echo admin_url();?>admin-ajax.php",
				data: 'action=nice_more_posts_loader&nonce=<?php echo wp_create_nonce( 'play-nice' );?>&pageNumber=' + page,
					beforeSend : function(){
						if(page != 1){
							jQuery("#posts_ajax_loader").show();
						}
					},
					success    : function(data){
						$data = jQuery(data);
						if( ! $data.hasClass( 'no-more-posts' ) ){
							$data.hide();

							jQuery($masonry_container).append($data).imagesLoaded( function() {
								$masonry_container.masonry( 'appended', $data );

								var $masonry_item_cur_width = jQuery('.blog-masonry .masonry-item').outerWidth();
								$masonry_item_margin = jQuery('.blog-masonry .first').css('marginRight');
								$masonry_container.masonry( 'option', {
									columnWidth: $masonry_item_cur_width,
									gutterWidth: parseInt( $masonry_item_margin )
								});
								jQuery($masonry_container).masonry('reload');


								$data.fadeIn();
								jQuery("#posts_ajax_loader").hide();
								loading = false;
							});
						} else {
							console.log('no tiene mas');
							jQuery("#posts_ajax_loader").hide();
							jQuery("#content").append(data);
						}

					},
					error     : function(jqXHR, textStatus, errorThrown) {
						jQuery("#posts_ajax_loader").hide();
						console.log(jqXHR + " :: " + textStatus + " :: " + errorThrown);
					}
			});
		}

		$window.scroll(function() {
			var content_offset = $content.offset();
			if ( ! loading && ( $window.scrollTop() + $window.height() ) > ($content.scrollTop() + $content.height() + content_offset.top)) {
					loading = true;
					page++;
					load_posts();
			}
		});

		jQuery($masonry_container).masonry();

	});
	/* ]]> */
</script>
<?php
}
endif;

if ( ! function_exists( 'nice_ie_head_scripts' ) ) :
add_action( 'wp_head', 'nice_ie_head_scripts' );
/**
 * Add IE conditionals to header.
 *
 * @since 1.0.0
 */
function nice_ie_head_scripts() {
	global $is_IE;

	if ( $is_IE ) {
		echo '<!--[if lt IE 9]>' . "\n";
		echo '<script src="' . get_template_directory_uri() . '/includes/assets/js/html5.js" type="text/javascript"></script>' . "\n";
		echo '<script src="' . get_template_directory_uri() . '/includes/assets/js/respond-IE.js" type="text/javascript"></script>' . "\n";
		echo '<![endif]-->' . "\n";
	}
}

endif;