<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains functions to implement theme options.
 *
 * @see nice_options()
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon/
 * @copyright 2014-2015 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


if ( ! function_exists( 'nice_options_global' ) ) :
add_action( 'init', 'nice_options_global' );
/**
 * make options global.
 *
 * @since 1.0.0
 */
function nice_options_global() {
	global $nice_options;
	$nice_options = get_option( 'nice_options' );
}
endif;

if ( ! isset( $content_width ) ) {
	$content_width = 620;
}


if ( ! function_exists( 'nice_options' ) ) :
add_action( 'admin_head', 'nice_options' );
/**
 * Set up theme options.
 *
 * @since 1.0.0
 */

function nice_options() {

	$prefix = NICE_PREFIX;

	$nice_options 	= array ();

	/* General Settings */
	$nice_options[] = array(
		'name' => __( 'General Settings', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_music-eq-a"></i>'
	);

	$nice_options[] = array(
		'name' => __( 'Favicon', 'nicethemes' ),
		'desc' => __( 'Upload a favicon.', 'nicethemes' ),
		'id'   => $prefix . '_favicon',
		'std'  => '',
		'type' => 'upload'
	);

	$nice_options[] = array(
		'name' => __( 'Sidebar Position', 'nicethemes' ),
		'desc' => __( 'Select if you want to show the full content or the excerpt on posts.', 'nicethemes' ),
		'id'   => $prefix . '_sidebar_position',
		'type' => 'select',
		'std'  => 'right',
		'tip'  => '',
		'options' 	=> array( 'right' => __( 'Sidebar on right side', 'nicethemes' ),
							  'left'  => __( 'Sidebar on left side', 'nicethemes' )
						)
	);

	$nice_options[] = array(
		'name' => __( 'Post Author Box', 'nicethemes' ),
		'desc' => __( 'This will enable the post author box on the single posts page. Edit description in Users > Your Profile.', 'nicethemes' ),
		'id'   => $prefix . '_post_author',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Display Back To Top Button', 'nicethemes' ),
		'desc' => __( 'Enable if you want the Back To Top button to be displayed in the bottom right corner of the site.', 'nicethemes' ),
		'id'   => $prefix . '_back_to_top',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Call Now Text', 'nicethemes' ),
		'desc' => __( 'The Call Now text that will appear beside the phone number', 'nicethemes' ),
		'id'   => $prefix . '_call_now_text',
		'std'  => __( 'Call Now', 'nicethemes' ),
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Tracking Code', 'nicethemes' ),
		'desc' => __( 'Insert the code if you have one. Google analytics, etc.', 'nicethemes' ),
		'id'   => $prefix . '_tracking_code',
		'std'  => '',
		'tip'  => '',
		'type' => 'textarea'
	);

	/* Styles */
	$nice_options[] = array(
		'name' => __( 'Design & Styles', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_setting-wrench"></i>',
	);


	$nice_options[] = array(
		'name' => __( 'Accent Color', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_accent_color',
		'std'  => '#3e7ec2',
		'tip'  => '',
		'type' => 'color'
	);

	$nice_options[] = array(
		'name' => __( 'Secondary Color', 'nicethemes' ),
		'desc' => __( 'The background color for the buttons, telephone number, etc.', 'nicethemes' ),
		'id'   => $prefix . '_secondary_color',
		'std'  => '#a2d678',
		'tip'  => '',
		'type' => 'color'
	);

	$nice_options[] = array(
		'name' => __( 'Custom CSS', 'nicethemes' ),
		'desc' => __( 'Quickly add some CSS to your theme by adding it to this block.', 'nicethemes' ),
		'id'   => $prefix . '_custom_css',
		'std'  => '',
		'tip'  => '',
		'type' => 'textarea'
	);

	/* Header Settings */
	$nice_options[] = array(
		'name' => __( 'Header', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_layout-header"></i>'
	);

	$nice_options[] = array(
		'name' => __( 'Custom Logo', 'nicethemes' ),
		'desc' => __( 'Upload a custom logo.', 'nicethemes' ),
		'id'   => $prefix . '_logo',
		'std'  => '',
		'type' => 'upload'
	);

	$nice_options[] = array(
		'name' => __( 'Custom Logo (Retina)', 'nicethemes' ),
		'desc' => __( 'Upload a custom logo for retina displays. Upload at exactly 2x the size of your standard logo.', 'nicethemes' ),
		'id'   => $prefix . '_logo_retina',
		'std'  => '',
		'type' => 'upload'
	);

	$nice_options[] = array(
		'name' => __( 'Logo Height', 'nicethemes' ),
		'desc' => __( 'Change the logo height. This setting will standarize the logo height for retina devices.', 'nicethemes' ),
		'id'   => $prefix . '_logo_height',
		'std'  => array( 'range' => 'min', 'value' => '70', 'min' => '10', 'max' => '400', 'unit' => 'px' ),
		'type' => 'slider'
	);

	$nice_options[] = array(
		'name' => __( 'Header background Color', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_header_background_color',
		'std'  => '#528bcb',
		'tip'  => '',
		'type' => 'color'
	);

	$nice_options[] = array(
		'name' => __( 'Header background Image', 'nicethemes' ),
		'desc' => __( 'Upload or choose the header background image.', 'nicethemes' ),
		'id'   => $prefix . '_header_background_image',
		'std'  => '',
		'type' => 'upload'
	);

	$nice_options[] = array(
		'name' => __( 'Header background image repeat', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . "_header_background_image_repeat",
		'std'  => 'repeat',
		'type' => 'select',
		'tip'  => '',
		'options'	=> array(
								'no-repeat' => __( 'No Repeat', 'nicethemes' ),
								'repeat'    => __( 'Repeat', 'nicethemes' ),
								'repeat-x'  => __( 'Repeat horizontally', 'nicethemes' ),
								'repeat-y'  => __( 'Repeat vertically', 'nicethemes' )
								)
	);

	$nice_options[] = array(
		'name' => __( 'Header background image position', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_header_background_image_position',
		'std'  => 'left top',
		'type' => 'select',
		'tip'  => '',
		'options' 	=> array(
							'center top'    => __( 'Center Top', 'nicethemes' ),
							'center center' => __( 'Center Center', 'nicethemes' ),
							'center bottom' => __( 'Center Bottom', 'nicethemes' ),
							'left top'      => __( 'Left Top', 'nicethemes' ),
							'left center'   => __( 'Left Center', 'nicethemes' ),
							'left bottom'   => __( 'Left Bottom', 'nicethemes' ),
							'right top'     => __( 'Right Top', 'nicethemes' ),
							'right center'  => __( 'Right Center', 'nicethemes' ),
							'right bottom'  => __( 'Right Bottom', 'nicethemes' )
						)
	);

	$nice_options[] = array(
		'name' => __( 'Text Title', 'nicethemes' ),
		'desc' => __( 'Enable if you want Blog Title and Tagline to be text-based. Setup title/tagline in WP -> Settings -> General.', 'nicethemes' ),
		'id'   => $prefix . '_texttitle',
		'std'  => 'false',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Site Title Typography', 'nicethemes' ),
		'desc' => __( 'Change the site title typography. ( Only if Text Title is enabled )', 'nicethemes' ),
		'id'   => $prefix . '_font_site_title',
		'std'  => array( 'size' => '30', 'family' => 'Raleway', 'style' => '','color' => '#fff'),
		'type' => 'typography'
	);

	$nice_options[] = array(
		'name' => __( 'Footer', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_layout-footer"></i>'
	);

	$nice_options[] = array(
		'name' => __( 'Enable Custom Copyright', 'nicethemes' ),
		'desc' => __( 'Enable if you want to write your own copyright text.', 'nicethemes' ),
		'id'   => $prefix . '_custom_copyright_enable',
		'std'  => 'false',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Custom Copyright Text', 'nicethemes' ),
		'desc' => __( 'Please enter the copyright section text. e.g. All Rights Reserved, Nice Themes.', 'nicethemes' ),
		'id'   => $prefix . '_custom_copyright_text',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Footer Columns', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_footer_columns',
		'std'  => array( 'range' => 'min', 'value' => '3', 'min' => '2', 'max' => '4' ),
		'type' => 'slider'
	);


	/* Typography */
	$nice_options[] = array(
		'name' => __( 'Typography', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_editorial-pen"></i>',
	);

	$nice_options[] = array(
		'name' => __( 'Enable Custom Typography', 'nicethemes' ),
		'desc' => __( 'Enable if you want to pick your fonts.', 'nicethemes' ),
		'id'   => $prefix . '_custom_typography',
		'std'  => 'false',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'General Typography', 'nicethemes' ) ,
		'desc' => __( 'Change the general font.', 'nicethemes' ) ,
		'id'   => $prefix . '_font_body',
		'std'  => array( 'size' => '13', 'unit' => 'px', 'family' => 'Raleway', 'style' => '', 'color' => '#757B83' ),
		'type' => 'typography'
	);

	$nice_options[] = array(
		'name' => __( 'Navigation', 'nicethemes' ) ,
		'desc' => __( 'Change the navigation font.', 'nicethemes' ),
		'id'   => $prefix . '_font_nav',
		'std'  => array( 'size' => '13', 'unit' => 'px', 'family' => 'Raleway', 'style' => '', 'color' => '#ffffff' ),
		'type' => 'typography'
	);

	$nice_options[] = array(
		'name' => __( 'Post Title', 'nicethemes' ) ,
		'desc' => __( 'Change the post title.', 'nicethemes' ) ,
		'id'   => $prefix . '_font_post_title',
		'std'  => array( 'size' => '30', 'unit' => 'px', 'family' => 'Raleway', 'style' => '', 'color' => '#43484D' ),
		'type' => 'typography'
	);

	$nice_options[] = array(
		'name' => __( 'Post Meta', 'nicethemes' ),
		'desc' => __( 'Change the post meta.', 'nicethemes' ) ,
		'id'   => $prefix . '_font_post_meta',
		'std'  => array( 'size' => '13', 'unit' => 'px', 'family' => 'Raleway', 'style' => '', 'color' => '#BBBBBB' ),
		'type' => 'typography'
	);

	$nice_options[] = array(
		'name' => __( 'Post Entry', 'nicethemes' ) ,
		'desc' => __( 'Change the post entry.', 'nicethemes' ) ,
		'id'   => $prefix . '_font_post_entry',
		'std'  => array( 'size' => '14', 'unit' => 'px', 'family' => 'Raleway', 'style' => '', 'color' => '#757B83' ),
		'type' => 'typography'
	);

	$nice_options[] = array(
		'name' => __( 'Welcome Message', 'nicethemes' ) ,
		'desc' => __( 'Change the welcome message font.', 'nicethemes' ) ,
		'id'   => $prefix . "_font_welcome_message",
		'std'  => array( 'size' => '38', 'unit' => 'px', 'family' => 'Raleway', 'style' => '', 'color' => '#43484D' ),
		'type' => 'typography'
	);

	$nice_options[] = array(
		'name' => __( 'Welcome Message (extended)', 'nicethemes' ) ,
		'desc' => __( 'Change the extended welcome message font.', 'nicethemes' ) ,
		'id'   => $prefix . "_font_welcome_message_extended",
		'std'  => array( 'size' => '14', 'unit' => 'px', 'family' => 'Raleway', 'style' => '', 'color' => '#757B83' ),
		'type' => 'typography'
	);

	$nice_options[] = array(
		'name' => __( 'Slider Title', 'nicethemes' ) ,
		'desc' => __( 'Change the post title.', 'nicethemes' ) ,
		'id'   => $prefix . '_font_slider_title',
		'std'  => array( 'size' => '38', 'unit' => 'px', 'family' => 'Raleway', 'style' => '', 'color' => '#FFFFFF' ),
		'type' => 'typography'
	);

	$nice_options[] = array( 'name' => __( 'Slider Content', 'nicethemes' ) ,
		'desc' => __( 'Change the slider content.', 'nicethemes' ) ,
		'id'   => $prefix . '_font_slider_content',
		'std'  => array( 'size' => '17', 'unit' => 'px', 'family' => 'Raleway', 'style' => '', 'color' => '#FFFFFF' ),
		'type' => 'typography'
	);

	/* Home Options */

	$nice_options[] = array(
		'name' => __( 'Home Options', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_interface-home-a"></i>',
	);

	$nice_options[] = array(
		'name' => __( 'Enable Social Links', 'nicethemes' ),
		'desc' => __( 'This will enable the social links section on your home page.', 'nicethemes' ),
		'id'   => $prefix . '_social_enable',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Welcome Message', 'nicethemes' ),
		'desc' => __( 'Insert your Welcome Message.', 'nicethemes' ),
		'id'   => $prefix . '_welcome_message',
		'std'  => '',
		'tip'  => '',
		'type' => 'textarea'
	);

	$nice_options[] = array(
		'name' => __( 'Welcome Message (extended)', 'nicethemes' ),
		'desc' => __( 'Insert your extended Welcome Message.', 'nicethemes' ),
		'id'   => $prefix . '_welcome_message_extended',
		'std'  => '',
		'tip'  => '',
		'type' => 'textarea'
	);

	$nice_options[] = array(
		'name' => __( 'Enable Staff', 'nicethemes' ),
		'desc' => __( 'This will enable the staff items to be shown in the home page.', 'nicethemes' ),
		'id'   => $prefix . '_staff_enable',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Staff Title', 'nicethemes' ),
		'desc' => __( 'Insert a title for the staff section in the home page. Leave it blank if you don\'t want one.', 'nicethemes' ),
		'id'   => $prefix . '_staff_title',
		'std'  => __( 'Our Professionals', 'nicethemes' ),
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Staff Order', 'nicethemes' ),
		'desc' => __( 'Select the view order you wish to set for the staff items on the home page.', 'nicethemes' ),
		'id'   => $prefix . '_staff_order',
		'std'  => 'date',
		'type' => 'select',
		'tip'  => '',
		'options' => array(
								'date'       => __( 'Date',       'nicethemes' ),
								'menu_order' => __( 'Page Order', 'nicethemes' ),
								'title'      => __( 'Title',      'nicethemes' ),
								'rand'       => __( 'Random',     'nicethemes' )
							)
	);

	$nice_options[] = array(
		'name' => __( 'Staff Button Text', 'nicethemes' ),
		'desc' => __( 'Insert a text for the staff button in the home page. Leave it blank if you don\'t want one.', 'nicethemes' ),
		'id'   => $prefix . '_staff_button_text',
		'std'  => __( 'Meet Our Professionals', 'nicethemes' ),
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Staff Button URL', 'nicethemes' ),
		'desc' => __( 'Insert an URL for the staff button in the home page. Leave it blank if you don\'t want one.', 'nicethemes' ),
		'id'   => $prefix . '_staff_button_url',
		'std'  => site_url() . '/our-staff',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Enable Services', 'nicethemes' ),
		'desc' => __( 'This will enable the services items to be shown in the home page.', 'nicethemes' ),
		'id'   => $prefix . '_service_enable',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Services Title', 'nicethemes' ),
		'desc' => __( 'Insert a title for the services section in the home page. Leave it blank if you don\'t want one.', 'nicethemes' ),
		'id'   => $prefix . '_service_title',
		'std'  => __( 'Our Services', 'nicethemes' ),
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Services Order', 'nicethemes' ),
		'desc' => __( 'Select the view order you wish to set for the services items on the home page.', 'nicethemes' ),
		'id'   => $prefix . '_service_order',
		'std'  => 'date',
		'type' => 'select',
		'tip'  => '',
		'options' => array(
								'date'			=> __( 'Date', 'nicethemes' ),
								'menu_order'	=> __( 'Page Order', 'nicethemes' ),
								'title'			=> __( 'Title', 'nicethemes' ),
								'rand'			=> __( 'Random', 'nicethemes' )
							 )
	);

	$nice_options[] = array(
		'name' => __( 'Enable Testimonials', 'nicethemes' ),
		'desc' => __( 'This will enable the testimonials items to be shown in the home page.', 'nicethemes' ),
		'id'   => $prefix . '_testimonial_enable',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Testimonials Title', 'nicethemes' ),
		'desc' => __( 'Insert a title for the testimonials section in the home page. Leave it blank if you don\'t want one.', 'nicethemes' ),
		'id'   => $prefix . '_testimonial_title',
		'std'  => __( 'What our patients are saying', 'nicethemes' ),
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Testimonials Order', 'nicethemes' ),
		'desc' => __( 'Select the view order you wish to set for the testimonials items on the home page.', 'nicethemes' ),
		'id'   => $prefix . '_testimonial_order',
		'std'  => 'date',
		'type' => 'select',
		'tip'  => '',
		'options' 	=> array(
								'date'       => __( 'Date',       'nicethemes' ),
								'menu_order' => __( 'Page Order', 'nicethemes' ),
								'title'      => __( 'Title',      'nicethemes' ),
								'rand'       => __( 'Random',     'nicethemes' )
							 )
	);

	$nice_options[] = array(
		'name' => __( 'Testimonial\'s Button Text', 'nicethemes' ),
		'desc' => __( 'Insert a text for the testimonials button in the home page. Leave it blank if you don\'t want one.', 'nicethemes' ),
		'id'   => $prefix . '_testimonial_button_text',
		'std'  => __( 'Read more testimonials', 'nicethemes' ),
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Testimonials Button URL', 'nicethemes' ),
		'desc' => __( 'Insert an URL for the testimonials button in the home page. Leave it blank if you don\'t want one.', 'nicethemes' ),
		'id'   => $prefix . '_testimonial_button_url',
		'std'  => site_url() . '/feedback',
		'tip'  => '',
		'type' => 'text'
	);

	/* Home Slider */

	$nice_options[] = array(
		'name' => __( 'Slider Options', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_doc-photo-stack"></i>',
	);

	$nice_options[] = array(
		'name' => __( 'Enable Slider', 'nicethemes' ),
		'desc' => __( 'Enable the slider on the homepage.', 'nicethemes' ),
		'id'   => $prefix . '_slider',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Slider Entries', 'nicethemes' ),
		'desc' => __( 'Select the number of entries that should appear in the home page slider.', 'nicethemes' ),
		'id'   => $prefix . '_slider_entries',
		'std'  => '3',
		'type' => 'select',
		'tip'  => '',
		'options' 	=> array(	0 => __( 'Select the number from this list', 'nicethemes' ), 1 => 1, 2 => 2, 3 => 3,
								4 => 4, 5 => 5, 6 => 6, 7 => 7,
								8 => 8, 9 =>9, 10 => 10, 11 => 11,
								12 => 12, 13 => 13, 14 => 14, 15 => 15,
								16 => 16, 17 => 17, 18 => 18, 19 => 19
							)
	);

	$nice_options[] = array( 'name' => __( 'Effect', 'nicethemes' ),
		'desc' => __( 'Select the animation effect.', 'nicethemes' ),
		'id'   => $prefix . '_slider_animation',
		'type' => 'select',
		'std'  => 'fade',
		'tip'  => '',
		'options' 	=> array(
							'slide' => __( 'Slide', 'nicethemes' ),
							'fade'  => __( 'Fade',  'nicethemes' )
							)
	);

	$nice_options[] = array(
		'name' => __( 'Reverse Order', 'nicethemes' ),
		'desc' => __( 'Reverse the animation direction.', 'nicethemes' ),
		'id'   => $prefix . '_slider_reverse',
		'std'  => 'false',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Hover Pause', 'nicethemes' ),
		'desc' => __( 'Hovering over slideshow will pause it.', 'nicethemes' ),
		'id'   => $prefix . '_slider_pause_on_hover',
		'std'  => 'false',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Randomize', 'nicethemes' ),
		'desc' => __( 'Select to randomize slides.', 'nicethemes' ),
		'id'   => $prefix . '_slider_randomize',
		'std'  => 'false',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Animation loop', 'nicethemes' ),
		'desc' => __( 'Should the animation loop?', 'nicethemes' ),
		'id'   => $prefix . '_slider_animation_loop',
		'std'  => 'false',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Animation Speed', 'nicethemes' ),
		'desc' => __( 'The time in <b>miliseconds</b> the animation between frames will take.', 'nicethemes' ),
		'id'   => $prefix . '_slider_animation_speed',
		'std'  => '600',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Auto Start', 'nicethemes' ),
		'desc' => __( 'Set the slider to start sliding automatically.', 'nicethemes' ),
		'id'   => $prefix . '_slider_slideshow',
		'std'  => 'false',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Auto Slide Interval', 'nicethemes' ),
		'desc' => __( 'The time in <b>milliseconds</b> each slide pauses for, before sliding to the next.', 'nicethemes' ),
		'id'   => $prefix . '_slider_slideshow_speed',
		'std'  => '7000',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Enable Slider Pagination Bar', 'nicethemes' ),
		'desc' => __( 'Check this option to enable the pagination bar.', 'nicethemes' ),
		'id'   => $prefix . '_slider_control_nav',
		'std'  => 'false',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Previous/Next Navigation', 'nicethemes' ),
		'desc' => __( 'Check this option to enable navigation for previous/next.', 'nicethemes' ),
		'id'   => $prefix . '_slider_direction_nav',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'Display Caption', 'nicethemes' ),
		'desc' => __( 'Check this option to display the caption and content for each slide.', 'nicethemes' ),
		'id'   => $prefix . '_slider_caption',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);


	/* Contact information */
	$nice_options[] = array(
		'name' => __( 'Contact Information', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_com-email"></i>',
	);

	$nice_options[] = array(
		'name' => __( 'Contact Form Email Address', 'nicethemes' ),
		'desc' => __( 'Enter the email address where you\'d like to receive emails from the contact form, or leave blank to use admin email.', 'nicethemes' ),
		'id'   => $prefix . '_email',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Contact Address', 'nicethemes' ),
		'desc' => __( 'The physical address for the contact template.', 'nicethemes' ),
		'id'   => $prefix . '_address',
		'std'  => '',
		'tip'  => '',
		'type' => 'textarea'
	);

	$nice_options[] = array(
		'name' => __( 'Google Maps Embed Code', 'nicethemes' ),
		'desc' => __( 'Insert the Google Map embed code for the contact template.', 'nicethemes' ),
		'id'   => $prefix . '_google_map',
		'std'  => '',
		'tip'  => '',
		'type' => 'textarea'
	);

	/* Business information */
	$nice_options[] = array(
		'name' => __( 'Business Setup', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_ecommerce-market"></i>',
	);

	$nice_options[] = array(
		'name' => __( 'Phone Number', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_phone_number',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Hours Format', 'nicethemes' ),
		'desc' => __( 'The format in which the business hours will be displayed. Default is \'h:i A\'. To customise this field you must understand php\'s <a href="http://php.net/manual/en/function.date.php" target="_blank">date() formatting</a>.', 'nicethemes' ),
		'id'   => $prefix . '_hours_format',
		'std'  => 'h:i A',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Monday Business Hours', 'nicethemes' ),
		'desc' => __( 'Use <strong>CTRL+Click (Windows)</strong> or <strong>CMD+Click (Mac)</strong> to select the times for which your business is open on a Monday.', 'nicethemes' ),
		'id'   => $prefix . '_monday_hours',
		'std'  => '0',
		'tip'  => '',
		'type' => 'select_multiple',
		'options' 	=> array( 0 => __( 'Closed', 'nicethemes') , '01:00' => '01:00', '01:30' => '01:30',
							'02:00' => '02:00', '02:30' => '02:30', '03:00' => '03:00', '03:30' => '03:30', '04:00' => '04:00', '04:30' => '04:30',
							'05:00' => '05:00', '05:30' => '05:30', '06:00' => '06:00', '06:30' => '06:30', '07:00' => '07:00', '07:30' => '07:30',
							'08:00' => '08:00', '08:30' => '08:30', '09:00' => '09:00', '09:30' => '09:30', '10:00' => '10:00', '10:30' => '10:30',
							'11:00' => '11:00', '11:30' => '11:30', '12:00' => '12:00', '12:30' => '12:30', '13:00' => '13:00', '13:30' => '13:30',
							'14:00' => '14:00', '14:30' => '14:30', '15:00' => '15:00', '15:30' => '15:30', '16:00' => '16:00', '16:30' => '16:30',
							'17:00' => '17:00', '17:30' => '17:30', '18:00' => '18:00', '18:30' => '18:30', '19:00' => '19:00', '19:30' => '19:30',
							'20:00' => '20:00', '20:30' => '20:30', '21:00' => '21:00', '21:30' => '21:30', '22:00' => '22:00', '22:30' => '22:30',
							'23:00' => '23:00', '23:30' => '23:30', '24:00' => '24:00', '24:30' => '24:30' )
	);

	$nice_options[] = array(
		'name' => __( 'Tuesday Business Hours', 'nicethemes' ),
		'desc' => __( 'Use <strong>CTRL+Click (Windows)</strong> or <strong>CMD+Click (Mac)</strong> to select the times for which your business is open on a Tuesday.', 'nicethemes' ),
		'id'   => $prefix . '_tuesday_hours',
		'std'  => '0',
		'tip'  => '',
		'type' => 'select_multiple',
		'options' 	=> array( 0 => __( 'Closed', 'nicethemes') , '01:00' => '01:00', '01:30' => '01:30',
							'02:00' => '02:00', '02:30' => '02:30', '03:00' => '03:00', '03:30' => '03:30', '04:00' => '04:00', '04:30' => '04:30',
							'05:00' => '05:00', '05:30' => '05:30', '06:00' => '06:00', '06:30' => '06:30', '07:00' => '07:00', '07:30' => '07:30',
							'08:00' => '08:00', '08:30' => '08:30', '09:00' => '09:00', '09:30' => '09:30', '10:00' => '10:00', '10:30' => '10:30',
							'11:00' => '11:00', '11:30' => '11:30', '12:00' => '12:00', '12:30' => '12:30', '13:00' => '13:00', '13:30' => '13:30',
							'14:00' => '14:00', '14:30' => '14:30', '15:00' => '15:00', '15:30' => '15:30', '16:00' => '16:00', '16:30' => '16:30',
							'17:00' => '17:00', '17:30' => '17:30', '18:00' => '18:00', '18:30' => '18:30', '19:00' => '19:00', '19:30' => '19:30',
							'20:00' => '20:00', '20:30' => '20:30', '21:00' => '21:00', '21:30' => '21:30', '22:00' => '22:00', '22:30' => '22:30',
							'23:00' => '23:00', '23:30' => '23:30', '24:00' => '24:00', '24:30' => '24:30' )
	);

	$nice_options[] = array(
		'name' => __( 'Wednesday Business Hours', 'nicethemes' ),
		'desc' => __( 'Use <strong>CTRL+Click (Windows)</strong> or <strong>CMD+Click (Mac)</strong> to select the times for which your business is open on a Wednesday.', 'nicethemes' ),
		'id'   => $prefix . '_wednesday_hours',
		'std'  => '0',
		'tip'  => '',
		'type' => 'select_multiple',
		'options'	=> array( 0 => __( 'Closed', 'nicethemes') , '01:00' => '01:00', '01:30' => '01:30',
							'02:00' => '02:00', '02:30' => '02:30', '03:00' => '03:00', '03:30' => '03:30', '04:00' => '04:00', '04:30' => '04:30',
							'05:00' => '05:00', '05:30' => '05:30', '06:00' => '06:00', '06:30' => '06:30', '07:00' => '07:00', '07:30' => '07:30',
							'08:00' => '08:00', '08:30' => '08:30', '09:00' => '09:00', '09:30' => '09:30', '10:00' => '10:00', '10:30' => '10:30',
							'11:00' => '11:00', '11:30' => '11:30', '12:00' => '12:00', '12:30' => '12:30', '13:00' => '13:00', '13:30' => '13:30',
							'14:00' => '14:00', '14:30' => '14:30', '15:00' => '15:00', '15:30' => '15:30', '16:00' => '16:00', '16:30' => '16:30',
							'17:00' => '17:00', '17:30' => '17:30', '18:00' => '18:00', '18:30' => '18:30', '19:00' => '19:00', '19:30' => '19:30',
							'20:00' => '20:00', '20:30' => '20:30', '21:00' => '21:00', '21:30' => '21:30', '22:00' => '22:00', '22:30' => '22:30',
							'23:00' => '23:00', '23:30' => '23:30', '24:00' => '24:00', '24:30' => '24:30' )
	);

	$nice_options[] = array(
		'name' => __( 'Thursday Business Hours', 'nicethemes' ),
		'desc' => __( 'Use <strong>CTRL+Click (Windows)</strong> or <strong>CMD+Click (Mac)</strong> to select the times for which your business is open on a Thursday.', 'nicethemes' ),
		'id'   => $prefix . '_thursday_hours',
		'std'  => '0',
		'tip'  => '',
		'type' => 'select_multiple',
		'options' 	=> array( 0 => __( 'Closed', 'nicethemes') , '01:00' => '01:00', '01:30' => '01:30',
							'02:00' => '02:00', '02:30' => '02:30', '03:00' => '03:00', '03:30' => '03:30', '04:00' => '04:00', '04:30' => '04:30',
							'05:00' => '05:00', '05:30' => '05:30', '06:00' => '06:00', '06:30' => '06:30', '07:00' => '07:00', '07:30' => '07:30',
							'08:00' => '08:00', '08:30' => '08:30', '09:00' => '09:00', '09:30' => '09:30', '10:00' => '10:00', '10:30' => '10:30',
							'11:00' => '11:00', '11:30' => '11:30', '12:00' => '12:00', '12:30' => '12:30', '13:00' => '13:00', '13:30' => '13:30',
							'14:00' => '14:00', '14:30' => '14:30', '15:00' => '15:00', '15:30' => '15:30', '16:00' => '16:00', '16:30' => '16:30',
							'17:00' => '17:00', '17:30' => '17:30', '18:00' => '18:00', '18:30' => '18:30', '19:00' => '19:00', '19:30' => '19:30',
							'20:00' => '20:00', '20:30' => '20:30', '21:00' => '21:00', '21:30' => '21:30', '22:00' => '22:00', '22:30' => '22:30',
							'23:00' => '23:00', '23:30' => '23:30', '24:00' => '24:00', '24:30' => '24:30' )
	);

	$nice_options[] = array(
		'name' => __( 'Friday Business Hours', 'nicethemes' ),
		'desc' => __( 'Use <strong>CTRL+Click (Windows)</strong> or <strong>CMD+Click (Mac)</strong> to select the times for which your business is open on a Friday.', 'nicethemes' ),
		'id'   => $prefix . '_friday_hours',
		'std'  => '0',
		'tip'  => '',
		'type' => 'select_multiple',
		'options' 	=> array( 0 => __( 'Closed', 'nicethemes' ) , '01:00' => '01:00', '01:30' => '01:30',
							'02:00' => '02:00', '02:30' => '02:30', '03:00' => '03:00', '03:30' => '03:30', '04:00' => '04:00', '04:30' => '04:30',
							'05:00' => '05:00', '05:30' => '05:30', '06:00' => '06:00', '06:30' => '06:30', '07:00' => '07:00', '07:30' => '07:30',
							'08:00' => '08:00', '08:30' => '08:30', '09:00' => '09:00', '09:30' => '09:30', '10:00' => '10:00', '10:30' => '10:30',
							'11:00' => '11:00', '11:30' => '11:30', '12:00' => '12:00', '12:30' => '12:30', '13:00' => '13:00', '13:30' => '13:30',
							'14:00' => '14:00', '14:30' => '14:30', '15:00' => '15:00', '15:30' => '15:30', '16:00' => '16:00', '16:30' => '16:30',
							'17:00' => '17:00', '17:30' => '17:30', '18:00' => '18:00', '18:30' => '18:30', '19:00' => '19:00', '19:30' => '19:30',
							'20:00' => '20:00', '20:30' => '20:30', '21:00' => '21:00', '21:30' => '21:30', '22:00' => '22:00', '22:30' => '22:30',
							'23:00' => '23:00', '23:30' => '23:30', '24:00' => '24:00', '24:30' => '24:30' )
	);

	$nice_options[] = array(
		'name' => __( 'Saturday Business Hours', 'nicethemes' ),
		'desc' => __( 'Use <strong>CTRL+Click (Windows)</strong> or <strong>CMD+Click (Mac)</strong> to select the times for which your business is open on a Saturday.', 'nicethemes' ),
		'id'   => $prefix . '_saturday_hours',
		'std'  => '0',
		'tip'  => '',
		'type' => 'select_multiple',
		'options' 	=> array( 0 => __( 'Closed', 'nicethemes'), '01:00' => '01:00', '01:30' => '01:30',
							'02:00' => '02:00', '02:30' => '02:30', '03:00' => '03:00', '03:30' => '03:30', '04:00' => '04:00', '04:30' => '04:30',
							'05:00' => '05:00', '05:30' => '05:30', '06:00' => '06:00', '06:30' => '06:30', '07:00' => '07:00', '07:30' => '07:30',
							'08:00' => '08:00', '08:30' => '08:30', '09:00' => '09:00', '09:30' => '09:30', '10:00' => '10:00', '10:30' => '10:30',
							'11:00' => '11:00', '11:30' => '11:30', '12:00' => '12:00', '12:30' => '12:30', '13:00' => '13:00', '13:30' => '13:30',
							'14:00' => '14:00', '14:30' => '14:30', '15:00' => '15:00', '15:30' => '15:30', '16:00' => '16:00', '16:30' => '16:30',
							'17:00' => '17:00', '17:30' => '17:30', '18:00' => '18:00', '18:30' => '18:30', '19:00' => '19:00', '19:30' => '19:30',
							'20:00' => '20:00', '20:30' => '20:30', '21:00' => '21:00', '21:30' => '21:30', '22:00' => '22:00', '22:30' => '22:30',
							'23:00' => '23:00', '23:30' => '23:30', '24:00' => '24:00', '24:30' => '24:30' )
	);

	$nice_options[] = array(
		'name' => __( 'Sunday Business Hours', 'nicethemes' ),
		'desc' => __( 'Use <strong>CTRL+Click (Windows)</strong> or <strong>CMD+Click (Mac)</strong> to select the times for which your business is open on a Sunday.', 'nicethemes' ),
		'id'   => $prefix . '_sunday_hours',
		'std'  => '0',
		'tip'  => '',
		'type' => 'select_multiple',
		'options' 	=> array( 0 => __( 'Closed', 'nicethemes'), '01:00' => '01:00', '01:30' => '01:30',
							'02:00' => '02:00', '02:30' => '02:30', '03:00' => '03:00', '03:30' => '03:30', '04:00' => '04:00', '04:30' => '04:30',
							'05:00' => '05:00', '05:30' => '05:30', '06:00' => '06:00', '06:30' => '06:30', '07:00' => '07:00', '07:30' => '07:30',
							'08:00' => '08:00', '08:30' => '08:30', '09:00' => '09:00', '09:30' => '09:30', '10:00' => '10:00', '10:30' => '10:30',
							'11:00' => '11:00', '11:30' => '11:30', '12:00' => '12:00', '12:30' => '12:30', '13:00' => '13:00', '13:30' => '13:30',
							'14:00' => '14:00', '14:30' => '14:30', '15:00' => '15:00', '15:30' => '15:30', '16:00' => '16:00', '16:30' => '16:30',
							'17:00' => '17:00', '17:30' => '17:30', '18:00' => '18:00', '18:30' => '18:30', '19:00' => '19:00', '19:30' => '19:30',
							'20:00' => '20:00', '20:30' => '20:30', '21:00' => '21:00', '21:30' => '21:30', '22:00' => '22:00', '22:30' => '22:30',
							'23:00' => '23:00', '23:30' => '23:30', '24:00' => '24:00', '24:30' => '24:30' )
	);

	/* Images */

	$nice_options[] = array(
		'name' => __( 'Images', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_media-image-d"></i>'
	);

	$nice_options[] = array(
		'name' => __( 'WP Resize Cropping', 'nicethemes' ),
		'desc' => __( 'The post thumbnail will be cropped to match the target aspect ratio.', 'nicethemes' ),
		'id'   => $prefix . '_wp_resize_crop',
		'std'  => 'true',
		'tip'  => '',
		'type' => 'checkbox'
	);

	$nice_options[] = array(
		'name' => __( 'JPEG Quality', 'nicethemes' ),
		'desc' => __( 'Change the JPEG compression-level of uploaded images and thumbnails.(Default is 90)', 'nicethemes' ),
		'id'   => $prefix . '_jpeg_quality',
		'std'  => array( 'range' => 'min', 'value' => '90', 'min' => '40', 'max' => '100', 'unit' => 'px' ),
		'type' => 'slider'
	);

	/* Social Media */

	$nice_options[] = array(
		'name' => __( 'Social Media', 'nicethemes' ),
		'type' => 'heading',
		'icon' => '<i class="bi_web-share-b"></i>',
	);


	$nice_options[] = array( 'name' => __( 'Facebook URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_facebook_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Twitter URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_twitter_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array( 'name' => __( 'Google+ URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_google_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Instagram URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_instagram_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Dribbble URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_dribbble_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Vimeo URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_vimeo_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Forrst URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_forrst_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Tumblr URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_tumblr_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Flickr URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_flickr_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Youtube URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_youtube_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Linkedin URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_linkedin_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( '500px URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_fivehundredpx_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Behance URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_behance_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Devianart URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_devianart_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Envato URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_envato_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Foursquare URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_foursquare_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Path URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_path_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Pinterest URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_pinterest_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Quora URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_quora_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Skype URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_skype_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'WordPress URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_wordpress_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Android URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_android_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Apple URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_apple_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Designmoo URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_designmoo_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Github URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_github_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Paypal URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_paypal_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Squarespace URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_squarespace_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Zerply URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_zerply_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	$nice_options[] = array(
		'name' => __( 'Yelp URL', 'nicethemes' ),
		'desc' => '',
		'id'   => $prefix . '_yelp_url',
		'std'  => '',
		'tip'  => '',
		'type' => 'text'
	);

	/**
	 * Let other functions add, remove or modify options.
	 *
	 */
	$nice_options = apply_filters( 'nice_options', $nice_options );

	if ( ( get_option( 'nice_template' ) != $nice_options ) ) {
		update_option( 'nice_template', $nice_options );
	}

}
endif;