<?php
/**
 * Paeon by NiceThemes.
 *
 * Load integrations and dependencies.
 *
 * @see nice_load_theming()
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2014-2015 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_load_theming' ) ) :
add_action( 'nice_load', 'nice_load_theming' );
/**
 * Load theming functions.
 *
 * @since 1.0.0.
 */
function nice_load_theming() {
	nice_loader( get_template_directory() . '/includes/theming/' );
}
endif;

if ( ! function_exists( 'nice_load_widgets' ) ) :
/**
 * Load Theme Widgets.
 *
 * @since 1.0.0
 */
add_action( 'nice_load', 'nice_load_widgets' );
function nice_load_widgets() {
	// Include the widgets inside the widgets folder.
	nice_loader( get_template_directory() . '/includes/widgets/' );
}
endif;

if ( ! function_exists( 'nice_load_admin_functions' ) ) :
add_action( 'nice_load', 'nice_load_admin_functions' );
/**
 * Load admin functions in `admin/includes/` folder.
 *
 * @since 1.0.0
 */
function nice_load_admin_functions() {
	if ( is_admin() || current_user_can( 'manage_options' ) ) {
		nice_loader( 'includes/admin/' );
	}
}
endif;

// Load integrations and dependencies here, allowing child themes and plugins to hook in.
do_action( 'nice_load' );
