<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains generic functions for this theme.
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


if ( ! function_exists( 'nice_display_feedback_items' ) ) :
 /**
 * nice_display_feedback_items()
 *
 * Retrieve feedback items, display them according to settings
 * in @param $args.
 *
 * @since 1.0.0
 *
 *
 * @param array $args Optional. Display info
 * @return string, if $args['echo'] is false.
 */

function nice_display_feedback_items ( $args = array() ) {

	$defaults = array(
					'post_type'      => 'feedback',
					'no_found_rows'  => true,
					'numberposts'    => 5,
					'orderby'        => 'rand',
					'order'          => 'DESC',
					'id'             => 0,
					'display_author' => true,
					'display_url'    => true,
					'effect'         => 'fade', // Options: 'fade', 'none', 'slide'
					'pagination'     => false,
					'echo'           => true
					);

	$args = wp_parse_args( $args, $defaults );

	$output = '';

	$items = get_posts( $args );

	// display items
	if ( ! is_wp_error( $items ) && is_array( $items ) && count( $items ) > 0 ) {

		$effect = '';

		if ( $args['effect'] != 'none' ) $effect = ' ' . $args['effect'];

		$output .= '<div class="feedback' . esc_attr( $effect ) . '">' . "\n";
		$output .= '<div class="feedback-list">' . "\n";

		foreach ( $items as $post ) {

			setup_postdata( $post );

			$feedback_author = '';

			// If we need to display either the author, URL or both, get the data.
			if ( $args['display_author'] == true || $args['display_url'] == true ) {
				$meta = get_post_custom( get_the_ID() );

				if ( isset( $meta['feedback_author'] ) && ( $meta['feedback_author'][0] != '' ) && $args['display_author'] == true ) {
					$feedback_author .= '<cite class="feedback-author">' . $meta['feedback_author'][0] . '</cite>' . "\n";
				}

				if ( isset( $meta['feedback_url'] ) && ( $meta['feedback_url'][0] != '' ) && $args['display_url'] == true ) {
					$feedback_author .= ' &mdash; <a href="' . esc_url( $meta['feedback_url'][0] ) . '" title="' . esc_attr( $meta['feedback_author'][0] ) . '" class="feedback-url">' . $meta['feedback_url'][0] . '</a>';
				}
			}

			$img_class = '';

			$output .= '<div id="quote-' . get_the_ID() . '" class="quote">' . "\n";

			if ( $args['featured_image'] > 0 ) {

				$img = nice_image( 'echo=0&height=' . $args['featured_image'] . '&width=' . $args['featured_image'] . '&class=thumbnail&single=true&id=' . get_the_ID() );

				if ( $img ) {
					$output .= '<div class="thumb alignleft">' . $img . '</div>';
				} else {
					$img_class = ' no-img';
				}

			} else {
				$img_class = ' no-img';
			}
				$output .= '<blockquote class="feedback-text' . esc_attr( $img_class ) . '">' . get_the_content() . '</blockquote>' . "\n";
				$output .= $feedback_author;
			$output .= '</div>' . "\n";

			wp_reset_postdata();
		}

		$output .= '</div>' . "\n";

		if ( $args['pagination'] == true && count( $items ) > 1 && $args['effect'] != 'none' ) {

			$output .= '<div class="pagination">' . "\n";
			$output .= '<a href="#" class="btn-prev">&larr; ' . __( 'Previous', 'nicethemes' ) . '</a>' . "\n";
			$output .= '<a href="#" class="btn-next">' .  __( 'Next', 'nicethemes' ) . ' &rarr;</a>' . "\n";
			$output .= '</div>' . "\n";

		}

		$output .= '</div>' . "\n";
	}


	if ( $args['echo'] != true ) { return $output; }

	// Should only run is "echo" is set to true.
	echo $output;

	wp_reset_query();

} // end nice_display_feedback_items()
endif;

if ( ! function_exists( 'nice_open_hours_is_next' ) ) :
/**
 * nice_open_hours_is_next()
 *
 * Check if the prev and current times should be
 * concatenated. This way, we can have different time blocks.
 *
 * @since 1.1.0
 *
 */
function nice_open_hours_is_next( $previous, $current ) {

	$prev_h = intval ( substr( $previous, 0, 2 ) );
	$prev_m = intval ( substr( $previous, -2 ) );
	$curr_h = intval ( substr( $current, 0, 2 ) );
	$curr_m = intval ( substr( $current, -2 ) );

	if ( ( $prev_h + 1 ) == $curr_h ) {

		if ( $prev_m == '30' ) {
			if ( $curr_m == '30' )
				return false;
			else
				return true;
		} else {
			return false;
		}

	} else {

		if ( $curr_m == '30' && ( $curr_h == $prev_h ) ) return true;
		else return false;

	}

}
endif;

if ( ! function_exists( 'nice_open_hours_day' ) ) {

	function nice_open_hours_day( $open_hours ) {

	if ( ! $open_hours ) return false;

	$hours = array();
	$start = $prev = '';

	foreach ( $open_hours as $h ){

		if ( ! $h ) return false;

		if ( ! $start ) $start = $h;

		if ( $prev ){

			if ( ! nice_open_hours_is_next( $prev, $h ) ){

				$hours[ $start ] = $prev;
				$start = $h;
				$prev = '';

			}else{
				$prev = $h;
			}

		} else {
			$prev = $h;
		}
	}

	$hours[ $start ] =  $prev;

	// cinderella fix! check if place is open after midnight.
	if ( ( 0 < ( $key = array_search( '24:30', $hours ) ) ) && ( array_key_exists( '01:00', $hours ) ) ) {
		$hours[ $key ] = $hours[ '01:00' ];
		unset( $hours[ '01:00' ] );
	}

	return $hours;
}
}

if ( ! function_exists( 'nice_opening_hours' ) ) {

	function nice_opening_hours() {

	$days = array ( __( 'Monday',    'nicethemes' ) => 'nice_monday_hours',
					__( 'Tuesday',   'nicethemes' ) => 'nice_tuesday_hours',
					__( 'Wednesday', 'nicethemes' ) => 'nice_wednesday_hours',
					__( 'Thursday',  'nicethemes' ) => 'nice_thursday_hours',
					__( 'Friday',    'nicethemes' ) => 'nice_friday_hours',
					__( 'Saturday',  'nicethemes' ) => 'nice_saturday_hours',
					__( 'Sunday',    'nicethemes' ) => 'nice_sunday_hours' );

	$html = '';

	$hours_format = get_option( 'nice_hours_format' );
	if ( empty( $hours_format ) ) $hours_format = 'h:i A';

	foreach ( $days as $day => $h ) {

		$html .= '<div class="day clearfix">';
		$hours = nice_open_hours_day( get_option( $h ) );
		$html .= '<span class="name">' . $day . '</span>';
		$html .= '<span class="hours">';
		if ( empty( $hours ) ) { $html .= __( 'Closed', 'nicethemes' ); }
		else{

			foreach ( $hours as $from => $to ) $html .= date( $hours_format, strtotime( $from ) ) . ' &mdash; ' . date( $hours_format, strtotime( $to ) ) . '<br />';

		}
		$html .= '</span>';

		$html .= '</div>';
	}

	return $html;

	}
}

if ( function_exists( 'nice_opengraph_for_posts' ) ) :
add_action( 'wp_head', 'nice_opengraph_for_posts' );
function nice_opengraph_for_posts() {

	if ( is_singular() ) {
		global $post;
		setup_postdata( $post );
		$output  = '<meta property="og:type" content="article" />' . "\n";
		$output .= '<meta property="og:title" content="' . esc_attr( get_the_title() ) . '" />' . "\n";
		$output .= '<meta property="og:url" content="' . get_permalink() . '" />' . "\n";
		$output .= '<meta property="og:description" content="' . esc_attr( get_the_excerpt() ) . '" />' . "\n";
		if ( has_post_thumbnail() ) {
			$imgsrc = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'medium' );
			$output .= '<meta property="og:image" content="' . $imgsrc[0] . '" />' . "\n";
		}
		echo $output;
	}

}
endif;


if ( ! function_exists( 'nice_social_icons' ) ) :
/**
 * nice_social_icons()
 *
 * Returns social icons markup
 *
 * @since 1.0.0
 *
 */
function nice_social_icons() {

	global $nice_options;

	$social_items = '';

	if ( isset( $nice_options['nice_facebook_url'] ) && $nice_options['nice_facebook_url'] != '' )
		$social_items .= '<li class="facebook"><a href="' . esc_url( $nice_options['nice_facebook_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_twitter_url'] ) && $nice_options['nice_twitter_url'] != '' )
		$social_items .= '<li class="twitter"><a href="' . esc_url( $nice_options['nice_twitter_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_google_url'] ) && $nice_options['nice_google_url'] != '' )
		$social_items .= '<li class="google"><a href="' . esc_url( $nice_options['nice_google_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_instagram_url'] ) && $nice_options['nice_instagram_url'] != '' )
		$social_items .= '<li class="instagram"><a href="' . esc_url( $nice_options['nice_instagram_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_dribbble_url'] ) && $nice_options['nice_dribbble_url'] != '' )
		$social_items .= '<li class="dribbble"><a href="' . esc_url( $nice_options['nice_dribbble_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_vimeo_url'] ) && $nice_options['nice_vimeo_url'] != '' )
		$social_items .= '<li class="vimeo"><a href="' . esc_url( $nice_options['nice_vimeo_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_forrst_url'] ) && $nice_options['nice_forrst_url'] != '' )
		$social_items .= '<li class="forrst"><a href="' . esc_url( $nice_options['nice_forrst_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_tumblr_url'] ) && $nice_options['nice_tumblr_url'] != '' )
		$social_items .= '<li class="tumblr"><a href="' . esc_url( $nice_options['nice_tumblr_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_flickr_url'] ) && $nice_options['nice_flickr_url'] != '' )
		$social_items .= '<li class="flickr"><a href="' . esc_url( $nice_options['nice_flickr_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_youtube_url'] ) && $nice_options['nice_youtube_url'] != '' )
		$social_items .= '<li class="youtube"><a href="' . esc_url( $nice_options['nice_youtube_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_linkedin_url'] ) && $nice_options['nice_linkedin_url'] != '' )
		$social_items .= '<li class="linkedin"><a href="' . esc_url( $nice_options['nice_linkedin_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_fivehundredpx_url'] ) && $nice_options['nice_fivehundredpx_url'] != '' )
		$social_items .= '<li class="fivehundredpx"><a href="' . esc_url( $nice_options['nice_fivehundredpx_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_behance_url'] ) && $nice_options['nice_behance_url'] != '' )
		$social_items .= '<li class="behance"><a href="' . esc_url( $nice_options['nice_behance_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_devianart_url'] ) && $nice_options['nice_devianart_url'] != '' )
		$social_items .= '<li class="devianart"><a href="' . esc_url( $nice_options['nice_devianart_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_envato_url'] ) && $nice_options['nice_envato_url'] != '' )
		$social_items .= '<li class="envato"><a href="' . esc_url( $nice_options['nice_envato_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_foursquare_url'] ) && $nice_options['nice_foursquare_url'] != '' )
		$social_items .= '<li class="foursquare"><a href="' . esc_url( $nice_options['nice_foursquare_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_path_url'] ) && $nice_options['nice_path_url'] != '' )
		$social_items .= '<li class="path"><a href="' . esc_url( $nice_options['nice_path_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_pinterest_url'] ) && $nice_options['nice_pinterest_url'] != '' )
		$social_items .= '<li class="pinterest"><a href="' . esc_url( $nice_options['nice_pinterest_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_quora_url'] ) && $nice_options['nice_quora_url'] != '' )
		$social_items .= '<li class="quora"><a href="' . esc_url( $nice_options['nice_quora_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_skype_url'] ) && $nice_options['nice_skype_url'] != '' )
		$social_items .= '<li class="skype"><a href="' . esc_url( $nice_options['nice_skype_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_wordpress_url'] ) && $nice_options['nice_wordpress_url'] != '' )
		$social_items .= '<li class="wordpress"><a href="' . esc_url( $nice_options['nice_wordpress_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_android_url'] ) && $nice_options['nice_android_url'] != '' )
		$social_items .= '<li class="android"><a href="' . esc_url( $nice_options['nice_android_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_apple_url'] ) && $nice_options['nice_apple_url'] != '' )
		$social_items .= '<li class="apple"><a href="' . esc_url( $nice_options['nice_apple_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_designmoo_url'] ) && $nice_options['nice_designmoo_url'] != '' )
		$social_items .= '<li class="designmoo"><a href="' . esc_url( $nice_options['nice_designmoo_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_github_url'] ) && $nice_options['nice_github_url'] != '' )
		$social_items .= '<li class="github"><a href="' . esc_url( $nice_options['nice_github_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_paypal_url'] ) && $nice_options['nice_paypal_url'] != '' )
		$social_items .= '<li class="paypal"><a href="' . esc_url( $nice_options['nice_paypal_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_squarespace_url'] ) && $nice_options['nice_squarespace_url'] != '' )
		$social_items .= '<li class="squarespace"><a href="' . esc_url( $nice_options['nice_squarespace_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_zerply_url'] ) && $nice_options['nice_zerply_url'] != '' )
		$social_items .= '<li class="zerply"><a href="' . esc_url( $nice_options['nice_zerply_url'] ) . '"></a></li>';

	if ( isset( $nice_options['nice_yelp_url'] ) && $nice_options['nice_yelp_url'] != '' )
		$social_items .= '<li class="yelp"><a href="' . esc_url( $nice_options['nice_yelp_url'] ) . '"></a></li>';

	return $social_items;

}
endif;

if ( ! function_exists( 'nice_custom_post_types' ) ) :
/**
 * nice_custom_post_types()
 *
 * Returns array of custom post types registered for this theme
 *
 * @return (array)
 */
function nice_custom_post_types() {
	return array( 'feedback', 'service', 'slide', 'staff' );
}

endif;

if ( ! function_exists( 'nice_cpt_add_meta_boxes' ) ) :
add_action( 'add_meta_boxes',  'nice_cpt_add_meta_boxes' );
/**
 * nice_cpt_add_meta_boxes()
 *
 * Remove the thumbnail metabox and add a new one with the proper Title for the custom post type.
 *
 * @return (string)
 */
function nice_cpt_add_meta_boxes() {

	$post_types = nice_custom_post_types();
	foreach ( $post_types as $post_type ) {

		if ( ! in_array( $post_type, array( 'service' ) ) ) {
			remove_meta_box( 'postimagediv', $post_type, 'side' );
			add_meta_box( 'postimagediv', sprintf( __( '%s Image', 'nicethemes' ), ucwords( $post_type ) ), 'post_thumbnail_meta_box', $post_type, 'side', 'default' );
		}
	}
}

endif;


if ( ! function_exists( 'nice_cpt_post_thumbnail_html' ) ) :
add_filter( 'admin_post_thumbnail_html', 'nice_cpt_post_thumbnail_html' );
/**
 * nice_cpt_post_thumbnail_html()
 *
 * Change the default string for the 'Set Featured Image' Link.
 *
 * @return (string) with the new html.
 */
function nice_cpt_post_thumbnail_html( $output ) {

	global $post_type;
	$nice_cpts = nice_custom_post_types();

	// beware of translated admin
	if ( ! empty ( $post_type ) && in_array( $post_type, $nice_cpts ) && ! in_array( $post_type, array( 'service' ) ) ) {
		$output = str_replace( __( 'Set featured image', 'nicethemes' ), sprintf( __( 'Select / Upload a %s image', 'nicethemes' ), $post_type ), $output );
		$output = str_replace( __( 'Remove featured image', 'nicethemes' ), sprintf( __( 'Remove %s image', 'nicethemes' ), $post_type ), $output );
	}

	return $output;
}

endif;



if ( ! function_exists( 'nice_cpt_title' ) ) :
add_filter( 'enter_title_here', 'nice_cpt_title' );
/**
 * nice_cpt_title()
 *
 * Change the default string for the Title input.
 *
 * @return (string)
 */
function nice_cpt_title( $title ) {

		$screen = get_current_screen();

		$title = sprintf( __( 'Enter the %s title', 'nicethemes' ), $screen->post_type );

		return $title;
}

endif;

if ( ! function_exists( 'nice_cpt_custom_columns' ) ) :
add_action( 'manage_posts_custom_column',  'nice_cpt_custom_columns' );
/**
 * nice_cpt_custom_columns()
 *
 * Adds the thumbnail column for the cutom post type list within the admin section.
 *
 * @return (string)
 */

function nice_cpt_custom_columns( $column ) {

	global $post;

	switch ( $column ) {

		case 'thumbnail' :
			if ( has_post_thumbnail( get_the_ID() ) ) { // the current post has a thumbnail
				echo '<a href="' . get_edit_post_link( $post->ID, true ) . '" title="' . esc_attr( __( 'Edit this item', 'nicethemes' ) ) . '">';
				the_post_thumbnail( array( 75, 75 ) );
				echo '</a>';
			}
			else { // the current post lacks a thumbnail

				_e( 'No image', 'nicethemes' );
			}

			// add row_action links for Edit and Trash because there's no title column
			$post_type_object = get_post_type_object( $post->post_type );
			$can_edit_post = current_user_can( $post_type_object->cap->edit_post, $post->ID );
			$always_visible = false; // change to true to make it always show instead of on hover
			$actions = array();

			if ( $can_edit_post && 'trash' != $post->post_status ) {
				$actions['edit'] = '<a href="' . get_edit_post_link( $post->ID, true ) . '" title="' . esc_attr( __( 'Edit this item', 'nicethemes' ) ) . '">' . __( 'Edit', 'nicethemes' ) . '</a>';
			}
			if ( current_user_can( $post_type_object->cap->delete_post, $post->ID ) ) {
				if ( 'trash' == $post->post_status )
					$actions['untrash'] = "<a title='" . esc_attr( __( 'Restore this item from the Trash', 'nicethemes' ) ) . "' href='" . wp_nonce_url( admin_url( sprintf( $post_type_object->_edit_link . '&amp;action=untrash', $post->ID ) ), 'untrash-' . $post->post_type . '_' . $post->ID ) . "'>" . __( 'Restore', 'nicethemes' ) . "</a>";
				elseif ( EMPTY_TRASH_DAYS )
					$actions['trash'] = "<a class='submitdelete' title='" . esc_attr( __( 'Move this item to the Trash', 'nicethemes' ) ) . "' href='" . get_delete_post_link( $post->ID ) . "'>" . __( 'Trash', 'nicethemes' ) . "</a>";
				if ( 'trash' == $post->post_status || ! EMPTY_TRASH_DAYS )
					$actions['delete'] = "<a class='submitdelete' title='" . esc_attr( __( 'Delete this item permanently', 'nicethemes' ) ) . "' href='" . get_delete_post_link( $post->ID, '', true ) . "'>" . __( 'Delete Permanently', 'nicethemes' ) . "</a>";
			}

			$action_count = count( $actions );
			$i = 0;
			$out = '<div class="' . ( $always_visible ? 'row-actions-visible' : 'row-actions' ) . '">';
			foreach ( $actions as $action => $link ) {
				++$i;
				( $i == $action_count ) ? $sep = '' : $sep = ' | ';
				$out .= "<span class='$action'>$link$sep</span>";
			}
			$out .= '</div>';

			echo $out;
			break;

					/* If displaying the 'category' column. */
					case 'category' :

							$cat_name = 'category';

							if ( ! strcmp( $post->post_type, 'staff' ) )
									$cat_name = 'department';
							else if ( ! strcmp( $post->post_type, 'service' ) )
									$cat_name = 'service-category';

							$terms = get_the_terms( get_the_ID(), $cat_name );

							/* If terms were found. */
							if ( ! empty( $terms ) ) {

									$out = array();

									/* Loop through each term, linking to the 'edit posts' page for the specific term. */
									foreach ( $terms as $term ) {
											$out[] = sprintf( '%s',
													esc_html( sanitize_term_field( 'name', $term->name, $term->term_id, 'genre', 'display' ) )
											);
									}

									/* Join the terms, separating them with a comma. */
									echo join( ', ', $out );
							}

							/* If no terms were found, output a default message. */
							else {
								echo '&mdash;';
							}

							break;

					/* Just break out of the switch statement for everything else. */
					default :
							break;
	}
}

endif;

if ( ! function_exists( 'nice_attachments_from_gallery' ) ) :
/**
 * nice_attachments_from_gallery()
 *
 * Returns ids of attachments from gallery
 *
 * @since 1.0.0
 *
 */
function nice_attachments_from_gallery() {

	global $post;
	$attachment_ids = array();
	$pattern = get_shortcode_regex();
	$ids = array();

	if ( preg_match_all( '/' . $pattern . '/s', $post->post_content, $matches ) ) {   //finds the "gallery" shortcode and puts the image ids in an associative array at $matches[3]
		$count = count( $matches[3] );      //in case there is more than one gallery in the post.
		for ( $i = 0; $i < $count; $i++ ){
			$atts = shortcode_parse_atts( $matches[3][ $i ] );
			if ( isset( $atts['ids'] ) ){
			$attachment_ids = explode( ',', $atts['ids'] );
			$ids = array_merge( $ids, $attachment_ids );
			}
		}
	}

	if ( ! empty( $ids ) )
		$ids = array_flip( $ids );

return $ids;

}
endif;

if ( ! function_exists( 'nice_content_without_gallery' ) ) :
add_filter( 'the_content', 'nice_content_without_gallery' );
/**
 * nice_content_without_gallery()
 *
 * Removes gallery shortcodes from content and returns the content
 *
 * @since 1.0.0
 *
 */

function nice_content_without_gallery( $content ) {
	global $post;

	if ( is_page_template( 'template-gallery.php' ) || has_post_format( 'gallery', get_the_ID() ) )
		$content = preg_replace( '/\[gallery[^\]]*\]/', '',  $content );

	return $content;
}
endif;

if ( ! function_exists( 'nice_taxonomies_limit' ) ) :
add_action( 'pre_get_posts', 'nice_taxonomies_limit' );
/**
 * nice_content_without_gallery()
 *
 * Set no limit for the taxonomies page main query.
 * All elements are listed now.
 *
 * @since 1.0.5
 *
 */
function nice_taxonomies_limit( $wp_query ) {

	if ( ( is_tax( 'service-category' ) || is_tax( 'department' ) ) && is_main_query() ) {
		$wp_query->set( 'posts_per_page', -1 );
		$wp_query->set( 'orderby', 'menu_order' );
		$wp_query->set( 'order', 'ASC' );
	}
}
endif;
