<?php
/*
*	Staff - Custom post type
*/

add_action( 'init', 'add_nice_staff' );

if ( ! function_exists( 'add_nice_staff' ) ) :

	function add_nice_staff() {

		$labels = array(
					'name'					=> __( 'Staff', 'nicethemes' ),
					'singular_name'			=> __( 'Staff', 'nicethemes' ),
					'add_new'				=> __( 'Add New', 'nicethemes' ),
					'add_new_item'			=> __( 'Add New Staff Item', 'nicethemes' ),
					'edit_item'				=> __( 'Edit Staff Item', 'nicethemes' ),
					'new_item'				=> __( 'New Staff Item', 'nicethemes' ),
					'view_item'				=> __( 'View Staff Item', 'nicethemes' ),
					'search_items'			=> __( 'Search Staff Items', 'nicethemes' ),
					'not_found'				=> __( 'No Staff Item found', 'nicethemes' ),
					'not_found_in_trash'	=> __( 'No Staff Items found in Trash', 'nicethemes' ),
					'parent_item_colon'		=> ''
					);

		$args = array(
					'labels'				=> $labels,
					'public'				=> true,
					'publicly_queryable'	=> true,
					'show_ui'				=> true,
					'query_var'				=> true,
					'rewrite'				=> true,
					'capability_type'		=> 'post',
					'hierarchical'			=> false,
					'menu_icon'				=> nice_admin_menu_icon( 'btn-staff.png' ),
					'menu_position'			=> null,
					'supports'				=> array( 'title', 'editor', 'thumbnail', 'page-attributes', 'excerpt' )
					);

		register_post_type( 'staff', $args );
	}

endif;

add_action( 'init', 'create_staff_taxonomies', 0 );

// create taxonomies
function create_staff_taxonomies() {

// Add new taxonomy, make it hierarchical (like categories)
$labels = array(
				'name'					=> __( 'Departments', 'nicethemes' ),
				'singular_name'			=> __( 'Department', 'nicethemes' ),
				'search_items'			=> __( 'Departments', 'nicethemes' ),
				'all_items'				=> __( 'All Departments', 'nicethemes' ),
				'parent_item'			=> __( 'Parent Department', 'nicethemes' ),
				'parent_item_colon'		=> __( 'Parent Department:', 'nicethemes' ),
				'edit_item'				=> __( 'Edit Department', 'nicethemes' ),
				'update_item'			=> __( 'Update Department', 'nicethemes' ),
				'add_new_item'			=> __( 'Add New Department', 'nicethemes' ),
				'new_item_name'			=> __( 'New Department', 'nicethemes' )
);

register_taxonomy( 'department',
					array( 'staff' ) ,
					array(
						'hierarchical'	=> true,
						'labels'		=> $labels,
						'show_ui'		=> true,
						'query_var'		=> true,
						'rewrite'		=> array( 'slug' => 'department' )
						)
				);
}


/**
 * nice_staff_edit_columns()
 *
 * Edit the columns for the Staff list within the admin section.
 *
 * @return (string)
 */

if ( ! function_exists( 'nice_staff_edit_columns' ) ) :

	function nice_staff_edit_columns( $columns ) {

		$columns = array(
						'cb' 		=> '<input type="checkbox" />',
						'title' 	=> __( 'Staff Title', 'nicethemes' ),
						'category'	=> __( 'Departments', 'nicethemes' ),
						'date' 		=> __( 'Date', 'nicethemes' )
						);

		return $columns;
	}

endif;

add_filter( 'manage_edit-staff_columns', 'nice_staff_edit_columns' );
?>