<?php
/*
*	Slide - Custom post type
*/

add_action( 'init', 'add_nice_slides' );

if ( ! function_exists( 'add_nice_slides' ) ) :

	function add_nice_slides() {

		$labels = array(
				'name'					=> __( 'Slides', 'nicethemes' ),
				'singular_name'			=> __( 'Slide', 'nicethemes' ),
				'add_new'				=> __( 'Add New', 'nicethemes' ),
				'add_new_item'			=> __( 'Add New Slide', 'nicethemes' ),
				'edit_item'				=> __( 'Edit Slide', 'nicethemes' ),
				'new_item'				=> __( 'New Slide', 'nicethemes' ),
				'view_item'				=> __( 'View Slide', 'nicethemes' ),
				'search_items'			=> __( 'Search Slides', 'nicethemes' ),
				'not_found'				=> __( 'No slides found', 'nicethemes' ),
				'not_found_in_trash'	=> __( 'No slides found in Trash', 'nicethemes' ),
				'parent_item_colon'		=> ''
		);

		$args = array(
				'labels'				=> $labels,
				'public'				=> false,
				'publicly_queryable'	=> false,
				'show_ui'				=> true,
				'query_var'				=> true,
				'rewrite'				=> true,
				'capability_type'		=> 'post',
				'hierarchical'			=> false,
				'menu_icon'				=> nice_admin_menu_icon( 'btn-slides.png' ),
				'menu_position'			=> null,
				'supports'				=> array( 'title', 'thumbnail', 'page-attributes' )
		);

		register_post_type( 'slide', $args );
	}

endif;


/**
 * nice_slide_edit_columns()
 *
 * Edit the columns for the Slide list within the admin section.
 *
 * @return (string)
 */

if ( ! function_exists( 'nice_slide_edit_columns' ) ) :

	function nice_slide_edit_columns( $columns ) {

		$columns = array(
			'cb' 		=> '<input type="checkbox" />',
			'thumbnail'	=> __( 'Slide Image', 'nicethemes' ),
			'title'		=> __( 'Slide Title', 'nicethemes' ),
			'date'		=> __( 'Date', 'nicethemes' )
		);

		return $columns;
	}

endif;

add_filter( 'manage_edit-slide_columns', 'nice_slide_edit_columns' );
?>