<?php
/*
*	Service - Custom post type
*/

add_action( 'init', 'add_nice_service' );

if ( ! function_exists( 'add_nice_service' ) ) :

	function add_nice_service() {

		$labels = array(
					'name'					=> __( 'Services', 'nicethemes' ),
					'singular_name'			=> __( 'Service', 'nicethemes' ),
					'add_new'				=> __( 'Add New', 'nicethemes' ),
					'add_new_item'			=> __( 'Add New Service Item', 'nicethemes' ),
					'edit_item'				=> __( 'Edit Service Item', 'nicethemes' ),
					'new_item'				=> __( 'New Service Item', 'nicethemes' ),
					'view_item'				=> __( 'View Service Item', 'nicethemes' ),
					'search_items'			=> __( 'Search Service Items', 'nicethemes' ),
					'not_found'				=> __( 'No Service Item found', 'nicethemes' ),
					'not_found_in_trash'	=> __( 'No Service Items found in Trash', 'nicethemes' ),
					'parent_item_colon'		=> ''
				);

		$args = array(
					'labels'				=> $labels,
					'public'				=> true,
					'publicly_queryable'	=> true,
					'show_ui'				=> true,
					'query_var'				=> true,
					'rewrite'				=> true,
					'capability_type'		=> 'post',
					'hierarchical'			=> false,
					'menu_icon'				=> nice_admin_menu_icon( 'btn-service.png' ),
					'menu_position'			=> null,
					'supports'				=> array( 'title', 'editor', 'thumbnail', 'page-attributes', 'excerpt' )
					);

		register_post_type( 'service', $args );
	}

endif;

add_action( 'init', 'create_service_taxonomies', 0 );

// create taxonomies
function create_service_taxonomies() {

// Add new taxonomy, make it hierarchical (like categories)
$labels = array(
					'name'				=> __( 'Services Categories', 'nicethemes' ),
					'singular_name'		=> __( 'Service Category', 'nicethemes' ),
					'search_items'		=> __( 'Service Categories', 'nicethemes' ),
					'all_items'			=> __( 'All Service Categories', 'nicethemes' ),
					'parent_item'		=> __( 'Parent Service Category', 'nicethemes' ),
					'parent_item_colon'	=> __( 'Parent Service Category:', 'nicethemes' ),
					'edit_item'			=> __( 'Edit Service Category', 'nicethemes' ),
					'update_item'		=> __( 'Update Service Category', 'nicethemes' ),
					'add_new_item'		=> __( 'Add New Service Category', 'nicethemes' ),
					'new_item_name'		=> __( 'New Service Category', 'nicethemes' )
			);

register_taxonomy( 'service-category',
					array( 'service' ),
					array(
						'hierarchical'	=> true,
						'labels'		=> $labels,
						'show_ui'		=> true,
						'query_var'		=> true,
						'rewrite'		=> array( 'slug' => 'service-category' ),
						)
				);
}


/**
 * nice_service_edit_columns()
 *
 * Edit the columns for the Service list within the admin section.
 *
 * @return (string)
 */

if ( ! function_exists( 'nice_service_edit_columns' ) ) :

	function nice_service_edit_columns( $columns ) {

		$columns = array(
						'cb' 		=> '<input type="checkbox" />',
						'title'		=> __( 'Service Title', 'nicethemes' ),
						'category'	=> __( 'Services Categories', 'nicethemes' ),
						'date'		=> __( 'Date', 'nicethemes' )
						);

		return $columns;
	}

endif;

add_filter( 'manage_edit-service_columns', 'nice_service_edit_columns' );
?>