<?php
/*
*	Feedback - Custom post type
*/

add_action( 'init', 'add_nice_feedback' );

if ( ! function_exists( 'add_nice_feedback' ) ) :

	function add_nice_feedback() {

		$labels = array(
					'name'					=> __( 'Feedback', 'nicethemes' ),
					'singular_name'			=> __( 'Feedback', 'nicethemes' ),
					'add_new'				=> __( 'Add New ', 'nicethemes' ),
					'add_new_item'			=> __( 'Add New Feedback Item', 'nicethemes' ),
					'edit_item'				=> __( 'Edit Feedback Item', 'nicethemes' ),
					'new_item'				=> __( 'New Feedback Item', 'nicethemes' ),
					'view_item'				=> __( 'View Feedback Item', 'nicethemes' ),
					'search_items'			=> __( 'Search Feedback Item', 'nicethemes' ),
					'not_found'				=> __( 'No Feedback Items found', 'nicethemes' ),
					'not_found_in_trash'	=> __( 'No Feedback Items found in Trash', 'nicethemes' ),
					'parent_item_colon'		=> ''
					);

		$args = array(
					'labels'				=> $labels,
					'public'				=> false,
					'publicly_queryable'	=> false,
					'show_ui'				=> true,
					'query_var'				=> true,
					'rewrite'				=> true,
					'capability_type'		=> 'post',
					'hierarchical'			=> false,
					'menu_icon'				=> nice_admin_menu_icon( 'btn-feedback.png' ),
					'menu_position'			=> null,
					'supports'				=> array( 'title','editor', 'thumbnail', 'page-attributes' )
				);

		register_post_type( 'feedback', $args );

	}

endif;


/**
 * nice_feedback_edit_columns()
 *
 * Edit the columns for the Feedback list within the admin section.
 *
 * @return (string)
 */

if ( ! function_exists( 'nice_feedback_edit_columns' ) ) :

	function nice_feedback_edit_columns( $columns ) {

		$columns = array(
			'cb'		=> '<input type="checkbox" />',
			'title'		=> __( 'Feedback Title', 'nicethemes' ),
			'date'		=> __( 'Date', 'nicethemes' )
		);

		return $columns;
	}

endif;

add_filter( 'manage_edit-feedback_columns', 'nice_feedback_edit_columns' );
?>