<?php
/**
 * Paeon by NiceThemes.
 *
 * This file contains functions to manage custom fields for post types.
 *
 * @see nice_fields()
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2021 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_fields' ) ) :
add_action( 'admin_head', 'nice_fields' );
/**
 * Load array with custom fields depending on post type,
 * then save the array into WP options.
 *
 * @since 1.0.0
 */
function nice_fields() {

	$nice_fields = array();

	global $post;

	if ( get_post_type() === 'page' || ! get_post_type() ) {

		$nice_fields[] = array(
			'name'  => 'page_info',
			'label' => __( 'Page Information', 'nicethemes' ),
			'type'  => 'info',
			'desc'  => __( 'You can select the page template from the "Template" dropdown on the "Page Attributes" box.</p><p>If you are using the "Gallery Template" plase be sure to upload images from the "Add Media" button at the top of this page. (Don\'t insert the gallery in the page content, just add the images).', 'nicethemes' )
		);

		$nice_fields[] = array(
			'name'  => 'page_sub_title',
			'label' => __( 'Page Sub Title', 'nicethemes' ),
			'type'  => 'textarea',
			'desc'  => __( 'Enter page sub title description here to be displayed in the top of the page.','nicethemes' )
		);
	}

	/* Slides */
	if ( get_post_type() === 'slide' || ! get_post_type() ) {

		$nice_fields[] = array(
			'name'  => 'slide_info',
			'label' => __( 'Slide Image', 'nicethemes' ),
			'type'  => 'info',
			'desc'  => __( 'Slides use the wordpress featured image as the slide image. Don\'t know what featured images are? How to use them? <a href="http://en.support.wordpress.com/featured-images/#setting-a-featured-image">Take a look at wordpress docs on Featured Images</a>.', 'nicethemes' )
		);

		$nice_fields[] = array(
			'name'  => 'slide_description',
			'label' => __( 'Slide Description', 'nicethemes' ),
			'std'   => '',
			'type'  => 'textarea',
			'desc'  => __( 'Enter slide description here to be displayed in the slide navigation bar.', 'nicethemes' )
		);

		$nice_fields[] = array (	'name'  => 'embed',
			'std'   => '',
			'label' => __( 'Video Embed Code', 'nicethemes' ),
			'type'  => 'textarea',
			'desc'  => __( 'Enter the video embed code for your video (YouTube, Vimeo or similar). Will show instead of your image.', 'nicethemes' )
		);

		$nice_fields[] = array (
			'name'  => 'url',
			'std'   => '',
			'label' => __( 'URL', 'nicethemes' ),
			'type'  => 'text',
			'desc'  => __( 'Enter URL if you want to add a link to the uploaded image and title. (optional)', 'nicethemes' )
		);

		$nice_fields[] = array (
			'name'  => 'url_text',
			'std'   => '',
			'label' => __( 'Anchor Text for the URL', 'nicethemes' ),
			'type'  => 'text',
			'desc'  => __( 'Enter Anchor text you would like to use for the URL button. (optional - will only work when the URL is set)', 'nicethemes' )
		);

	} // end slide

	/* Staff */
	if ( get_post_type() === 'staff' || ! get_post_type() ) {

		$nice_fields[] = array(
			'name'  => 'bio',
			'label' => __( 'Mini Bio', 'nicethemes' ),
			'type'  => 'textarea',
			'desc'  => __( 'Mini bio of this staff.', 'nicethemes' )
		);

		$nice_fields[] = array(
			'name'  => 'staff_facebook_url',
			'label' => __( 'Facebook URL', 'nicethemes' ),
			'type'  => 'text',
			'desc'  => __( 'Facebook URL for this staff.', 'nicethemes' )
		);

		$nice_fields[] = array(
			'name'  => 'staff_twitter_url',
			'label' => __( 'Twitter URL', 'nicethemes' ),
			'type'  => 'text',
			'desc'  => __( 'Twitter URL for this staff.', 'nicethemes' )
		);

		$nice_fields[] = array(
			'name'  => 'staff_google_plus_url',
			'label' => __( 'Google + URL', 'nicethemes' ),
			'type'  => 'text',
			'desc'  => __( 'Google plus URL for this staff.', 'nicethemes' )
		);

		$nice_fields[] = array(
			'name'  => 'staff_linkedin_url',
			'label' => __( 'Linkedin URL', 'nicethemes' ),
			'type'  => 'text',
			'desc'  => __( 'Linkedin URL for this staff.', 'nicethemes' )
		);


	} // end staff

	/* Post */
	if ( get_post_type() === 'post' || ! get_post_type() ) {


		$nice_fields[] = array (
			'name'  => 'embed',
			'std'   => '',
			'label' => __( 'Video Embed Code', 'nicethemes' ),
			'type'  => 'textarea',
			'desc'  => __( 'Enter the video embed code for your video (YouTube, Vimeo or similar).', 'nicethemes' )
		);

	} // end post


	/* Feedback */
	if ( get_post_type() === 'feedback' || ! get_post_type() ) {

		$nice_fields[] = array(
			'name'  => 'feedback_item_info',
			'label' => __( 'Feedback Image', 'nicethemes' ),
			'type'  => 'info',
			'desc'  => __( 'Feedback Items use the wordpress featured image as the feedback image. Don\'t know what featured images are? How to use them? <a href="http://en.support.wordpress.com/featured-images/#setting-a-featured-image">Take a look at wordpress docs on Featured Images</a>.', 'nicethemes' )
		);

		$nice_fields['feedback_author'] = array (
			'name'  => 'feedback_author',
			'label' => __( 'Feedback Author', 'nicethemes' ),
			'type'  => 'text',
			'desc'  => __( 'The name of the author of the feedback (e.g. John Doe)', 'nicethemes' )
		);

		$nice_fields['feedback_url'] = array (
			'name'  => 'feedback_url',
			'label' => __( 'Feedback URL', 'nicethemes' ),
			'type'  => 'text',
			'desc'  => __( 'The URL to the feedback author e.g. http://www.johndoe.com - (optional)', 'nicethemes' )
		);
	} // end feedback


	if ( get_option( 'nice_custom_fields' ) != $nice_fields ) {
		update_option( 'nice_custom_fields', $nice_fields );
	}

}
endif;