<?php
/**
 * Paeon by NiceThemes.
 *
 * This file includes functions to interact with the NiceFramework
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/product/paeon
 * @copyright 2021 NiceThemes
 * @since     1.1.9
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! function_exists( 'nice_theme_admin_menu_label' ) ) :
add_filter( 'nice_admin_menu_label', 'nice_theme_admin_menu_label' );
add_filter( 'nice_admin_bar_menu_label', 'nice_theme_admin_menu_label' );
/**
 * Set the Admin Menu label
 *
 * @since 1.1.9
 *
 * @return string
 */
function nice_theme_admin_menu_label() {
	return esc_html__( 'Paeon', 'nicethemes' );
}
endif;

if ( ! function_exists( 'nice_font_weight' ) ) :
/**
 * Return an array of the different font weight options
 *
 * @since  1.1.9
 *
 * @return array
 */
function nice_font_weight() {
	$font_weight = array(
		''  => esc_html__( 'Default CSS', 'nicethemes' ),
		100 => esc_html__( '100', 'nicethemes' ),
		200 => esc_html__( '200', 'nicethemes' ),
		300 => esc_html__( '300', 'nicethemes' ),
		400 => esc_html__( '400', 'nicethemes' ),
		500 => esc_html__( '500', 'nicethemes' ),
		600 => esc_html__( '600', 'nicethemes' ),
		700 => esc_html__( '700', 'nicethemes' ),
		800 => esc_html__( '800', 'nicethemes' ),
		900 => esc_html__( '900', 'nicethemes' ),
	);

	return $font_weight;
}
endif;
