<?php
/**
 * Paeon by NiceThemes.
 *
 * The Header for our theme.
 *
 * Displays all of the `<head>` section and everything up till `<div id="wrapper">`
 *
 * @package   Paeon
 * @author    NiceThemes <hello@nicethemes.com>
 * @license   GPL-2.0+
 * @link      http://nicethemes.com/theme/paeon
 * @copyright 2016 NiceThemes
 * @since     1.0.0
 */
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

global $nice_options;
?>
<!DOCTYPE html>
<!--[if IE 7]>	<html class="ie ie7" <?php language_attributes(); ?> prefix="og: http://ogp.me/ns#">	<![endif]-->
<!--[if IE 8]>	<html class="ie ie8" <?php language_attributes(); ?> prefix="og: http://ogp.me/ns#">	<![endif]-->
<!--[if IE 9]>	<html class="ie ie9" <?php language_attributes(); ?> prefix="og: http://ogp.me/ns#">	<![endif]-->
<!--[if (gt IE 9)|!(IE)]>
<html <?php language_attributes(); ?> prefix="og: http://ogp.me/ns#">
<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<title><?php wp_title( '&laquo;', true, 'right' ); ?> <?php bloginfo( 'name' ); ?></title>

	<!-- Pingback -->
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />

	<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<!-- BEGIN #content-top -->
<div id="content-top">

	<div id="featured-wrap" class="clearfix">

	<!-- BEGIN #header -->
<?php 
if(is_page_template( 'template-home.php' ))
{ ?>
	<header id="header" class="clearfix">
<?php } else { ?>
<header id="header" class="clearfix inner-header">
<?php }?>
		<!-- BEGIN #top -->
		<div id="top" class="col-full">

			<!-- BEGIN #logo -->
		<div id="logo" class="fl">
			<?php //nice_logo(); ?>
				<h1><span id="default-logo-wrapper" class="header-logo-wrapper"><a href="<?php echo site_url();?>" title="Haller Eye Center"><img src="<?php echo site_url();?>/wp-content/uploads/2018/10/riverdale_opt_final_logo.png" id="default-logo" height="70" alt="Haller Eye Center" title="Haller Eye Center" class="img-logo img-custom-logo">
<img src="<?php echo site_url();?>/wp-content/uploads/2018/10/riverdale_opt_final_logo.png" id="retina-logo" height="70" alt="Haller Eye Center" title="Haller Eye Center" class="img-logo img-logo-retina img-custom-logo">
</a></span></h1>			
			</div>
	<!-- END #logo --> 

			<a href="#" id="toggle-nav"><i class="fa fa-bars"></i></a>

			<!-- BEGIN #navigation -->
			<nav id="navigation">

			<?php $defaults = array(
								'menu'            => '',
								'container'       => 'div',
								'container_class' => '',
								'container_id'    => '',
								'menu_class'      => 'nav fl clearfix',
								'menu_id'         => 'main-nav',
								'echo'            => true,
								'fallback_cb'     => 'wp_page_menu',
								'before'          => '',
								'after'           => '<span class="down-arrow"><i class="fa fa-angle-down"></i></span>',
								'link_before'     => '',
								'link_after'      => '',
								'depth'           => 0,
								'walker'          => '',
								'theme_location'  => 'navigation-menu'
							);

			wp_nav_menu( $defaults ); ?>

			<!-- END #navigation -->
			</nav>

		<!-- END #top -->
		</div>

	<!-- END #header -->
	</header>


<?php

if ( isset( $nice_options['nice_slider'] ) && nice_bool( $nice_options['nice_slider'] ) &&  is_page_template( 'template-home.php' ) ) :

	$slides = get_posts( array ( 'post_type' => 'slide', 'showposts' => $nice_options['nice_slider_entries'], 'orderby' => 'menu_order', 'order' => 'ASC', 'suppress_filters' => 0 ) );

		if ( ! empty ( $slides ) ) : ?>

			<div class="home-flexslider-wrapper">

			<!-- BEGIN .flexslider -->
			<div id="featured" class="flexslider slider <?php echo esc_attr( $nice_options['nice_slider_animation'] ) . '-effect'; ?> ">

				<ul class="slides">

					<?php foreach ( $slides as $post ) :

							setup_postdata( $post ); ?>

							<li class="slide">
								<?php

								if ( get_post_meta( get_the_ID(), 'embed', $single = true ) ) :
										nice_embed( array ( 'key' => 'embed', 'width' => 2560, 'height' => 400, 'wrap' => true, 'embed_id' => 'player_' .get_the_ID() ) ) . "\n";
								elseif ( has_post_thumbnail() ) :

										nice_image( array ( 'key' => 'slider-image', 'width' => 2560, 'height' => 1000 ) ) . "\n";

										if ( $nice_options['nice_slider_caption'] == 'true' ) :

												$slide_description = get_post_meta( get_the_ID(), 'slide_description', true );

												?>
												<div class="slide-info">
														<div class="col-full">
															<div class="flex-caption">
																<!--<h2><?php //echo get_the_title(); ?></h2>-->
																<?php if ( $slide_description != '' ) : ?>
																	<p><?php echo $slide_description; ?></p>
																<?php endif ?>
																<?php
																		$slide_url = get_post_meta( get_the_ID(), 'url', true );

																		if ( nice_bool( $slide_url ) ) {

																			$slide_url_text = get_post_meta( get_the_ID(), 'url_text', true );
																			if ( empty( $slide_url_text) ) $slide_url_text = __( 'Read More', 'nicethemes' );

																			echo '<a class="read-more" href="' . esc_url( $slide_url ) . '" title="' . esc_attr( get_the_title() ) . '">' . $slide_url_text . '</a>';
																		}
																?>
															</div>
														</div>
												</div>

									<?php endif; ?>

								<?php endif ?>

							</li>

						<?php endforeach; ?>

					</ul>

				<!-- END .flexslider -->
				</div>

			</div>

	<?php endif; ?>
<?php endif; ?>
	</div>
	

</div>

<!-- BEGIN #wrapper -->
<div id="wrapper">
