<?php
/*
Template Name:Home-template
*/
?>
<?php get_header(); ?>
<?php $page_url    =  site_url();?>
<div id="core" class="container_home_page">
	<div class="home-banner">
		<div class="hero-slider">
			<?php
		        if ( have_rows('slider_images') ) {
		            while ( have_rows('slider_images') ) {
		            the_row();
		           	$slide_image = get_sub_field('slide_image'); ?>
		            <div>
		             	<img src="<?php echo esc_url($slide_image['url']); ?>" alt="<?php echo esc_attr($slide_image['name']); ?>" />
		             	<div class="slider-caption">
		             		<div class="container">
			             		<div class="title"><?php the_sub_field('slider_title'); ?></div>
			             		<div class="slidedesc"><?php the_sub_field('slider_tag'); ?></div>
			             	</div>
		             	</div>
		            </div>
		            <?php
		            }
		        }
		          else{
		           the_post_thumbnail( 'full' );
		        }
		      ?>
		</div>
	</div>
		<?php $show_banner =  get_field( "show_banner" );
		$bg_color =  get_field( "background_color" );
		if($show_banner=='1'){?>
		<div class="home_banner" style="background-color:<?php echo $bg_color;?>">
			<div class="container" >
			<?php $link = get_field('banner_link');
			   if( $link ):
				$link_url = $link['url'];
				$link_title = $link['title'];
				$link_target = $link['target'] ? $link['target'] : '_self';
				?>
					<div class="inner-bx">
						<div class="cnt">
							<h3 class="common-heading"><?php echo get_field( "banner_title" );?></h3>
							<p class="content-section"><?php echo get_field( "banner_content" );?></p>
						</div>
						<a href="<?php echo esc_url( $link_url ); ?>" class="information text-link" target="_blank"><?php echo get_field( "more_information" );?></a>
					</div>
			<?php endif; ?>
				</div>
			</div>
	  <?php } ?>
		<div class="about_school">
			<div class="container">
				<div class="about-left">
					<h2 class="common-heading"><?php echo get_field( "title" );?></h2>
					<p><?php echo get_field( "content" );?></p>
					<div class=" d-flex"><a class="primary-btn" href="<?php echo site_url();?>/our-school/principals-welcome/">EXPLORE</a></div>
				</div>
				<?php
				$args = array(
				'post_type' => 'gallery',
				'posts_per_page' => '5',
				'order' => 'DESC'
				);
				//$count_posts = wp_count_posts( 'gallery' )->publish;
				print_r($count_posts);
				$my_posts = new WP_Query( $args );?>
				<div class="about-right">
					<div class="home_gallery">
						<?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
						<div class="post-thumb-wrapp">
							<div class="gallery-bx">
								<?php $id = get_the_ID();?>
								<?php //echo get_the_post_thumbnail($id,'medium', array('700','387'));?>
								<?php the_post_thumbnail( 'complete_medium' );?>
								<span class="gallery-tile"><?php the_title(); ?></span>
							</div>
						</div>
						<?php endwhile;
						wp_reset_query();?>
					</div>
					<a class="primary-btn"href="<?php echo site_url();?>/gallery">Gallery</a>
				</div>
			</div>
		</div><!--about_school End-->
		<div class="second-section">
			<div class="container">
				<div class="news_section">
					<h2 class="common-heading">News</h2>
					<?php echo do_shortcode( '[home_news]' );?>
				</div>
				<div class="calender-event" id="calendar">
					<div class="inner-bx">
							<div class="left-part">
								<h2 class="common-heading">School Calendar</h2>
								<iframe src="https://www.uniqueschoolapp.ie/site/viewcalender/school_id/23/style/list/type/mobile" style="border:none;width:100%;overflow: hidden;"></iframe>
							</div>
							<div class="right-part">
								<iframe src="https://www.uniqueschoolapp.ie/site/viewcalender/school_id/23/backgroundcolor/<?php the_field( "calendar_bg_color" );?>/textcolor/<?php the_field( "calendar_text_color" );?>/eventcolor/<?php the_field( "calendar_event_color" );?>/buttoncolor/<?php the_field( "calendar_button_color" );?>/todayscolor/<?php the_field( "calendar_today_color" );?>" style="border:none;width:100%;"></iframe>
							</div>
						</div>
	  			</div>
			</div>
		</div><!----second-section End-->
	  <div class="learning_section">
	  	 <div class="container">
				<h2 class="common-heading">Learning at Loreto College Foxrock</h2>
				<div class="four_img_box">
					<?php while( have_rows('learning_pages') ): the_row();?>
						<?php $learning_pages= get_sub_field('cms_pages');?>
						<?php $page_id	= $learning_pages->ID;?>
					  <div class="inner-bx">
			         <div class="cms_img"><img alt="<?php bloginfo('name') ;?>" src="<?php echo get_the_post_thumbnail_url( $page_id, 'full' );?>"></div>
			         <div class="page_title"><?php echo '<a href="'. esc_url( get_page_link( $page_id ) ) .'">'.'<span class="gen-title">'.$learning_pages->post_title .'</span>' .'<span class="arrow"></span>'.'</a>';?>
			         </div>
			      </div>
			      <?php endwhile; ?>
		    	</div>
	    </div><!----container End-->
	  </div><!----learning_section End-->
	  <div class="school_description">
	  	<div class="container">
	  		<div class="inner-bx">
	  			<div class="left-part">
	  				<div class="image"><?php  $image= get_field( "image" );?>
						<img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['name']); ?>" class="top_dots" />
					</div>
	  			</div>
	  			<div class="right-part">
	  				<div class="content_school"><p><?php echo get_field( "content_description" );?></p></div>
		  				<div class="btn_link">
									<?php $link = get_field('link');
							   if( $link ):
							    $link_url = $link['url'];
							    $link_title = $link['title'];
							    $link_target = $link['target'] ? $link['target'] : '_self';
							    ?>
							    <a class="white-btn" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
							<?php endif; ?>
		  			</div>
	  			</div>
	  		</div>
	  	</div>
	  </div><!---school_description End-->
	 <div class="contact_info" id="contact">
		 	<div class="container">
		 		<h3 class="gen-heading">Get in Touch</h3>
		 		<div class="inner-bx">
		   		<div class="left-part">
		   			<div class="address-detail-bx">
		   				<ul>
		   					<li class="call">
		   						<div class="image">
		   							<svg width="35" height="59" viewBox="0 0 35 59" fill="none" xmlns="http://www.w3.org/2000/svg">
										<rect x="1" y="1" width="33" height="57" rx="5" stroke="#006938" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
										<circle cx="17.5" cy="48.5" r="2.5" stroke="#006938" stroke-width="2"/>
										<line x1="12" y1="7" x2="24" y2="7" stroke="#006938" stroke-width="2"/>
										</svg>
		   						</div>
		   						<div class="text">
		   							<h4 class="sub-heading">Call</h4>
									<p><a class="text-link" href="tel:<?php echo get_field('phone','option' ); ?>"><?php echo get_field('phone','option' ); ?></a></p>
		   						</div>
		   					</li>
		   					<li class="email">
		   						<div class="image">
		   							<svg width="37" height="63" viewBox="0 0 37 63" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
										<svg width="29" height="58" viewBox="0 0 29 58" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M17.4734 5.85167L1.0238 43.9625V56.8121L11.0326 48.0779L27.4822 9.50733C27.4822 9.50733 30.5636 4.56015 25.6518 2.23979C19.35 -0.737281 17.4734 5.85167 17.4734 5.85167Z" stroke="#006938" stroke-miterlimit="10"/>
										</svg> </svg>
		   						</div>
		   						<div class="text">
		   							<h4 class="sub-heading">Email</h4>
										<p>
												<a class="text-link" href="mailto:<?php echo get_field('email','option' ); ?>"><?php echo get_field('email','option' ); ?></a>
												<a class="text-link" href="mailto:<?php echo get_field('email_2','option' ); ?>"><?php echo get_field('email_2','option' ); ?></a>
										</p>
		   						</div>
		   					</li>
		   					<li class="find_us">
		   						<div class="image">
		   							<svg width="40" height="59" viewBox="0 0 40 59" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M0.656128 58.5914V0.556519H37.9288L17.8143 11.1139L36.3095 20.3131L0.656128 20.1649" fill="white"/>
											<path d="M0.656128 58.5914V0.556519H37.9288L17.8143 11.1139L36.3095 20.3131L0.656128 20.1649" stroke="#006938" stroke-miterlimit="10"/>
										</svg>
		   						</div>
		   						<div class="text">
		   							<h4 class="sub-heading">Find us</h4>
										<p><?php echo get_field('get_touch_address','option' ); ?></p>
		   						</div>
		   					</li>
		   				</ul>
		   			</div>
		   		</div>
					<div class="middle-part">
		   			<div class="timing-bx">
						<div class="text">
							<h4 class="sub-heading">Our School Day</h4>
							<div><?php echo get_field('opening_times','option' ); ?></div>
						</div>
					</div>
		   		</div>
		   		<div class="right-part">
		   			<div class="map">
						<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3827.4277355072404!2d-6.179523022253306!3d53.27289217226822!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x486708588d2255bf%3A0xfa77fc4d02f8dc7f!2sLoreto%20College%20Foxrock!5e1!3m2!1sen!2sie!4v1705329389921!5m2!1sen!2sie"style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
						</div>
		   		</div>
			</div>
		</div>
	</div><!----contact_info End---->
</div><!-----container_home_page end--->
<script>
$('.home_gallery').slick({
	dots: true,
   infinite: true,
  slidesToShow: 1,
  slidesToScroll: 1,
 responsive: [
    {
      breakpoint: 768,
      settings: {
        arrows: false,
        dots: true,
   		infinite: true,
  		slidesToShow: 1,
  		slidesToScroll: 1,
      }
    },
    {
      breakpoint: 480,
      settings: {
        dots: true,
  	    infinite: true,
  		slidesToShow: 1,
  		slidesToScroll: 1,
      }
    }
  ]
});
//hero-slider
$('.hero-slider').slick({
    dots: true,
    infinite: false,
    fade: true,
    autoplay:true,
    arrows:false,
    speed: 900,
    slidesToShow: 1,
    slidesToScroll: 1
});
</script>
<?php get_footer(); ?>
