<?php
/*
Template Name:Home-template
*/
?>
<?php get_header(); ?>
<?php $page_url    =  site_url();?>
<div id="core" class="container_home_page">
	<div class="home-banner">
		<div class="hero-slider">
			<?php
		        if ( have_rows('slider_images') ) {
		            while ( have_rows('slider_images') ) {
		            the_row();
		           	$slide_image = get_sub_field('slide_image'); ?>
		            <div>
		             	<img src="<?php echo esc_url($slide_image['url']); ?>" alt="<?php echo esc_attr($slide_image['name']); ?>" />
		             	<div class="slider-caption">
		             		<div class="container">
			             		<div class="title"><?php the_sub_field('slider_title'); ?></div>
			             		<div class="slidedesc"><?php the_sub_field('slider_tag'); ?></div>
			             	</div>
		             	</div>
		            </div>
		            <?php
		            }
		        }
		          else{
		           the_post_thumbnail( 'full' );
		        }
		      ?>
		</div>
	</div>
		<?php $show_banner =  get_field( "show_banner" );
		$bg_color =  get_field( "background_color" );
		if($show_banner=='1'){?>
		<div class="home_banner" style="background-color:<?php echo $bg_color;?>">
			<div class="container" >
			<?php $link = get_field('banner_link');
			   if( $link ):
				$link_url = $link['url'];
				$link_title = $link['title'];
				$link_target = $link['target'] ? $link['target'] : '_self';
				?>
					<div class="inner-bx">
						<div class="cnt">
							<h3 class="common-heading"><?php echo get_field( "banner_title" );?></h3>
							<p class="content-section"><?php echo get_field( "banner_content" );?></p>
						</div>
						<a href="<?php echo esc_url( $link_url ); ?>" class="information text-link" target="_blank"><?php echo get_field( "more_information" );?></a>
					</div>
			<?php endif; ?>
				</div>
			</div>
	  <?php } ?>

	  <div class="quick-access">
		  <div class="container">
		  
		    <ul>
		    <?php
		      if( have_rows('menu_section','option') ):
		        while( have_rows('menu_section','option') ) : the_row();   
		        $image = get_sub_field('menuimage');  
		            $link = get_sub_field('name_with_link');
		            if( $link ): 
		                $link_url = $link['url'];
		                $link_title = $link['title'];
		                $link_target = $link['target'] ? $link['target'] : '_self';
		                ?>
		                <li>
		                <a class="button" href="<?php echo esc_url( $link_url );?>" target="<?php echo esc_attr( $link_target ); ?>">
		                  <figure>
		                    <?php $size = 'full'; // (thumbnail, medium, large, full or custom size)
		                      if( $image ) {
		                          echo wp_get_attachment_image( $image, $size );
		                      } ?>
		                  </figure>
		                  <span><?php echo esc_html( $link_title ); ?></span>                   
		                </a>
		              </li>
		            <?php endif; ?>

		        <?php 

		        endwhile;
		      endif;?>
		    </ul>
		  </div>
		</div><!---->

		<div class="about_school">
			<div class="container">
					<div class="about-left">
						<figure>
							<?php $principalImage = get_field( "principal_image" );?>
							<img src="<?php echo esc_url($principalImage['url']); ?>" alt="<?php echo esc_attr($principalImage['alt']); ?>"/>
						</figure>						
					</div>
					<div class="about-midd">
						<h2 class="common-heading"><?php echo get_field( "title" );?></h2>
						<?php echo get_field( "content" );?>
						<div class="d-inline-flex">
							<a href="<?php echo site_url();?>/our-school/principals-welcome/" class="border-btn">Read More</a>
							<a href="<?php echo site_url();?>/our-school/why-choose-loreto-abbey/" class="border-btn">Admissions</a>
						</div>				
					</div>
					<div class="about-right">						
							<?php $principalImage = get_field( "principal_image" );?>
							<img src="<?php echo bloginfo('template_url');?>/images/loreto-school.png" alt="loreto-school"/>								
					</div>
			</div>
		</div>

		<div class="school_description">
			<div class="container">
				<div class="inner-bx">
					<div class="left-bx">
		  				<div class="image"><?php  $image= get_field( "image" );?>
							<img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['name']); ?>" class="top_dots" />
						</div>
							
						<?php $link = get_field('button_link');
							if( $link ):
							$link_url = $link['url'];
							$link_title = $link['title'];
							$link_target = $link['target'] ? $link['target'] : '_self';
							?>
							<a class="border-btn" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>">
								<?php echo esc_html( $link_title ); ?>
							</a>
						<?php endif; ?>
							
					</div>
					<div class="cnt-bx">
						<h2 class="common-heading">Our Mission Statement</h2>
						<p><?php echo get_field( "content_description" );?></p>
					</div>
					<div class="right-bx">	
						<?php $video_link = get_field('video_link');
						echo $video_link;?>				
						<div class="help-blog"><?php echo $video_help_text = get_field('video_help_text');?></div>
					</div>
				</div>
			</div>
		</div><!---school_description End-->

	



		<div class="second-section">
			<div class="container">
				<div class="news_section">
					<h2 class="common-heading">News</h2>
					<?php echo do_shortcode( '[home_news]' );?>
				</div>
				
			</div>
		</div><!----second-section End-->	  

		<div class="instagram-section">
			<div class="container">
				<h2 class="common-heading d-flex">
					<div class="insta-icon"><img src="<?php echo bloginfo('template_url');?>/images/Instagram-icon.png" class="attachment-auto size-auto" alt="Instagram-icon"></div>
					Follow us on Instagram</h2>
			</div>
			<?php echo do_shortcode('[instagram-feed feed=1]');?>

		</div><!---instagram-section End-->


	 
</div><!-----container_home_page end--->
<script>
$('.home_gallery').slick({
	dots: true,
   infinite: true,
  slidesToShow: 1,
  slidesToScroll: 1,
 responsive: [
    {
      breakpoint: 768,
      settings: {
        arrows: false,
        dots: true,
   		infinite: true,
  		slidesToShow: 1,
  		slidesToScroll: 1,
      }
    },
    {
      breakpoint: 480,
      settings: {
        dots: true,
  	    infinite: true,
  		slidesToShow: 1,
  		slidesToScroll: 1,
      }
    }
  ]
});
//hero-slider
$('.hero-slider').slick({
    dots: true,
    infinite: false,
    fade: true,
    autoplay:true,
    arrows:true,
    speed: 900,
    slidesToShow: 1,
    slidesToScroll: 1
});
</script>
<?php get_footer(); ?>
