<?php
/*CHECK IF Complete row exist in the wp_options table. Needed for Redux Conversion process*/
$completedb = get_option( 'complete' );
//**************Complete SETUP******************//
function Complete_setup() {
	//add_theme_support( 'custom-header' );
	add_theme_support( 'title-tag' );			//WP 4.1 Site Title
	add_theme_support( 'woocommerce' );			//Woocommerce Support
	add_theme_support('automatic-feed-links');	//RSS FEED LINK
	add_theme_support( 'post-thumbnails' );		//Post Thumbnail
	//Custom Background
	add_theme_support( 'custom-background', array( 'default-color' => 'ffffff') );
	//Make theme available for translation
	load_theme_textdomain('complete', get_template_directory() . '/languages/');
	//Custom Thumbnail Size
	/*add_image_size( 'complete_thumb', 400, 270, true );*/ /*(cropped)*/
	add_image_size( 'complete_thumb', 300, 300, false ); /*(cropped)*/
	add_image_size( 'complete_medium', 700, 387, true ); /*(cropped)*/
	add_image_size( 'footerthumb', 50, 42, false );
	 add_image_size( 'gallery_image', 700, 600, true );
	//Register Menus
	register_nav_menus( array(
			'primary' => __( 'Header Navigation', 'complete' ),
			'footer' => __( 'Footer Navigation', 'complete' ),
			'top-menu' => __( 'Top Menu Navigation', 'complete' ),
		) );
	}
add_action( 'after_setup_theme', 'Complete_setup' );
//**************Complete FUNCTIONS******************//
require(get_template_directory() . '/sktframe/core-functions.php');			//Include Complete sktframe Core Functions
require(get_template_directory() . '/lib/functions/core.php');					//Include Core Functions
require(get_template_directory() . '/lib/functions/enqueue.php');					//Include Enqueue CSS/JS Scripts
require(get_template_directory() . '/lib/functions/admin.php');				//Include Admin Functions (admin)
require(get_template_directory() . '/lib/functions/woocommerce.php');			//Include Woocommerce Functions
require(get_template_directory() . '/lib/functions/defaults.php');
require(get_template_directory() . '/customizer/customizer.php');
require(get_template_directory() . '/lib/functions/converter.php');
require(get_template_directory() . '/lib/includes/google_fonts.php');
//WIDGETS
require(get_template_directory() . '/sktframe/core-posts.php');
require(get_template_directory() . '/sktframe/core-pagination.php');
define('SKT_THEME_DOC', 'http://sktthemesdemo.net/documentation/lms-documentation/','complete');
define('SKT_URL','https://www.sktthemes.net','complete');
define('SKT_PRO_THEME_URL','https://www.sktthemes.net/shop/lms-wordpress-theme/','complete');
define('SKT_LIVE_DEMO','http://sktperfectdemo.com/demos/education/','complete');
define('SKT_THEMES','https://www.sktthemes.net/themes/','complete');
require_once get_template_directory() . '/customize-pro/example-1/class-customize.php';
/*Custom template for about theme. */
require get_template_directory() . '/sktframe/about-themes.php';


function vipx_remove_cpt_slug( $post_link, $post, $leavename ) {
    if ( ! in_array( $post->post_type, array( 'gallery' ,'video-gallery') ) || 'publish' != $post->post_status )
        return $post_link;
   // return $post_link;
}
//add_filter( 'post_type_link', 'vipx_remove_cpt_slug', 10, 3 );
function vipx_parse_request_tricksy( $query ) {
    // Only noop the main query
    if ( ! $query->is_main_query() )
        return;
    // Only noop our very specific rewrite rule match
    if ( 2 != count( $query->query )
        || ! isset( $query->query['page'] ) )
        return;
    // 'name' will be set if post permalinks are just post_name, otherwise the page rule will match
    if ( ! empty( $query->query['name'] ) )
        $query->set( 'post_type', array( 'post', 'activity-gallary', 'page' ) );
}
//add_action( 'pre_get_posts', 'vipx_parse_request_tricksy' );
function home_news() {
$args = array(
	'post_type' => 'post',
	'posts_per_page' => '3',
	'order' => 'DESC'
	);
	  $my_posts1 = new WP_Query( $args );
ob_start(); ?>
 <div class="media-posts">
  <?php while ( $my_posts1->have_posts() ) : $my_posts1->the_post() ?>
	<div class="gal-col all">
     <div class="pic-section">
		 <a class="read-more" href="<?php the_permalink();?>"><?php the_post_thumbnail( 'medium_large' );?></a>
       </div>
         <div class="text-box">
            <a class="read-more" href="<?php the_permalink();?>"><h3 class="sub-heading"><?php the_title();?></h3></a>
            <div class="news_date"><?php echo get_the_date();?></div>
            <a class="read-more text-link" href="<?php the_permalink();?>">Read More</a>
           </div>
        </div>
 	<?php endwhile;
 	   wp_reset_query();?>
</div>
<?php $content =  ob_get_clean();
    return $content;
}
add_shortcode("home_news", "home_news");
if ( function_exists( 'acf_add_options_page' ) ) {
	//acf_add_options_page( 'Global Settings' );
}
add_action('acf/init', 'my_acf_op_init');
function my_acf_op_init() {
    // Check function exists.
    if( function_exists('acf_add_options_page') ) {
        // Register options page.
        $option_page = acf_add_options_page(array(
            'page_title'    => __('Global Settings'),
            'menu_title'    => __('Global Settings'),
            'menu_slug'     => 'global-settings',
            'capability'    => 'edit_posts',
            'redirect'      => false
        ));
    }
}


function my_error_notice() { ?>
<div class="error notice">
	<p><?php _e( 'For More Options buy pro version <a href="https://www.sktthemes.net/shop/lms-wordpress-theme/" target="_blank">Buy Now</a>', 'complete');?></p>
</div>
<?php }
add_action( 'admin_notices', 'my_error_notice' );
function my_login_logo() { ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
            background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/assets/images/logo.png);
            width: 162px; height: 174px; background-size: 100%; background-color: transparent; padding: 0; background-position: center;
        }
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );
add_filter( 'login_headerurl', 'custom_loginlogo_url' );
function custom_loginlogo_url($url) {
    return home_url();
}
