<?php
/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */
defined( 'ABSPATH' ) || exit;
global $product;
if ( ! $product->is_purchasable() ) {
	return;
}
?>
<?php
echo wc_get_stock_html( $product ); // WPCS: XSS ok.
if ( $product->is_in_stock() ) :
$numleft  = $product->get_stock_quantity();
				if(($numleft)){
						if ( $numleft < 5 ) {
							echo "<div class='instocknew'>Only ".$numleft ." left in stock.</div>";
				}}
?>
	<?php do_action( 'woocommerce_before_add_to_cart_form' ); ?>
			<div class="pcs-info"><?php echo do_shortcode('[alg_wc_product_ppq_table]');?></div>
<div class="product-summary-form">
	<form class="cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data'>
		<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>
	<div class="product-quantity">
		<small>Quantity</small>
		<div class="number">
			<span class="minus" value="<?php echo esc_attr( $product->get_id() ); ?>" >-</span>
			<?php woocommerce_quantity_input(
			array(
			'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
			'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
			'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
			)
			);?>
			<span class="plus" value="<?php echo esc_attr( $product->get_id() ); ?>" >+</span>
		</div>
	</div>
		<?php do_action( 'woocommerce_after_add_to_cart_quantity' );
		?>
		<div class="btn-group">
			<button type="submit" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>" class="single_add_to_cart_button alt btn border-btn"><?php echo esc_html( $product->single_add_to_cart_text() ); ?></button>
		</div>
	</form>
	<form class="cart single-product" method="post" enctype='multipart/form-data' action="<?php echo esc_url(home_url( '/' ));?>checkout">
		<button type="submit"  class="single_add_to_cart_button alt btn btn-green">Buy Now</button>
		<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->id ); ?>" />
	</form>
</div>
<div class="urgencytrigger">
	<?php
		$urgency_trigger =  get_field('urgency_trigger');
	if($urgency_trigger == 'Select Tigger' ) { echo ''; }
	else{
		if($urgency_trigger == 'Other' ) {
			$tag_line = get_field('tag_line');
			echo $tag_line;
		}else{
			$field = get_field_object( 'urgency_trigger' );
			$value = $field['value'];
			$label = $field['choices'][ $value ];
			?>
			<span class="color-<?php echo esc_attr($value); ?>"><?php echo esc_html($label); ?></span>
			<?php }
		} ?>
</div>
<div class="availability">
	<div class="check-at">Check Availability At</div>
		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>
</div>
<div class="delovery-dec">
		<img src = "<?php  echo site_url() .'/wp-content/uploads/2022/12/visa-cards.png'; ?>" style = "max-width: 366px">
	</div>
	<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>
<?php endif;
  ?>
  <div id="counter-area">Real time <span id="counter"></span> visitors right now</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<script>
function r(t,r){return Math.floor(Math.random()*(r-t+1)+t)}
  var interval=1e3,variation=1,c=r(100,1e1);
  $("#counter").text(c),setInterval(function(){
    var t=r(+variation,variation);c+=t,$("#counter").text(c)
},interval);
</script>