<?php
/* Template Name: Registration1 Form */
/**
 * @snippet       WooCommerce User Registration Shortcode
 * @how-to        Get CustomizeWoo.com FREE
 * @author        Rodolfo Melogli
 * @compatible    WooCommerce 4.0
 * @donate $9     https://businessbloomer.com/bloomer-armada/
 */
?>
<?php if(is_user_logged_in()){
  wp_redirect(get_permalink(get_option('woocommerce_myaccount_page_id')));
} ?>
<?php get_header();?>
<?php do_action( 'woocommerce_before_customer_login_form' ); ?>
<div class="content-area">
<div class="container">
   <div class="login-box">
         <h1><?php esc_html_e( 'Sign Up', 'woocommerce' ); ?></h1>
         <form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action( 'woocommerce_register_form_tag' ); ?> >
            <?php do_action( 'woocommerce_register_form_start' ); ?>
            <?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>
            <div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
               <label for="reg_username"><?php esc_html_e( 'Username', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
               <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" placeholder="Enter your full name"/><?php // @codingStandardsIgnoreLine ?>
            </div>
            <?php endif; ?>
            <div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
               <label for="reg_email"><?php esc_html_e( 'Email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
               <input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" placeholder="Enter your email id"/><?php // @codingStandardsIgnoreLine ?>
            </div>
            <?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>
            <div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
               <label for="reg_password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
                <span class="password-input">
                   <input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" placeholder="Enter your password"/>
                </span>
               <span class="help-block">Your password should be a minimum of 6 characters long and contain atleast 1 number</span>
            </div>
            <?php else : ?>
            <div>
               <?php esc_html_e( 'A password will be sent to your email address.', 'woocommerce' ); ?>
            </div>
            <?php endif; ?>
            <?php do_action( 'woocommerce_register_form' ); ?>
            <div class="woocommerce-form-row form-row login-button">
               <?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
               <button type="submit" class="woocommerce-Button woocommerce-button button woocommerce-form-register__submit btn black-btn" name="register" value="<?php esc_attr_e( 'Register', 'woocommerce' ); ?>">
                  <span class="arrow-icon"><?php esc_html_e( 'Sign Up', 'woocommerce' ); ?></span>
               </button>
            </div>
            <div class="other-login"><span>Or</span></div>
            <a class="btn border-btn" href="<?php the_permalink('8')?>"><span class="arrow-icon">Login</span></a>
            <?php do_action( 'woocommerce_register_form_end' ); ?>
         </form>
      <!-- <?php $image_add = get_field('my-account_images');?>
      <?php if ( ! empty($image_add) ) {?>
      <div class="rgt-section">
         <?php // echo wp_get_attachment_image( $image_add['id'], 'full'); ?>
      </div>
      <?php  }?> -->
   </div>
</div>
</div>
<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
<?php get_footer();?>