<?php
/**
 * Order details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.6.0
 */

defined( 'ABSPATH' ) || exit;

$order = wc_get_order( $order_id ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited

if ( ! $order ) {
	return;
}

$order_items           = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
$show_purchase_note    = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', array( 'completed', 'processing' ) ) );
$show_customer_details = is_user_logged_in() && $order->get_user_id() === get_current_user_id();
$downloads             = $order->get_downloadable_items();
$show_downloads        = $order->has_downloadable_item() && $order->is_download_permitted();

if ( $show_downloads ) {
	wc_get_template(
		'order/order-downloads.php',
		array(
			'downloads'  => $downloads,
			'show_title' => true,
		)
	);
}
//wc_get_template( 'print-order/print-content.php', array( 'order' => $order ) );
?>
<div id="printTable" class="invoice-table">
<table table cellpadding="0" cellspacing="0" width="100%" class="listing-table">
	<thead>
		<tr>
			<td class="no">S. No.</td>
			<td class="description">Product Description</td>
			<td class="code">HSN code</td>
			<td class="quantity">Quantity</td>
			<td class="price">Price / unit</td>
			<td class="quantity">Discount %</td>
			<td class="quantity">Discount</td>
			<td class="value">Value</td>
			<td class="taxable">Taxable Value</td>
			<td class="discount" style="padding:0">
				<table table cellpadding="0" cellspacing="0" width="100%">
					<tr><td colspan="2" style="border-left:0; text-align:center;">Tax</td></tr>
					<tr>
						<td style="border-left: 0; border-bottom:0" width="50%">Rate</td>
						<td width="50%" style=" border-bottom:0">Amount</td>
					</tr>
				</table>
			</td>
		</tr>
	</thead>
	<tbody>
		<?php
		$i=1;
		foreach ($order->get_items() as $item_id => $item)
		{
			$product_id = $item->get_product_id();
			$variation_id = $item->get_variation_id();
			$product = $item->get_product();
			$product_name = $item->get_name();
			$quantity = $item->get_quantity();
			$subtotal = $item->get_subtotal();
			$tax = $item->get_subtotal_tax();
			$taxclass = $item->get_tax_class();
			$taxstat = $item->get_tax_status();
			$allmeta = $item->get_meta_data();
			$product_type = $item->get_type();

			if(!empty($product->sale_price)){
				$product_price = $product->sale_price;
			}else{
				$product_price = $product->regular_price;
			}
			$total = $quantity * $product_price;
			if($taxclass == 'gst'){

				$taxclass = 18;
			}

		if($order->get_discount_total() == 0){
			$discount = 0;
			$discount_item = 0;
			$net_value = $total;
			$taxable_value = $net_value/($taxclass+100)*100;
			}
			else {
					$discount = round(($order->get_discount_total()/$order->get_subtotal())*100).'%';
					$discount_item = ($total*$discount)/100;
					$net_value = $total - $discount_item;
					$taxable_value = $net_value/($taxclass+100)*100;
				}
				$total_discount += $discount_item;
				$total_net_value += $net_value;
				$total_taxable_value  += $taxable_value;
		?>
		<tr>
			<td class="no"><?php echo $i; ?></td>
			<td class="description"><?php echo $product_name; ?></td>
			<td class="code"><?php echo get_post_meta( $product_id , 'hsn_prod_id', true ) ?></td>
			<td class="quantity"><?php echo $quantity; ?></td>
			<td class="price"><?php echo $product_price; ?></td>
			<td class="quantity"><?php echo $discount; ?></td>
			<td class="quantity"><?php echo round($discount_item,2); ?></td>
			<td class="value"><?php echo round($net_value,2); ?></td>
			<td class="taxable"><?php echo round($taxable_value,2); ?></td>
			<td class="discount" style="padding:0">
				<div class="discount-box">
					<div class="rate"><?php echo $taxclass.'%'; ?></div>
					<div class="amount"><?php echo round($item->get_total_tax(),2); ?></div>
				</div>
			</td>
		</tr>
		<?php $i++;
		} ?>
		<tr>
			<td colspan="6"><strong>Total</strong></td>
			<td><?php echo round($total_discount); ?></td>
			<td><?php echo round($order->get_total()); ?></td>
			<td><?php echo round($total_taxable_value); ?></td>
			<td class="discount" style="padding:0">
				<div class="discount-box">
					<div class="rate"></div>
					<div class="amount"><?php echo round($order->get_cart_tax()); ?></div>
				</div>
			</td>
		</tr>
		<tr>
			<td colspan="8"><strong>Total amount in words</strong></td>
			<td><strong>Total Amount before Tax</strong></td>
			<td><?php echo round($total_taxable_value); ?></td>
		</tr>
		<tr>
			<?php
			$rowspan = 1;
			$order = new WC_Order( $order_id );
			$total = $order->get_total();
			//$f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
			//echo Yii::$app->formatter->asSpellout($total);
			//$total_in_words = $f->format($order->get_total()); // Total in words
			//print_r($order->get_tax_totals()['IN-KA-CGST-1']);
			 if(!empty($order->get_discount_total())  &&  !empty($order->get_tax_totals()['IN-IGST-2'])){
				$rowspan = 3;
			 }elseif(!empty($order->get_discount_total())  &&  !empty($order->get_tax_totals()['IN-KA-CGST-1'])){
				$rowspan = 4;
			 }elseif(!empty($order->get_discount_total())  &&  !empty($order->get_tax_totals()['IN-HR-CGST-1'])){
				$rowspan = 4;
			 }elseif(!empty($order->get_tax_totals()['IN-KA-CGST-1'])){
			    $rowspan = 3;
			 }elseif(!empty($order->get_tax_totals()['IN-HR-CGST-1'])){
			    $rowspan = 3;
			 }elseif(!empty($order->get_tax_totals()['IN-IGST-2'])){
			    $rowspan = 2;
			 }else{
			    $rowspan = 1;
			 }
			//$rowspan = 1;
			?>
			<td colspan="8"><?php echo numberTowords($total); ?></td>
			<td colspan="2" style="padding:0; border-bottom:0">
				<table style="border:0; padding: 0; margin:0" cellspacing="0" cellpadding="0">
					<?php
				if ($order->get_tax_totals()):

					foreach($order->get_tax_totals() as $code => $tax_total): ?>
						<tr>
						<td style="border:0; border-bottom:1px solid #DCDCDC; padding:10px"><?php echo $tax_total->label; ?></td>
						<td style="border:0; border-bottom:1px solid #DCDCDC; padding:10px"><?php echo round($tax_total->amount);?></td>
					</tr>
						<?php
						endforeach;
				endif;
			?>
				</table>
			</td>
		</tr>
		<?php 	$discount_l= get_field('cod_discount','option');

		if($discount_l == true){
   				 $chosen_payment_method = WC()->session->get('chosen_payment_method');
					if ($chosen_payment_method === 'razorpay') { ?>
		<tr>
			<td colspan="8" style="border: 0;"></td>
			<?php
					//$discount_label= get_field('cod_label', 'option');
					$discount_price= get_field('cod_discount_price', 'option');  ?>
			<td style="padding:10px"><strong>Pre Paid Discount</strong></td>
			<td style="padding:10px"><strong><?php echo '- '. $discount_price;?></strong></td>

		</tr>
		<?php }}?>
	<?php if(!empty($order->get_discount_total())):
			echo "<tr>"?>
			<td colspan="8" style="border: 0;"></td>
					<?php echo " <td><strong>Total Discount</strong></td>
					<td><strong>".round($total_discount)."</strong></td>
				</tr>";
		endif; ?>
			<tr>
				<td colspan="8" style="border: 0;"></td>
				<td style="padding:10px"><strong>Shipping Details</strong></td>
				<td style="padding:10px"><strong><?php echo $order->get_shipping_method(); ?></strong></td>
			</tr>
			<?php if(!empty($order->get_shipping_total())): ?>
			<tr>
				<td colspan="8" style="border: 0;"></td>
				<td style="padding:10px"><strong>Shipping Cost</strong></td>
				<td style="padding:10px"><strong><?php echo $order->get_shipping_total(); ?></strong></td>
			</tr>
			<?php endif; ?>
			<tr>
				<td colspan="8" style="border: 0;" ></td>
				<td><strong>Total Amount after Tax:</strong></td>
				<td><strong><?php  echo $order->get_total(); ?></strong></td>
			</tr>
 </tbody>
</table>
<?php
/**
 * Action hook fired after the order details.
 *
 * @since 4.4.0
 * @param WC_Order $order Order data.
 */
//do_action( 'woocommerce_after_order_details', $order );
if ( is_checkout() && !empty( is_wc_endpoint_url('order-received') ) ) {
}else{
if ( $show_customer_details ) {
	wc_get_template( 'order/order-details-customer.php', array( 'order' => $order ) );
}
}
?>
</div>
