<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="login-box">

	<?php
	do_action( 'woocommerce_before_customer_login_form' ); ?>

	<!-- <?php// if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>
	<?php //endif; ?> -->

	<div class="u-columns" id="customer_login">
		<div class="u-column1 col-1">
			<h1><?php esc_html_e( 'Login', 'woocommerce' ); ?></h1>
			<form class="woocommerce-form woocommerce-form-login login" method="post">
				<?php do_action( 'woocommerce_login_form_start' ); ?>
				<div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="username"><?php esc_html_e( 'Email ID', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
					<span class=""><input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" placeholder="Enter your email id"/></span>
				</div>
				<div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
					<input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" placeholder="Enter your password" />
					<!-- <i class="toggle-password fa fa-fw fa-eye-slash"></i> -->
				</div>
				<?php do_action( 'woocommerce_login_form' ); ?>
				<div class="form-row rememberme-row">
					<div class="custom-checkbox">
						<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
							<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e( 'Remember me', 'woocommerce' ); ?></span>
						</label>
					</div>
					<div class="woocommerce-LostPassword lost_password">
						<a class="text-link" href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Forgot Password', 'woocommerce' ); ?></a>
					</div>
				</div>
				<div class="form-row login-button">
					<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
					<button type="submit" class="woocommerce-button button woocommerce-form-login__submit btn black-btn" name="login" value="<?php esc_attr_e( 'Log in', 'woocommerce' ); ?>"><span class="arrow-icon"><?php esc_html_e( 'Log in', 'woocommerce' ); ?></span>
					</button>
				</div>
				<div class="other-login"><span>Or</span></div>
				<a class="btn border-btn" href="<?php the_permalink('101')?>"><span class="arrow-icon">Create an Account</span></a>
				<?php do_action( 'woocommerce_login_form_end' ); ?>
			</form>
		</div>
	</div>
	<!-- <?php// if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>
	<?php// endif; ?> -->

	<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
</div>
