<?php
/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

//die();
global $wpdb;
$user_id = get_current_user_id();
$filtered_result_rows = $wpdb->get_results("SELECT p.post_title, s.* FROM wp_ahm_download_stats s, wp_posts p WHERE s.pid = p.ID AND s.uid IN ($user_id) group by s.pid  order by `timestamp` desc");
/*echo '<pre>';
print_r($filtered_result_rows );
echo '</pre>';*/
?>
<div class="account-title">
	<h1>My Downloads</h1>
</div>
<?php
if(count($filtered_result_rows)>0) {
	?>
	<table class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table">
		<thead>
			<tr>
				<th>Package Name</th>
				<th>Download Time</th>
				<th>Download Link</th>
			</tr>
		</thead>
		
	<?php
	foreach ($filtered_result_rows as $stat) {
		//print_r($stat);
		?>
		<tr>
			<td data-title="Package Name"><?php echo $stat->post_title;?></td>
			<td data-title="Download Time"><?php echo  wp_date(get_option('date_format') . " " . get_option('time_format'), $stat->timestamp);?></td>
			<td data-title="Download Link">

				<?php 
				 $download_url =  WPDM()->package->getDownloadURL($stat->pid); 
				//print_r($download_url);
				//echo WPDM()->package->icon($stat->pid);  ?>
				<a class="download-file" rel='nofollow' href="<?php echo $download_url; ?>"> Download File <i class="icons download-icon"></i></a>

				<!-- <a href="#" class="download-file">Download File <i class="icons download-icon"></i></a> -->

			</td>
		</tr>
		<?php	
	}?>
		

	</table>
	
	<?php
	}else{?>
<div class="woocommerce-Message woocommerce-Message--info woocommerce-info download-mess">
	<div class="cnt"> No Download Yet!!</div>
	<a class="woocommerce-Button btn btn-gree" href="<?php echo site_url("downloads/");?>">
	Browse Download		
	</a>
</div>
<?php } ?>
