<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);
?>
<?php $current_user = wp_get_current_user();
	$current_user_id = get_current_user_id();
	$variable = get_field('specific_user_role_form','user_'.$current_user_id);

	if ( user_can( $current_user, "customer_portal" ) ) { 
	?>
		<div class="portal-form"><?php echo $variable ;?></div>
	<?php }
else
{ 
?>

<div class="dashboard">
	<div class="account-title">
		<h1>Account Information</h1>
	</div>
<div class="dashboard-inner">

	<div class="cont-info">
		<div class="lft">	
			Contact Information
		</div>
		<div class="rgt">	
			<a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-account' ) );?>">Edit Profile</a>
			<a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-account' ) );?>#changepasswords">Change password</a>
		</div>
	</div>	
	<?php
		global $current_user, $wp_roles;
		if ( $current_user > 0 ) {
			$role_name = $wp_roles->roles[reset($current_user->roles)]['name']; 
			$role_email = $wp_roles->roles[reset($current_user->roles)]['email']; ?>	
	<div class="flex-row">
		
		<div class="column">
			<div class="title">Full Name</div>
			<span class="fullname"><?php echo $current_user->user_firstname; ?> <?php echo $current_user->user_lastname; ?></span><br/>
		</div>
		<div class="column">
			<div class="title">User Name</div>
			<span><?php echo $current_user->user_login; ?></span>
		</div>
		<div class="column email">
			<div class="title">Email Id</div>
			<span class="email-id"><?php echo $current_user->user_email; ?></span>
		</div>
		
	</div>
	<?php }?>
		<!-- <span>Full Name</span><span>Email Id</span> -->
		
	</div>


</div>

<div class="addressbok">
<div class="account-title">
	<h2>ADDRESS BOOK</h2>
</div>	

<?php 
$customer_id = get_current_user_id();

if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing'  => __( 'Billing address', 'woocommerce' ),
			'shipping' => __( 'Shipping address', 'woocommerce' ),
		),
		$customer_id
	);
} else {
	$get_addresses = apply_filters(
		'woocommerce_my_account_get_addresses',
		array(
			'billing' => __( 'Billing address', 'woocommerce' ),
		),
		$customer_id
	);
}

$oldcol = 1;
$col    = 1;
?>
<?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) : ?>
	<div class="u-columns woocommerce-Addresses col2-set addresses">
<?php endif; ?>

<?php foreach ( $get_addresses as $name => $address_title ) : ?>
	<?php
		$address = wc_get_account_formatted_address( $name );
		$col     = $col * -1;
		$oldcol  = $oldcol * -1;
	?>

	<div class="u-column<?php echo $col < 0 ? 1 : 2; ?> col-<?php echo $oldcol < 0 ? 1 : 2; ?> woocommerce-Address">
		<header class="woocommerce-Address-title title">
			<h3><?php echo esc_html( $address_title ); ?></h3>
			<a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', $name ) ); ?>" class="edit"><?php echo $address ? esc_html__( 'Edit', 'woocommerce' ) : esc_html__( 'Add', 'woocommerce' ); ?></a>
		</header>
		<address>
			<div class="strng">
			<?php
				//echo $address ? wp_kses_post( $address ) : esc_html_e( 'You have not set up this type of address yet.', 'woocommerce' );
			echo $address; ?></div>
		</address>
	</div>

<?php endforeach; ?>

<?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) : ?>
	</div>
	<?php
endif;



?>
</div>
<?php } ?>
