<?php
/* Template Name: Home Page Template */
get_header();
if(wp_is_mobile()){
?>
<section class="home-banner mymobile">
		<div class="hero-slider">
			<?php
			 while ( have_rows('slider_images') ) : the_row();
				$num++;
				$image 	= get_sub_field('mobile_image');
				$url = get_sub_field('url');
				$externalUrl = get_sub_field('external_url');
				$linkType = get_sub_field('link_type');
				echo '<div>';
				if($linkType == 'Internal') {
				echo '<a href="'.$url.'"><img src="'.$image['url'].'" class="" wif/></a>';
				} else {
					echo '<a href="'.$externalUrl.'" target="_blank"><img src="'.$image['url'].'" class="" alt="'.$image['alt'].'"/></a>';
				}
				echo '</div>';
			endwhile;
		 	wp_reset_query();?>
		</div>
</section>
<?php
}else{
?>
<section class="home-banner">
		<div class="hero-slider">
			<?php
			 while ( have_rows('slider_images') ) : the_row();
				$num++;
				$image 	= get_sub_field('image');
				$url = get_sub_field('url');
				$externalUrl = get_sub_field('external_url');
				$linkType = get_sub_field('link_type');
				echo '<div>';
				if($linkType == 'Internal') {
				echo '<a href="'.$url.'"><img src="'.$image['url'].'" class="newclass" alt="'.$image['alt'].'"/></a>';
				} else {
					echo '<a href="'.$externalUrl.'" target="_blank"><img src="'.$image['url'].'"  class="newclass"  alt="'.$image['alt'].'" /></a>';
				}
				echo '</div>';
			endwhile;
			wp_reset_query();?>
		</div>
	</section>
<?php } ?>
<section class="white-bg bestseller-bx">
			<div class="small-container">
				<h2 class="section-heading">Bestsellers</h2>
				<div class="product_slider">
				<?php
					 $args = array(
						'post_type'      => 'product',
						'posts_per_page' => -1,
						'post_status' => 'publish',);
					$loop = new WP_Query( $args );
					while ( $loop->have_posts() ) : $loop->the_post();
						global $product; ?>
						<div>
						<div class="slide-box">
							<?php $imgp = woocommerce_get_product_thumbnail(); ?>
							<div class="product-img">
								<a href="<?php the_permalink(); ?>"><?php echo $imgp; ?></a>
							</div>
							<div class="product-details">
								<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
								<?php $flavour_text = get_field('product_flavour_text');
									if ( !empty($flavour_text) ) {?>
										<div class="product-flavour"><?php echo $flavour_text; ?></div>
									<?php }?>
								<p><?php the_excerpt(); ?></p>
								<div class="category">
									<?php $catTerms = get_the_terms( $post->ID, 'product_cat' );
										$cat_slug = $catTerms[0]->slug;
										?>
										<?php $cat_color=get_field('title_content_color', $catTerms[0]); ?>
									<span class="category-name"style="background-color:<?php echo $cat_color ?>">
										<?php echo $catTerms[0]->name;?></span>
								</div>
								<div class="price-review">
									<div class="pro-price">
										<div class="product-price">
											<?php 	echo '<div class="mrp">'.$price_html = $product->get_price_html().'</div>';
										show_sale_percentage_loop();?>
										</div>
										<div class="taxes">(inclusive of all taxes)</div>
									</div>
								</div>
								<?php if($product->is_in_stock()){?>
								<div class="btn-group">
									<div class="sml-add-to-cart-wrap">
										<a href="?add-to-cart=<?php echo esc_attr( $product->id ); ?>" data-quantity="1" class="button product_type_simple add_to_cart_button ajax_add_to_cart btn cart-btn" data-product_id="<?php echo esc_attr( $product->id ); ?>" data-product_sku="" aria-label="Add “<?php echo esc_attr( $product->name ); ?> to your cart" rel="nofollow">
										Add to cart</a>
									</div>
									<form class="cart single-product" method="post" enctype='multipart/form-data' action="<?php echo esc_url(home_url( '/' ));?>checkout">
										<button type="submit"  class="single_add_to_cart_button alt btn btn-green">Buy Now</button>
										<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->id ); ?>" />
									</form>
								</div>
								<?php }else {
									echo "<p class='stock out-of-stock'>Out of Stock</p>";
								}?>
							</div>
						</div>
					</div>
				  <?php  endwhile;
					wp_reset_query();
				?>
				</div><!-- .product_slider End--->
			</div><!-- .small-container End--->
		</section><!-- .white-bg End--->
		<section class="shopping-benefits">
			<div class="container">
				<ul>
					<li>
						<figure><img src="<?php bloginfo('template_url'); ?>/assets/images/plant-based-protein.svg" alt="plant based protein"></figure>
						<span>Plant-based <br>  protein</span>
					</li>
					<li>
						<figure><img src="<?php bloginfo('template_url'); ?>/assets/images/combination-science.svg" alt="ombination science"></figure>
						<span>Combination of Ayurveda and modern science</span>
					</li>
					<li>
						<figure><img src="<?php bloginfo('template_url'); ?>/assets/images/clinically-proven-ingredients.svg" alt="clinically proven ingredients"></figure>
						<span> Clinically-proven <br> ingredients</span>
					</li>
					<li>
						<figure><img src="<?php bloginfo('template_url'); ?>/assets/images/not-tested-animals.svg" alt="not tested animals"></figure>
						<span>Not tested on <br>  animals</span>
					</li>
				</ul>
			</div>
		</section>
		<section class="gray-bg">
			<div class="small-container">
				<h2 class="section-heading js-scroll fade-in-bottom">Shop By Category</h2>
				<ul class="category-section js-scroll fade-in-bottom">
						<?php
							$cat_style = '';
							$terms = get_terms( array(
							'taxonomy' => 'product_cat',
							'posts_per_page'=> 6,
							'hide_empty' => false,
							) );
							foreach ($terms as $key => $value)
							{
								$metaterms = get_term_meta($value->term_id);
								$thumbnail_id = get_woocommerce_term_meta($value->term_id, 'thumbnail_id', true );
								$image = wp_get_attachment_url( $thumbnail_id );
                            	$cat_color= get_field('title_content_color',$value); ?>
								<li>
									<a href="<?php echo get_category_link($value->term_id); ?>">
										<div class="category-icon icon1">
											<?php	echo '<img src="'.$image.'" alt="" />';?>
										</div>
										<div class="button catbg<?php echo $key; ?>" style="background-color:<?php echo $cat_color; ?>"><?php echo $value->name; ?>
										</div>
									</a>
									<?php
									$cat_style .= 'ul.category-section li a:hover .button.catbg'.$key.'{border:2px solid '.$cat_color.'; color: '.$cat_color.' !important; background-color: #fff !important;} ';
									?>
								</li>
					      <?php } ?>
					</ul>
			</div>
			<style><?php echo $cat_style;?></style>
		</section>
		<section class="white-bg videobox" style="display:none;">
			<div class="container">
				<div class="big-video js-scroll fade-in-bottom">
					<div class="lft">
						<?php $video = get_field('single_video_url');?>
					            <?php if(!empty( $video ) ): ?>
					            <iframe  src="<?php echo "https://www.youtube.com/embed/".$video;?>" allowfullscreen width="267" height="370"></iframe>
					        <?php endif?>
					</div>
					<div class="rgt">
						<h4><?php echo  get_field('heading_video');?></h4>
						<p><?php echo get_field('description_video');?></p>
					</div>
				</div><!---big-video End--->
				<h2 class="section-heading js-scroll fade-in-bottom">Featured videos</h2>
				<ul class="video-list js-scroll fade-in-bottom">
					<?php
							$arg = array(
							'post_type' => 'video',
							'post_status' => 'publish',
							'posts_per_page'    => 3,
							'order'=>'desc'
							);
							$postgn = new WP_Query($arg);?>
							<?php while($postgn->have_posts()) : $postgn->the_post(); ?>
                              <?php $chapname = get_the_terms($post->ID, 'video_cat');?>
                             <?php $cat_color=get_field('title_content_color', $chapname[0]); ?>
					<li>
						<a href="<?php echo get_the_permalink();?>">
							<div class="video-box">
							<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/play-btn.png" class="play-btn" alt="play btn">
							<?php $video = get_field('video');?>
					        <?php if(!empty( $video ) ): ?>
					            <img src="https://i1.ytimg.com/vi/<?php echo $video;?>/maxresdefault.jpg" alt="maxresdefault">
					        <?php endif?>
							</div>
					     </a>
						<span class="category"style="background: <?php echo $cat_color; ?>;"><?php echo $chapname[0]->name; ?></span>
						<a style="color:black" href="<?php echo get_the_permalink();?>"><h4><?php the_title(); ?></h4></a>
						<p><?php echo substr(strip_tags($post->post_content), 0, 75);?></p>
						<div class="d-inline"><a href="<?php echo get_the_permalink();?>" class="read-more">Watch Now</a></div>
					</li>
                        <?php endwhile; ?>
				</ul>
				<div class="align-center">
					<a href="<?php echo site_url('video')?>" class="btn btn-black view-all"><span>View All</span></a>
				</div>
			</div>
		</section>
		<section class="blog-section js-scroll fade-in-bottom">
			<div class="blog_slider">
				<?php
                $arg = array(
                'post_type'=> 'post',
                'posts_per_page'=> 5,
                'order'   => 'desc'
                );
                $newpost = new WP_Query($arg);
                 ?>
                 <?php while($newpost->have_posts()) : $newpost->the_post(); ?>
                 <div>
					<div class="img-box"><?php zigcy_lite_post_thumbnail();?></div>
					<div class="inner-box">
						<div class="cnt-box js-scroll fade-in-bottom">
							<h4><?php the_title(); ?></h4>
							<div class="category">
							 <?php $categories = get_the_category( $post->ID );
                            ?>
                            <?php $cat_color=get_field('title_content_color', $categories[0]); ?>
                           <span style="background-color:<?php echo $cat_color ?>"><?php echo $categories[0]->name; ?></span>
							</div>
							<p><?php echo wp_trim_words( get_the_content(), 32 ); ?></p>
							<div class="more-btn">
								<a href="<?php the_permalink() ?>" class="read-more">Read More</a>
							</div>
						</div>
					</div>
				</div>
				 <?php
		            endwhile;
		            wp_reset_postdata();
		            ?>
        <!---div End--->
			</div><!---blog_slider End--->
			<div class="align-center">
				<a href="<?php echo site_url('blog');?>" class="btn btn-black view-all"><span>All Blogs</span></a>
			</div>
		</section>
		<section class="gray-bg home-testimonial">
			<div class="small-container">
				<h2 class="section-heading js-scroll fade-in-bottom">Testimonials</h2>
				<div class="testimonial_slider js-scroll fade-in-bottom">
					<?php  $arg = array(
			                'post_type'         => 'testimonials',
			                'posts_per_page'    => 10,
			                'orderby'           => 'date',
			                'order'             => 'DESC'
			                );
			                $testimonials = new WP_Query($arg);
			            ?>
			            <?php while($testimonials->have_posts()) : $testimonials->the_post(); ?>
					<div>
						<div class="slide-box">
							<div class="img-box"><?php the_post_thumbnail( 'new-image-name' ); ?></div>
							<div class="cnt-box">
								<div class="cnt testimonial-cnt">
								<p><?php echo  get_the_content(); ?></p>
								</div>
								<span class="name"><?php echo get_the_title(); ?></span>
								<span class="designation"><?php echo get_field("designation"); ?></span>
							</div>
						</div>
					</div><!---div End--->
					<?php endwhile; wp_reset_query(); ?>
				</div>
			</div>
		</section>
		<section class="recentview">
			<div class="container">
				 <?php  echo do_shortcode('[woocommerce_recently_viewed_products]'); ?>
		</div>
		</section>
		<?php /*<section class="club-stories">
			<h2 class="section-heading js-scroll fade-in-bottom"><?php echo  get_field('instagram_heading'); ?></h2>
			<?php
               $short = get_field('instagram_shortcode');
			?>
			<div class="instagram-post"><?php //echo do_shortcode($short); ?></div>
		</section>
		* */ ?>
		<section class="white-bg ffg">
			<div class="small-container">
				<h2 class="section-heading js-scroll fade-in-bottom">In Media</h2>
				<div class="media_slider 	js-scroll fade-in-bottom">
					<?php
			                $arg = array(
			                'post_type'         => 'medias',
			                'posts_per_page'    => 10,
			                'order'             => 'DESC'
			                );
			                $medias = new WP_Query($arg);
			            ?>
			            <?php while($medias->have_posts()) : $medias->the_post(); ?>
					<div>
						<div class="slide-box">
							<div class="img-box"><?php the_post_thumbnail( 'new-image-name' ); ?></div>
							<div class="cnt-box">
								<?php
                                echo wp_trim_words( get_the_content(), 27);?>
								<?php
								$link = get_field('read_more_link');
								if( $link ):
									$link_url = $link['url'];
									$link_target = $link['target'] ? $link['target'] : '_blank';
									?>
									<div class="more-btn">
										<a class="read-more" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>">Read More</a>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div><!---div End--->
					<?php endwhile;  wp_reset_query(); ?>
				</div><!---media_slider End--->
			</div>
		</section>
<section class="faq-section">
	<div class="container">
	  <h2 class="section-heading js-scroll fade-in-bottom">FAQs</h2>
		<div id="accordion" class="accordion-container js-scroll fade-in-bottom">
			 <?php if( have_rows('faqs_template') ):
				while ( have_rows('faqs_template') ) : the_row();?>
			<article class="content-entry">
				<h4 class="article-title"><?php echo get_sub_field('title');?></h4>
				<div class="accordion-content">
					<p><?php echo get_sub_field('contents');?></p>
				</div>
			</article>
			 <?php
			endwhile;
			endif;
		   ?>
		</div>
	</div>
</section>
<?php get_footer(); ?>
