<?php
/**
 * Order details table shown in emails.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-order-details.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates\Emails
 * @version 3.7.0
 */

defined( 'ABSPATH' ) || exit;

$text_align = is_rtl() ? 'right' : 'left';

//do_action( 'woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text, $email ); ?>

<h2>
	<?php
	if ( $sent_to_admin ) {
		$before = '<a class="link" href="' . esc_url( $order->get_edit_order_url() ) . '">';
		$after  = '</a>';
	} else {
		$before = '';
		$after  = '';
	}
	/* translators: %s: Order ID. */
	echo wp_kses_post( $before . sprintf( __( '[Order #%s]', 'woocommerce' ) . $after . ' (<time datetime="%s">%s</time>)', $order->get_order_number(), $order->get_date_created()->format( 'c' ), wc_format_datetime( $order->get_date_created() ) ) );
	?>
</h2>

<div style="margin-bottom: 40px;">
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
		<thead>
			<tr>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'HSN code', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Quantity', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Price', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Discount%', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Discount', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Value', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Taxable Value', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Tax Rate', 'woocommerce' ); ?></th>
				<th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Tax', 'woocommerce' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
		

			foreach ( $order->get_items() as $item_id => $item ) {


                                 $product_id = $item->get_product_id();
                                 $variation_id = $item->get_variation_id();
                                 $product = $item->get_product();
                                 $product_name = $item->get_name();
                                 $quantity = $item->get_quantity();
                                 $subtotal = $item->get_subtotal();
                                 $tax = $item->get_subtotal_tax();
                                 //$total = $quantity * $product->sale_price + $tax;


                                 $taxclass = $item->get_tax_class();
                                 $taxstat = $item->get_tax_status();
                                 $allmeta = $item->get_meta_data();
                                 $somemeta = $item->get_meta( '_whatever', true );
                                 $product_type = $item->get_type();
                                 $taxable = $total + $tax ;



                                 if(!empty($product->sale_price)){
                                 	$product_price = $product->sale_price;
                                 }else{
                                 	$product_price = $product->regular_price;
                                 }
                                 $total = $quantity * $product_price;
                                 if($taxclass == 'gst'){

                                       $taxclass = 18;
                                 }

                               if($order->get_discount_total() == 0){
                                   $discount = 0;
                                   $discount_item = 0;
                                   $net_value = $total;
                                   $taxable_value = $net_value/($taxclass+100)*100;
                               	}else{
                               $discount = round(($order->get_discount_total()/$order->get_subtotal())*100).'%';
                               //$total = ceil(($quantity * $product_price)*(100-$discount)/100);

                               $discount_item = ($total*$discount)/100;

                               $net_value = $total - $discount_item;

                               $taxable_value = $net_value/($taxclass+100)*100;



                               }

                               $total_discount += $discount_item;

                               $total_net_value += $net_value;

                               $total_taxable_value  += $taxable_value;



                                 ?>



			<tr>
				<td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo $product_name; ?></td>
				<td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo get_post_meta( $product_id , 'hsn_prod_id', true ) ?></td>
				<td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo $quantity; ?></td>
				<td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo $product_price; ?></td>
				<td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo $discount; ?></td>
				<td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo round($discount_item,2); ?></td>
				<td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo round($net_value,2); ?></td>
				<td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo round($taxable_value,2); ?></td>
            <td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo $taxclass.'%'; ?></td>
				<td class="x_td" style="color:#636363; border:1px solid #e5e5e5; padding:12px; text-align:left; vertical-align:middle; font-family:'Helvetica Neue',Helvetica,Roboto,Arial,sans-serif; word-wrap:break-word"><?php echo round($item->get_total_tax(),2); ?></td>
			</tr>
			<?php } ?>
		</tbody>
		<tfoot>
			       <tr>
						<th class="td" scope="row" colspan="5" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>">Subtotal:</th>
						<td class="td"><?php echo round($total_discount);  ?></td>
						<td class="td"><?php echo round($total_net_value); ?></td>
						<td class="td"><?php echo round($total_taxable_value); ?></td>
						<td class="td"></td>
						<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php if(!empty($order->get_tax_totals())){
							echo round($order->get_total_tax());
						}?></td>
					</tr>
					<?php 	$discount_l= get_field('cod_discount','option');
							if($discount_l == true){
   							 $chosen_payment_method = WC()->session->get('chosen_payment_method');
							if ($chosen_payment_method === 'razorpay') { ?>
							<tr>	<?php
								$discount_label= get_field('cod_label', 'option');
								$discount_price= get_field('cod_discount_price', 'option');  ?>
								<td class="td" scope="row" colspan="9" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><strong>Pre Paid Discount</strong></td>
								<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><strong><?php echo '- '. $discount_price;?></strong></td>
							</tr>
						<?php }}?>
					<tr>
						<th class="td" scope="row" colspan="9" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>">Shipping:</th>
						<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>">Free shipping</td>
					</tr>

					<tr>
						<th class="td" scope="row" colspan="9" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>">Payment Method:</th>
						<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo strtoupper($order->get_payment_method()); ?></td>
					</tr>
					<?php if(!empty($order->get_discount_total())){?>
                     <tr>
						<th class="td" scope="row" colspan="9" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>">Total Discount:</th>
						<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo ceil($total_discount); ?></td>
					</tr>


					<?php
					}
					if ($order->get_tax_totals()):
					foreach($order->get_tax_totals() as $code => $tax_total):
						?>
					<tr>
						<th class="td" scope="row" colspan="9" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo $tax_total->label; ?></th>
						<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo round($tax_total->amount); ?></td>
					</tr>
					<?php
                 endforeach;
                 endif;

					 ?>
					 <tr>
						<th class="td" scope="row" colspan="9" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>">Total:</th>
						<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo ceil($order->get_total()); ?></td>
					</tr>



			<?php
			if ( $order->get_customer_note() ) {
				?>
				<tr>
					<th class="td" scope="row" colspan="9" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Note:', 'woocommerce' ); ?></th>
					<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></td>
				</tr>
				<?php
			}
			?>
		</tfoot>
	</table>
</div>
